/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import org.apache.log4j.Logger;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.HorizontalVerticalInput;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemSimulation;

public class HorizontalVerticalAntenna
implements AntennaGainPlugin<HorizontalVerticalInput> {
    private static final Logger LOG = Logger.getLogger(HorizontalVerticalAntenna.class);

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, HorizontalVerticalInput input, Validator validator) {
        OptionalValue<Function> vertical;
        OptionalValue<Function> horizontal = input.horizontal();
        if (horizontal.isRelevant()) {
            Bounds bounds = horizontal.getValue().getBounds();
            if (bounds.getMin() != 0.0 || bounds.getMax() != 360.0) {
                validator.error("Antenna pattern must be specified from point 0.0 to 360.0");
            }
            if (horizontal.getValue().evaluateMax() > 0.0) {
                validator.error("<br/>Horizontal: The values of the antenna gain pattern must be relative  to peak gain (i.e. &le 0 dB).");
            }
        }
        if ((vertical = input.vertical()).isRelevant() && vertical.getValue().evaluateMax() > 0.0) {
            validator.error("<br/>Vertical: The values of the antenna gain pattern must be relative  to peak gain (i.e. &le 0 dB).");
        }
    }

    @Override
    public double evaluate(LinkResult context, AntennaResult antenna, double peakGain, HorizontalVerticalInput input) {
        boolean compensationToConsider;
        double theta;
        OptionalValue<Function> horizontal = input.horizontal();
        OptionalValue<Function> vertical = input.vertical();
        double gain = 0.0;
        double phi = antenna.getAzimuth();
        double thetaH = theta = antenna.getElevation();
        double phiH = phi;
        double beta = -antenna.getTilt();
        double compensation = -antenna.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(antenna.getTilt(), 0.0, 1.0E-5) || compensationToConsider) {
            double tilt = beta;
            if (compensationToConsider) {
                tilt = GenericSystemSimulation.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
            }
            theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antenna.getAzimuth()) * Mathematics.sinD(tilt));
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(beta) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            phi = antenna.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        }
        double horiGain = 0.0;
        double vertiGain = 0.0;
        if (horizontal.isRelevant()) {
            horiGain = horizontal.getValue().evaluate(phi);
            if (LOG.isDebugEnabled()) {
                // empty if block
            }
        }
        if (vertical.isRelevant()) {
            vertiGain = vertical.getValue().evaluate(theta);
            if (LOG.isDebugEnabled()) {
                // empty if block
            }
        }
        gain = peakGain + horiGain + vertiGain;
        if (LOG.isDebugEnabled()) {
            // empty if block
        }
        return gain;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Horizontal-Vertical Gain", "Based on the direction of the antenna uses the horizontal and/or vertical pattern to find the peak gain");
    }
}

