/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.ITU_R_F1245Input;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.hybrid.HybridCellularSimulation;

public class ITU_R_F1245
implements AntennaGainPlugin<ITU_R_F1245Input> {
    private static final Logger LOG = Logger.getLogger(ITU_R_F1245.class);

    @Override
    public double evaluate(LinkResult context, AntennaResult antennaResult, double peakGain, ITU_R_F1245Input input) {
        double gain;
        double diameterToLambda;
        double phi;
        double theta;
        boolean compensationToConsider;
        double phiH = antennaResult.getAzimuth();
        double thetaH = antennaResult.getElevation();
        double beta = -antennaResult.getTilt();
        double compensation = -antennaResult.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(beta, 0.0, 1.0E-5) || compensationToConsider) {
            double tilt = beta;
            if (compensationToConsider) {
                tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
            }
            theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
            if (phiH > 180.0) {
                phiH = -360.0 + phiH;
            }
            phi = Mathematics.acosD(Math.min(1.0, Math.max(-1.0, (-Mathematics.sinD(thetaH) * Mathematics.sinD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(phiH) * Mathematics.cosD(tilt)) / Mathematics.cosD(theta))));
            phi = antennaResult.getAzimuth() > 180.0 ? 360.0 - phi : phi;
        } else {
            theta = thetaH;
            phi = phiH;
        }
        double phiSpherical = Mathematics.acosD(Mathematics.cosD(theta) * Mathematics.cosD(phi));
        if (input.diameter().isRelevant()) {
            diameterToLambda = input.diameter().getValue() * context.getFrequency() / 300.0;
            peakGain = input.apertureEfficiency().isRelevant() ? 10.0 * Math.log10(input.apertureEfficiency().getValue() * Math.PI * Math.PI * diameterToLambda * diameterToLambda) : 7.7 + 20.0 * Math.log10(diameterToLambda);
        } else {
            diameterToLambda = Math.pow(10.0, (peakGain - 7.7) / 20.0);
        }
        double g1 = 2.0 + 15.0 * Math.log10(diameterToLambda);
        double phiM = 20.0 / diameterToLambda * Math.sqrt(peakGain - g1);
        double phiR = 12.02 * Math.pow(diameterToLambda, -0.6);
        if (!input.useAnnex1()) {
            gain = diameterToLambda > 100.0 ? (phiSpherical < phiM ? peakGain - 0.0025 * (diameterToLambda * phiSpherical) * (diameterToLambda * phiSpherical) : (phiSpherical < Math.max(phiM, phiR) ? g1 : (phiSpherical < 48.0 ? 29.0 - 25.0 * Math.log10(phiSpherical) : -13.0))) : (phiSpherical < phiM ? peakGain - 0.0025 * (diameterToLambda * phiSpherical) * (diameterToLambda * phiSpherical) : (phiSpherical < 48.0 ? 39.0 - 5.0 * Math.log10(diameterToLambda) - 25.0 * Math.log10(phiSpherical) : -3.0 - 5.0 * Math.log10(diameterToLambda)));
        } else {
            double gainA = peakGain - 0.0025 * (diameterToLambda * phiSpherical) * (diameterToLambda * phiSpherical);
            double constant = 4.71238898038469;
            if (diameterToLambda > 100.0) {
                phiR = 15.85 * Math.pow(diameterToLambda, -0.6);
                double factorF = 10.0 * Math.log10(0.9 * Math.sin(constant * phiSpherical / phiR) * Math.sin(constant * phiSpherical / phiR) + 0.1);
                double gainB = g1 + factorF;
                gain = phiSpherical < phiR ? Math.max(gainA, gainB) : (phiSpherical < 48.0 ? 32.0 - 25.0 * Math.log10(phiSpherical) + factorF : -10.0 + factorF);
            } else {
                phiR = 39.8 * Math.pow(diameterToLambda, -0.8);
                double factorF = 10.0 * Math.log10(0.9 * Math.sin(constant * phiSpherical / phiR) * Math.sin(constant * phiSpherical / phiR) + 0.1);
                double gainB = g1 + factorF;
                gain = phiSpherical < phiR ? Math.max(gainA, gainB) : (phiSpherical < 48.0 ? 42.0 - 5.0 * Math.log10(diameterToLambda) - 25.0 * Math.log10(phiSpherical) + factorF : -5.0 * Math.log10(diameterToLambda) + factorF);
            }
        }
        if (LOG.isDebugEnabled()) {
            String msg = " ";
            msg = msg + (input.diameter().isRelevant() ? "Antenna diameter = " + input.diameter().getValue() + " m; " : "");
            msg = msg + (input.apertureEfficiency().isRelevant() ? "Aperture efficiency = " + input.apertureEfficiency().getValue() + " m; " : "");
            msg = msg + (input.useAnnex1() ? "statistical interference assessment enabled; " : "");
            LOG.debug(msg);
        }
        return gain;
    }

    private double convertAngleToConfineToVerticalDefinedRange(double angle) {
        if (angle < -90.0) {
            return -(angle += 180.0);
        }
        if (angle > 90.0) {
            return -(angle -= 180.0);
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, ITU_R_F1245Input input, Validator validator) {
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        RadioSystem system = context.getSystem();
        Bounds freqRange = frequency.getBounds();
        if (freqRange.getMax() > 70000.0 || freqRange.getMin() < 1000.0) {
            validator.error("Check Frequency: The antenna is designed for the frequency range 1 GHz to about 70 GHz.");
        }
        double tGain = Double.MAX_VALUE;
        if (context.getContextObject() instanceof Receiver) {
            tGain = ((Receiver)context.getContextObject()).getAntennaGain().peakGain();
            double hRX = ((Receiver)context.getContextObject()).getHeight().getBounds().getMin();
            if (hRX < 20.0) {
                validator.error("Check antenna height: it seems unlikely that the antenna is close to the street level");
            }
        } else if (context.getContextObject() instanceof Transmitter) {
            tGain = ((Transmitter)context.getContextObject()).getAntennaGain().peakGain();
            double hTX = ((Transmitter)context.getContextObject()).getHeight().getBounds().getMin();
            if (hTX < 20.0) {
                validator.error("Check antenna height: it seems unlikely that the antenna is close to the street level");
            }
        }
        if (input.diameter().isRelevant()) {
            if (input.diameter().getValue() < 0.1) {
                validator.error("Check antenna gain: a diameter of less than 0.1 m seems too small");
            }
            if (input.apertureEfficiency().isRelevant()) {
                if (input.apertureEfficiency().getValue() < 0.35) {
                    validator.error("Check antenna gain: the aperture efficiency should be at least 0.35");
                }
                if (input.apertureEfficiency().getValue() > 0.9) {
                    validator.error("Check antenna gain: the aperture efficiency should be limited to 0.9");
                }
            }
        } else if (tGain < 15.0) {
            validator.error("Check antenna gain: <b style = 'color:blue;'>a peak gain less than 15 dBi seems unlikely for FS antennas</b>");
        }
        if (context.getSystemPlugin() instanceof HybridCellularSimulation) {
            validator.error("This antenna is mainly for Fixed Service systems and therefore less suitable to Cellular Systems");
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R F.1245-2", "<HtMl>Average side-lobe of rotationally symmetrical antennas in the frequency range 1 ... 70 GHz.<ul><li><u>Note 1:</u> it does not take account of NOTE 7 of the <br/>Recommendation ITU-R F.1245-2 (omni-directional).</li><li><u>Note 2:</u> you may use the provisional approach of <br/>Annex 1 for spatial statistical analysis.</li></ul><br/><i>You may move the cursor over the parameter names to get additional information</i></br>");
    }
}

