/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.antenna;

import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.ConstantDistribution;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.antenna.ITU_R_F1336_4_rec_2_Input;
import org.seamcat.model.plugin.antenna.TiltModes;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class ITU_R_F1336_4_rec_2
implements AntennaGainPlugin<ITU_R_F1336_4_rec_2_Input> {
    private static final Logger LOG = Logger.getLogger(ITU_R_F1336_4_rec_2.class);

    @Override
    public double evaluate(LinkResult context, AntennaResult antennaResult, double peakGain, ITU_R_F1336_4_rec_2_Input input) {
        double theta3;
        boolean compensationToConsider;
        double thetaH = antennaResult.getElevation();
        double k = input.k();
        double theta = thetaH;
        double beta = -antennaResult.getTilt();
        double compensation = -antennaResult.getElevationCompensation();
        boolean bl = compensationToConsider = context instanceof InterferenceLinkResult && !Mathematics.equals(compensation, 0.0, 1.0E-5);
        if (!Mathematics.equals(beta, 0.0, 1.0E-5) || compensationToConsider) {
            double tilt;
            if (input.mAnde()) {
                tilt = beta;
                if (compensationToConsider) {
                    tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
                }
                theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
                if (!Mathematics.equals(beta, 0.0, 1.0E-5)) {
                    thetaH = theta;
                    double additionalAngle = -input.additionalTilt().trial();
                    if (Mathematics.equals(Math.abs(additionalAngle), 90.0, 1.0E-5)) {
                        additionalAngle = additionalAngle < 0.0 ? (additionalAngle += 1.0E-4) : (additionalAngle -= 1.0E-4);
                    }
                    theta = thetaH + additionalAngle >= 0.0 ? 90.0 * (thetaH + additionalAngle) / (90.0 + additionalAngle) : 90.0 * (thetaH + additionalAngle) / (90.0 - additionalAngle);
                }
            } else if (input.tiltMode() == TiltModes.ELECTRICAL_ONLY) {
                if (Mathematics.equals(Math.abs(beta), 90.0, 1.0E-5)) {
                    beta = beta < 0.0 ? (beta += 1.0E-4) : (beta -= 1.0E-4);
                }
                theta = thetaH + beta >= 0.0 ? 90.0 * (thetaH + beta) / (90.0 + beta) : 90.0 * (thetaH + beta) / (90.0 - beta);
                if (compensationToConsider) {
                    thetaH = theta;
                    theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(compensation) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(compensation));
                }
            } else if (input.tiltMode() == TiltModes.MECHANICAL_ONLY) {
                tilt = beta;
                if (compensationToConsider) {
                    tilt = this.convertAngleToConfineToVerticalDefinedRange(beta + compensation);
                }
                theta = Mathematics.asinD(Mathematics.sinD(thetaH) * Mathematics.cosD(tilt) + Mathematics.cosD(thetaH) * Mathematics.cosD(antennaResult.getAzimuth()) * Mathematics.sinD(tilt));
            }
        }
        double thetaAbs = Math.abs(theta);
        if (input.theta3().isRelevant()) {
            theta3 = input.theta3().getValue();
            peakGain = -10.0 * Math.log10(theta3 / 107.6);
        } else {
            theta3 = 107.6 * Math.pow(10.0, -peakGain / 10.0);
        }
        double theta4 = theta3 * Math.sqrt(1.0 - Math.log10(k + 1.0) / 1.2);
        double theta5 = theta3 * Math.sqrt(1.25 - Math.log10(k + 1.0) / 1.2);
        double gain = input.usePeak() ? (thetaAbs >= theta3 ? peakGain - 12.0 + 10.0 * Math.log10(Math.pow(thetaAbs / theta3, -1.5) + k) : (thetaAbs >= theta4 ? peakGain - 12.0 + 10.0 * Math.log10(k + 1.0) : peakGain - 12.0 * (theta / theta3) * (theta / theta3))) : (thetaAbs >= theta5 ? peakGain - 15.0 + 10.0 * Math.log10(Math.pow(thetaAbs / theta3, -1.5) + k) : (thetaAbs >= theta3 ? peakGain - 15.0 + 10.0 * Math.log10(k + 1.0) : peakGain - 12.0 * (theta / theta3) * (theta / theta3)));
        if (LOG.isDebugEnabled()) {
            String msg = " ";
            msg = msg + (input.usePeak() ? "peak envelope " : "averaged envelope ");
            msg = msg + "- at " + theta + " deg; ";
            msg = msg + "vertical beam width = " + theta3 + " deg; gain = " + gain + " dBi";
            if (!Mathematics.equals(beta, 0.0, 1.0E-5) || compensationToConsider) {
                msg = msg + " - tilt mode: " + (Object)((Object)input.tiltMode());
            }
            LOG.debug(msg);
        }
        return gain;
    }

    private double convertAngleToConfineToVerticalDefinedRange(double angle) {
        if (angle < -90.0) {
            return -(angle += 180.0);
        }
        if (angle > 90.0) {
            return -(angle -= 180.0);
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, ITU_R_F1336_4_rec_2_Input input, Validator validator) {
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        if (frequency.getBounds().getMin() < 400.0 || frequency.getBounds().getMax() > 70000.0) {
            validator.error("ITU-R F.1336-4 is defined only for the frequency range 400 MHZ ... 70 GHz");
        }
        if (frequency.getBounds().getMin() > 3000.0 && input.k() > 0.0) {
            validator.error("k = 0 is recommended for the frequency range above 3 GHz  ");
        }
        if (frequency.getBounds().getMax() < 3000.0 && Mathematics.equals(input.k(), 0.0, 0.01)) {
            validator.error("k = 0.7 is recommended for the frequency range below 3 GHz  ");
        }
        if (input.mAnde()) {
            RadioSystem system = context.getSystem();
            Bounds additional = input.additionalTilt().getBounds();
            if (additional.getMin() < -90.0 || additional.getMax() > 90.0) {
                validator.error("Elevation angles must be in the range -90 ... 90 degree");
            }
            double tilt = 100.0;
            String msg = "<HtMl><br/>You have specified an additional electrical tilt of " + input.additionalTilt() + " degrees.<br/>This value will be ignored due to the angle specified in 'Antenna elevation' is set to zero.";
            double constantAngle = 0.0;
            if (input.additionalTilt() instanceof ConstantDistribution) {
                constantAngle = ((ConstantDistribution)input.additionalTilt()).getConstant();
            }
            if (!(Mathematics.equals(constantAngle, 0.0, 0.001) && Mathematics.equals(additional.getMax(), additional.getMin(), 0.001) && Mathematics.equals(additional.getMax(), 0.0, 0.001))) {
                if (context.getSystemPlugin() instanceof GenericSystemPlugin) {
                    GenericSystemPlugin plugin = (GenericSystemPlugin)context.getSystemPlugin();
                    if (context.getContextObject() instanceof Receiver) {
                        tilt = plugin.getRxPointing().getElevation().trial();
                    } else if (context.getContextObject() instanceof Transmitter) {
                        tilt = plugin.getTxPointing().getElevation().trial();
                    }
                } else if (context.getSystemPlugin() instanceof HybridSystemPlugin) {
                    HybridSystemPlugin plugin = (HybridSystemPlugin)context.getSystemPlugin();
                    tilt = plugin.getBs().getTilt().trial();
                    msg = "<HtMl><br/>You have specified an additional electrical tilt of up to " + additional.getMax() + " degrees.<br/>This value will be ignored due to the angle specified in 'Antenna tilt' is set to zero.";
                }
                if (Mathematics.equals(tilt, 0.0, 1.0E-5)) {
                    validator.error(msg);
                }
            }
        }
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R F.1336-4 rec 2", "<HtMl>This plugin covers the ITU-R Recommendation F.1336-4 recommends 2 including the electrical tilt.<b>Please note that the additional electrical tilt is applicable only to an 'Antenna elevation'  not set equal to zero</b>.<br/><br><i>You may move the cursor over the parameter names to get additional information</i></br>");
    }
}

