/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.correlation;

import org.seamcat.model.correlation.CorrelationModeCalculator;
import org.seamcat.model.correlation.None;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.UniformPolarDistanceDistribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;

public enum NoneMode implements CorrelationMode
{
    MODE{

        public String toString() {
            return "None";
        }

        @Override
        public Point2D getCorrelationVector(InterferenceLink link, Results preSimulation) {
            CorrelationSetting settings = link.getCorrelationSettings();
            None none = settings.getCorrelationConfiguration(None.class);
            if (none.usePolygon()) {
                double rItVrDistTrial = none.pathDistanceFactor().trial();
                double rItVrAngleTrial = none.pathAzimuth().trial();
                double turnTrial = none.turnCCW().trial();
                double rRsimu = none.simulationRadius();
                rRsimu = CorrelationModeCalculator.shapeTransformer(turnTrial, rRsimu, none.shape(), rItVrAngleTrial);
                return new Point2D(Mathematics.cosD(rItVrAngleTrial), Mathematics.sinD(rItVrAngleTrial)).scale(rRsimu * rItVrDistTrial);
            }
            return this.itVrLocNonCorrelatedNoneMode(none.pathDistanceFactor(), none.protectionDistance(), none.pathAzimuth(), none.simulationRadius());
        }

        @Override
        public Bounds getBounds(InterferenceLink link) {
            None none = link.getCorrelationSettings().getCorrelationConfiguration(None.class);
            Distribution protectionDistance = none.protectionDistance();
            Distribution pathDistanceFactor = none.pathDistanceFactor();
            double min = 0.0;
            double max = none.simulationRadius();
            if (pathDistanceFactor.getBounds().isBounded()) {
                min = max * pathDistanceFactor.getBounds().getMin();
                max *= pathDistanceFactor.getBounds().getMax();
            }
            if (Mathematics.equals(max, min, 1.0E-5)) {
                min = 0.0;
            }
            if (protectionDistance.getBounds().getMax() > 0.0) {
                min = Math.min(min, protectionDistance.getBounds().getMin());
                max += protectionDistance.getBounds().getMax();
            }
            return new Bounds(min, max, true);
        }

        private Point2D itVrLocNonCorrelatedNoneMode(Distribution distanceFactor, Distribution protectionDistance, Distribution pathAzimuth, double rRsimu) {
            rRsimu *= distanceFactor.getBounds().getMax();
            double rItVrDistTrial = distanceFactor.getBounds().getMax() == 0.0 ? distanceFactor.trial() : distanceFactor.trial() / distanceFactor.getBounds().getMax();
            double rResultItVrDistance = 0.0;
            double pDistance = protectionDistance.trial();
            if (distanceFactor instanceof UniformPolarDistanceDistribution) {
                rRsimu = Math.sqrt(rRsimu * rRsimu + pDistance * pDistance);
                rResultItVrDistance = Math.sqrt((Math.pow(rRsimu, 2.0) - Math.pow(pDistance, 2.0)) * Math.pow(rItVrDistTrial, 2.0) + Math.pow(pDistance, 2.0));
            } else {
                rResultItVrDistance = rItVrDistTrial * (rRsimu - pDistance) + pDistance;
            }
            double rItVrAngleTrial = pathAzimuth.trial();
            double value = rItVrAngleTrial * Math.PI / 180.0;
            return new Point2D(rResultItVrDistance * Math.cos(value), rResultItVrDistance * Math.sin(value));
        }

        @Override
        public String information() {
            return "Note that changing mode will reset all correlation parameters";
        }
    };

}

