/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.factory.SeamcatRandom;
import org.seamcat.model.functions.Bounds;

public class GaussianDistributionImpl
extends AbstractDistribution
implements GaussianDistribution {
    private static final Bounds BOUNDS = new Bounds(0.0, 0.0, false);

    public GaussianDistributionImpl(double mean, double stdDev) {
        super(0.0, 0.0, 0.0, 0.0, mean, 0.0, stdDev, 0.0, 0.0);
    }

    @Override
    public Bounds getBounds() {
        return BOUNDS;
    }

    @Override
    public double trial() {
        double rV;
        double rU;
        double rS;
        SeamcatRandom random = RandomAccessor.getRandom();
        while ((rS = (rU = 2.0 * random.nextDouble() - 1.0) * rU + (rV = 2.0 * random.nextDouble() - 1.0) * rV) >= 1.0 || rS == 0.0) {
        }
        return this.getMean() + this.getStdDev() * rU * Math.sqrt(-2.0 * Math.log(rS) / rS);
    }

    public String toString() {
        return "Gaussian Distribution(" + this.getMean() + ", " + this.getStdDev() + ")";
    }
}

