/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.GaussianDistribution;
import org.seamcat.model.distributions.LimitedGaussianDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.mathematics.Mathematics;

public class LimitedGaussianDistributionImpl
extends AbstractDistribution
implements LimitedGaussianDistribution {
    private double mean;
    private Bounds BOUNDS;
    private GaussianDistribution gaussian;

    public LimitedGaussianDistributionImpl(double min, double max, double stdDev) {
        super(0.0, max, 0.0, 0.0, (max + min) / 2.0, min, stdDev, 0.0, 0.0);
        this.BOUNDS = Mathematics.equals(min, max, 0.1) ? new Bounds(min - 4.0 * stdDev, max + 4.0 * stdDev, true) : new Bounds(Math.min(min, max), Math.max(min, max), true);
        this.mean = (this.BOUNDS.getMax() + this.BOUNDS.getMin()) / 2.0;
        this.gaussian = Factory.distributionFactory().getGaussianDistribution(this.mean, stdDev);
    }

    @Override
    public double trial() {
        double d = this.gaussian.trial();
        while (d < this.BOUNDS.getMin() || d > this.BOUNDS.getMax()) {
            d = this.gaussian.trial();
        }
        return d;
    }

    @Override
    public double getMax() {
        return this.BOUNDS.getMax();
    }

    @Override
    public double getMin() {
        return this.BOUNDS.getMin();
    }

    @Override
    public double getMean() {
        return this.mean;
    }

    @Override
    public Bounds getBounds() {
        return this.BOUNDS;
    }

    public String toString() {
        return "Gaussian Distribution(" + this.getMean() + ", " + this.getStdDev() + ") limited to " + this.getBounds().toString() + "";
    }
}

