/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.LimitedRayleighDistribution;
import org.seamcat.model.distributions.RayleighDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;

public class LimitedRayleighDistributionImpl
extends AbstractDistribution
implements LimitedRayleighDistribution {
    private double max;
    private double min;
    private Bounds BOUNDS;
    private RayleighDistribution rayleigh;

    public LimitedRayleighDistributionImpl(double min, double max, double stdDev) {
        super(0.0, max < stdDev ? 7.0 * stdDev : max, 0.0, 0.0, 0.0, Math.max(min, 0.0), stdDev, 0.0, 0.0);
        this.max = max < stdDev ? 7.0 * stdDev : max;
        this.min = Math.max(min, 0.0);
        this.BOUNDS = new Bounds(this.min, this.max, true);
        this.rayleigh = Factory.distributionFactory().getRayleighDistribution(this.BOUNDS.getMin(), stdDev);
    }

    @Override
    public void setExperimental(boolean experimental) {
        this.rayleigh.setExperimental(experimental);
    }

    @Override
    public double trial() {
        double d = this.rayleigh.trial();
        while (d > this.BOUNDS.getMax()) {
            d = this.rayleigh.trial();
        }
        return d;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public Bounds getBounds() {
        return this.BOUNDS;
    }

    public String toString() {
        return "Rayleigh Distribution(" + this.getMin() + ", " + this.getStdDev() + ") limited to " + this.getMax();
    }
}

