/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.RayleighDistribution;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.factory.SeamcatRandom;
import org.seamcat.model.functions.Bounds;

public class RayleighDistributionImpl
extends AbstractDistribution
implements RayleighDistribution {
    private final Bounds bounds = new Bounds(0.0, 0.0, false);
    private boolean experimental;

    public RayleighDistributionImpl(double min, double stddev) {
        super(0.0, 0.0, 0.0, 0.0, 0.0, min, stddev, 0.0, 0.0);
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public void setExperimental(boolean experimental) {
        this.experimental = experimental;
    }

    @Override
    public double trial() {
        SeamcatRandom random = RandomAccessor.getRandom();
        if (this.experimental) {
            double rV;
            double rU;
            double rS;
            while ((rS = (rU = 2.0 * random.nextDouble() - 1.0) * rU + (rV = 2.0 * random.nextDouble() - 1.0) * rV) >= 1.0 || rS == 0.0) {
            }
            double rR0 = Math.sqrt(-2.0 * Math.log(rS));
            double rSigma = this.getStdDev() / Math.sqrt(0.42920367320510344);
            return this.getMin() + rSigma * rR0;
        }
        return this.getMin() + this.getStdDev() * Math.sqrt(-2.0 * Math.log(random.nextDouble()));
    }

    public String toString() {
        return "RayleighDistribution(" + this.getMin() + ", " + this.getStdDev() + ")";
    }
}

