/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import java.util.Collections;
import java.util.List;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.distributions.StairDistribution;
import org.seamcat.model.distributions.UserDistribution;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;

public class StairDistributionImpl
extends UserDistribution
implements StairDistribution {
    public StairDistributionImpl(Function function) {
        super(function);
        DiscreteFunction cdf = (DiscreteFunction)this.getCdf();
        Collections.sort(cdf.points(), Point2D.Y_COMPARATOR);
    }

    @Override
    public double trial() {
        Function cdf = this.getCdf();
        if (cdf instanceof DiscreteFunction) {
            return this.findLowestXWithHigherValue(((DiscreteFunction)cdf).points(), RandomAccessor.getRandom().nextDouble());
        }
        return 0.0;
    }

    private double findLowestXWithHigherValue(List<Point2D> points, double value) {
        int i;
        for (i = 0; i < points.size() && points.get(i).getY() <= value; ++i) {
        }
        if (i >= points.size()) {
            i = points.size() - 1;
        }
        return points.get(i).getX();
    }

    public boolean validate() {
        DiscreteFunction cdf = (DiscreteFunction)this.getCdf();
        List<Point2D> points = cdf.points();
        for (Point2D point : points) {
            if (!(point.getY() < 0.0) && !(point.getY() > 1.0)) continue;
            return false;
        }
        return Mathematics.equals(points.get(points.size() - 1).getY(), 1.0, 1.0E-4);
    }

    public String toString() {
        return "User defined stair distribution";
    }
}

