/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import org.seamcat.model.distributions.AbstractDistribution;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.functions.Bounds;

public class UniformDistributionImpl
extends AbstractDistribution
implements UniformDistribution {
    private final Bounds bounds;
    private final double range;

    public UniformDistributionImpl(double min, double max) {
        super(33.0, max, 360.0, 1.0, 0.0, min, 0.0, 0.2, 0.0);
        this.range = max - min;
        this.bounds = new Bounds(min, max, true);
    }

    @Override
    public Bounds getBounds() {
        return this.bounds;
    }

    @Override
    public double trial() {
        return RandomAccessor.getRandom().nextDouble() * this.range + this.getMin();
    }

    public String toString() {
        return "UniformDistribution(" + this.getMin() + ", " + this.getMax() + ")";
    }
}

