/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.distributions;

import java.util.List;
import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.distributions.UserDefinedDistribution;
import org.seamcat.model.distributions.UserDistribution;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;

public class UserDefinedDistributionImpl
extends UserDistribution
implements UserDefinedDistribution {
    public UserDefinedDistributionImpl(Function cdf) {
        super(cdf);
    }

    @Override
    public double trial() {
        Function cdf = this.getCdf();
        if (cdf instanceof DiscreteFunction) {
            return this.inverse(((DiscreteFunction)cdf).points(), RandomAccessor.getRandom().nextDouble());
        }
        return 0.0;
    }

    private double inverse(List<Point2D> points, double rY) {
        Point2D _p;
        if (points.size() == 0) {
            return 0.0;
        }
        Point2D p = null;
        int i = 0;
        int size = points.size();
        do {
            _p = p;
            p = points.get(i);
        } while (++i < size && rY > p.getY());
        double rX = rY == p.getY() ? p.getX() : (_p.getY() == p.getY() ? 0.0 : _p.getX() + (rY - _p.getY()) / (p.getY() - _p.getY()) * (p.getX() - _p.getX()));
        return rX;
    }

    public String toString() {
        return "User defined distribution";
    }
}

