/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.engines;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;
import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.engines.LinkResultSamplesImpl;
import org.seamcat.model.engines.PartialSimulationResults;
import org.seamcat.model.engines.SeedFixer;
import org.seamcat.model.engines.SimulationPool;
import org.seamcat.model.engines.SingleEvent;
import org.seamcat.model.engines.SingleResult;
import org.seamcat.model.engines.VectorDefinitions;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.ContexedSystemPlugin;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.SimulationResult;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.ValueDefinition;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.IntegerResultType;
import org.seamcat.model.types.result.LongResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.SamplesResultType;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.model.types.result.StringResultType;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.simulation.Simulation;
import org.seamcat.simulation.result.CollectorImpl;
import org.seamcat.simulation.result.ResultsImpl;
import org.seamcat.simulation.result.SimulationResultImpl;

public class InterferenceSimulationEngine
implements SeedFixer {
    private static Logger LOG = Logger.getLogger(InterferenceSimulationEngine.class);
    public static final String STATISTICS = "Statistics";
    public static final UniqueValueDef SIMULATION_SEED = Factory.results().single("Simulation seed", "");
    public static final UniqueValueDef PROCESSORS = Factory.results().single("Simulated performed on", "processor");
    public static final UniqueValueDef TOTAL_DURATION = Factory.results().single("Total simulation duration", "second");
    public static final UniqueValueDef EVENT_DURATION = Factory.results().single("Event generation duration", "second");
    public static final UniqueValueDef CALCULATION_RATE = Factory.results().single("Calculation rate", "events/second");
    public static final UniqueValueDef TIMESTAMP = Factory.results().single("Simulation date", "");
    public static final MultiValueDef LINK_SAMPLES = Factory.results().multi("Link samples", "km", "km");
    public static final UniqueValueDef RX_NOT_SIMULATED = Factory.results().single("Rx not simulated", "");
    public static final UniqueValueDef TX_NOT_SIMULATED = Factory.results().single("Tx not simulated", "");
    public static final UniqueValueDef INTERFERENCE_LINK_INDEX = Factory.results().single("Interference Link Index", "");
    public static final UniqueValueDef SYSTEM_LINK_TYPE = Factory.results().single("System Link Type", "name");
    public static final String SYSTEM_LINK_SECONDARY = "Secondary Link";
    private List<Integer> unprocessed;
    private static DateFormat timeFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private PartialSimulationResults results;
    private Simulation simulation;
    private Scenario scenario;
    private boolean all;
    private LinkedList<Future<SingleResult>> events = new LinkedList();
    private EventResult last;
    private boolean terminating;
    private MaskFunction pseudoEmission;
    private double bwVLR;

    public InterferenceSimulationEngine(Simulation simulation) {
        this.simulation = simulation;
        this.scenario = simulation.getScenario();
        this.all = true;
        int groupCount = 1 + this.scenario.getInterferenceLinks().size() + this.scenario.getEventProcessingList().size();
        this.results = new PartialSimulationResults(this.scenario.numberOfEvents(), groupCount);
        this.results.setBeginSimulationTime(System.currentTimeMillis());
        simulation.simulationBegin(this.results.getSimulationSeed());
        this.preSimulate();
    }

    public InterferenceSimulationEngine(Simulation simulation, PartialSimulationResults results) {
        this.simulation = simulation;
        this.scenario = simulation.getScenario();
        this.results = results;
        this.all = false;
        this.unprocessed = results.getUnprocessed();
    }

    private void preSimulate() {
        ResultsImpl pre = new ResultsImpl("seamcatResult", "PreSimulation");
        RadioSystem victimSystem = this.scenario.getVictim().getSystem();
        EmissionMask wtUnwantedEmission = victimSystem.getTransmitter().getEmissionsMask();
        pre.getFunctionResultTypes().add(new FunctionResultType(Transmitter.NORMALIZED_EMISSION_MASK, wtUnwantedEmission.getEmissionMask().normalize()));
        this.scenario.getVictim().preSimulation(pre);
        this.results.setVictimResults(pre);
        LinkedHashMap<InterferenceLink, Results> iResults = new LinkedHashMap<InterferenceLink, Results>();
        this.results.setResults(iResults);
        for (InterferenceLink link : this.scenario.getInterferenceLinks()) {
            ResultsImpl iPre = new ResultsImpl("seamcatResult", "PreSimulation");
            iResults.put(link, iPre);
            Transmitter it = link.getInterferer().getSystem().getTransmitter();
            iPre.getFunctionResultTypes().add(new FunctionResultType(Transmitter.NORMALIZED_EMISSION_MASK, it.getEmissionsMask().getEmissionMask().normalize()));
            if (it.isUsingEmissionsFloor()) {
                iPre.getFunctionResultTypes().add(new FunctionResultType(Transmitter.NORMALIZED_EMISSION_FLOOR, it.getEmissionsFloor().normalize()));
            }
            link.getInterferer().preSimulation(iPre);
        }
        this.calculateBlockAverage();
        if (this.scenario.getVictim().getSystem().getReceiver().isIntermodulationRejectionOption() && this.scenario.getInterferenceLinks().size() > 1 && !this.scenario.getVictim().getSystem().getReceiver().getIntermodulationRejection().isConstant()) {
            this.checkIntermodulationRejection();
        }
        this.results.setBeginEventTime(System.currentTimeMillis());
    }

    private void checkIntermodulationRejection() {
        Point2D p;
        double f;
        double rFreqVLRmax;
        double rFreqVLRmin;
        int numberOfInterferingSystems = this.scenario.getInterferenceLinks().size();
        Function intermodMask = this.scenario.getVictim().getSystem().getReceiver().getIntermodulationRejection();
        List<Point2D> points = intermodMask.getPoints();
        Distribution frequency = this.scenario.getVictim().getFrequency();
        if (frequency.getBounds().isBounded()) {
            rFreqVLRmin = frequency.getBounds().getMin();
            rFreqVLRmax = frequency.getBounds().getMax();
        } else {
            rFreqVLRmax = rFreqVLRmin = frequency.trial();
        }
        double rFreqIntermodMin = points.get(0).getX() + rFreqVLRmax;
        double rFreqIntermodMax = points.get(points.size() - 1).getX() + rFreqVLRmin;
        for (int m = 0; m < numberOfInterferingSystems; ++m) {
            for (int k = 0; k < numberOfInterferingSystems; ++k) {
                double fILT2;
                if (m == k) continue;
                double fILT1 = this.scenario.getInterferenceLinks().get(m).getInterferer().getFrequency().getBounds().getMax();
                double rF0 = 2.0 * fILT1 - (fILT2 = this.scenario.getInterferenceLinks().get(k).getInterferer().getFrequency().getBounds().getMin());
                if (rF0 > rFreqIntermodMax) {
                    rFreqIntermodMax = rF0;
                }
                if (rF0 < rFreqIntermodMin) {
                    rFreqIntermodMin = rF0;
                }
                if ((rF0 = 2.0 * (fILT1 = this.scenario.getInterferenceLinks().get(k).getInterferer().getFrequency().getBounds().getMax()) - (fILT2 = this.scenario.getInterferenceLinks().get(m).getInterferer().getFrequency().getBounds().getMin())) > rFreqIntermodMax) {
                    rFreqIntermodMax = rF0;
                }
                if (rF0 < rFreqIntermodMin) {
                    rFreqIntermodMin = rF0;
                }
                if ((rF0 = 2.0 * (fILT1 = this.scenario.getInterferenceLinks().get(m).getInterferer().getFrequency().getBounds().getMin()) - (fILT2 = this.scenario.getInterferenceLinks().get(k).getInterferer().getFrequency().getBounds().getMax())) > rFreqIntermodMax) {
                    rFreqIntermodMax = rF0;
                }
                if (rF0 < rFreqIntermodMin) {
                    rFreqIntermodMin = rF0;
                }
                if ((rF0 = 2.0 * (fILT1 = this.scenario.getInterferenceLinks().get(k).getInterferer().getFrequency().getBounds().getMin()) - (fILT2 = this.scenario.getInterferenceLinks().get(m).getInterferer().getFrequency().getBounds().getMax())) > rFreqIntermodMax) {
                    rFreqIntermodMax = rF0;
                }
                if (!(rF0 < rFreqIntermodMin)) continue;
                rFreqIntermodMin = rF0;
            }
        }
        boolean modified = false;
        ArrayList<Point2D> maskModified = new ArrayList<Point2D>();
        if (rFreqIntermodMin - rFreqVLRmax < intermodMask.getBounds().getMin()) {
            f = Math.min(rFreqVLRmin - rFreqIntermodMax, rFreqIntermodMin - rFreqVLRmax);
            p = new Point2D(f, points.get(0).getY());
            maskModified.add(p);
            modified = true;
        }
        if (rFreqIntermodMax - rFreqVLRmin > intermodMask.getBounds().getMax()) {
            f = Math.max(rFreqIntermodMax - rFreqVLRmin, rFreqVLRmax - rFreqIntermodMin);
            p = new Point2D(f, points.get(points.size() - 1).getY());
            maskModified.add(p);
            modified = true;
        }
        if (modified) {
            maskModified.addAll(points);
            Collections.sort(maskModified, Point2D.X_COMPARATOR);
            Function intermodMaskModified = Factory.functionFactory().discreteFunction(maskModified);
            this.results.getVictimResults().getFunctionResultTypes().add(new FunctionResultType(Receiver.INTERMODULATION_REJECTION, intermodMaskModified));
        }
    }

    private void postSimulate(Results victimResults, Map<InterferenceLink, Results> iResults) {
        this.scenario.getVictim().postSimulation(victimResults);
        for (InterferenceLink link : this.scenario.getInterferenceLinks()) {
            link.getInterferer().postSimulation(iResults.get(link));
        }
        this.simulation.simulationEnd();
    }

    public SimulationResult simulateInterference(SimulationPool pool) {
        try {
            Object result;
            SimulationResult simulationResult;
            Scenario scenario;
            block14: {
                this.terminating = false;
                scenario = this.simulation.getScenario();
                ContexedSystemPlugin victim = scenario.getVictim();
                simulationResult = this.simulation.getSimulationResult();
                if (this.all) {
                    for (int i = 0; i < this.simulation.getScenario().numberOfEvents(); ++i) {
                        this.events.add(pool.getPool().submit(new SingleEvent(this, this.results.getSimulationSeed(), i, this.results, this.simulation)));
                    }
                } else {
                    for (Integer eventNo : this.unprocessed) {
                        this.events.add(pool.getPool().submit(new SingleEvent(this, this.results.getSimulationSeed(), eventNo, this.results, this.simulation)));
                    }
                }
                try {
                    result = null;
                    while (!this.events.isEmpty()) {
                        if (this.terminating) {
                            this.cancelAll();
                            throw new RuntimeException("Stopped");
                        }
                        result = this.events.removeFirst().get();
                        this.collectResults((SingleResult)result, this.results);
                        this.simulation.getListener().eventComplete((SingleResult)result);
                    }
                    if (result != null) {
                        this.last = ((SingleResult)result).eventResult;
                    }
                }
                catch (ExecutionException e) {
                    this.cancelAll();
                    Throwable cause = e.getCause();
                    if (!(cause instanceof SimulationInvalidException)) break block14;
                    throw (SimulationInvalidException)cause;
                }
            }
            result = (SimulationResultImpl)simulationResult;
            ((SimulationResultImpl)result).setLinkResultSamples(new LinkResultSamplesImpl(this.results.getVictimSamples(), this.results.getInterfererSamples()));
            ResultsImpl victimResults = (ResultsImpl)this.results.getVictimResults();
            victimResults.setName("Victim Results (" + scenario.getVictim().getName() + ")");
            VectorDefinitions names = this.simulation.getNames();
            double[] unw = this.results.removeVector(0, names.getIRSS_UNWANTED().name());
            double[] blo = this.results.removeVector(0, names.getIRSS_BLOCKING().name());
            victimResults.getVectorResultTypes().add(new VectorResultType(names.getIRSS_UNWANTED(), unw));
            victimResults.getVectorResultTypes().add(new VectorResultType(names.getIRSS_BLOCKING(), blo));
            this.appendToGroup(victimResults, this.results, 0);
            ((SimulationResultImpl)result).setVictimResult(victimResults);
            LinkedHashMap<InterferenceLink, Results> iMap = new LinkedHashMap<InterferenceLink, Results>();
            int i = 1;
            for (InterferenceLink link : scenario.getInterferenceLinks()) {
                ResultsImpl iResults = (ResultsImpl)this.results.getResults(link);
                iResults.setName("Link " + i + " Results (" + link.getInterferer().getName() + ")");
                iMap.put(link, iResults);
                this.appendToGroup(iResults, this.results, i);
                ((SimulationResultImpl)result).setResult(link, (Results)iResults);
                ++i;
            }
            for (EventProcessing processing : scenario.getEventProcessingList()) {
                EventProcessingConfiguration conf = (EventProcessingConfiguration)processing;
                ResultsImpl eppResult = new ResultsImpl(conf.getId(), processing.description().name());
                this.appendToGroup(eppResult, this.results, i);
                ((SimulationResultImpl)result).setResult(conf, (Results)eppResult);
                ++i;
            }
            this.postSimulate(victimResults, iMap);
            long simulationEnd = System.currentTimeMillis();
            double eventDuration = (double)(simulationEnd - this.results.getBeginEventTime()) / 1000.0;
            double totalDuration = (double)(simulationEnd - this.results.getBeginSimulationTime()) / 1000.0;
            ResultsImpl stats = new ResultsImpl(STATISTICS);
            stats.getSingleValueTypes().add(new IntegerResultType(PROCESSORS, pool.getPoolSize()));
            stats.getSingleValueTypes().add(new DoubleResultType(TOTAL_DURATION, totalDuration));
            stats.getSingleValueTypes().add(new DoubleResultType(EVENT_DURATION, eventDuration));
            stats.getSingleValueTypes().add(new IntegerResultType(CALCULATION_RATE, new Long(Math.round((double)this.simulation.getScenario().numberOfEvents() / eventDuration)).intValue()));
            stats.getSingleValueTypes().add(new StringResultType(TIMESTAMP, timeFormat.format(new Date())));
            stats.getSingleValueTypes().add(new LongResultType(SIMULATION_SEED, this.results.getSimulationSeed()));
            ((SimulationResultImpl)result).setStatistics(stats);
            return simulationResult;
        }
        catch (InterruptedException e) {
            this.cancelAll();
            return null;
        }
        catch (OutOfMemoryError error) {
            this.cancelAll();
            LOG.error(error);
            throw new SimulationInvalidException("Out of memory. Scenario is too large to simulate.", error);
        }
    }

    private void terminate() {
        this.terminating = true;
    }

    private void cancelAll() {
        while (!this.events.isEmpty()) {
            this.events.removeFirst().cancel(true);
        }
    }

    public PartialSimulationResults stop() {
        this.terminate();
        return this.results;
    }

    public EventResult getLastEventResult() {
        return this.last;
    }

    private void appendToGroup(Results group, PartialSimulationResults results, int groupIndex) {
        ValueDefinition def;
        for (Map.Entry<VectorDef, double[]> entry : results.vectorResults(groupIndex).entrySet()) {
            group.getVectorResultTypes().add(new VectorResultType(entry.getKey(), entry.getValue()));
        }
        for (Map.Entry<ValueDefinition, Object> entry : results.barCharts(groupIndex).entrySet()) {
            BarChartResultType bc = new BarChartResultType((MultiValueDef)entry.getKey());
            bc.value().addAll((Collection)entry.getValue());
            group.getBarChartResultTypes().add(bc);
        }
        for (Map.Entry<ValueDefinition, Object> entry : results.scatterPlots(groupIndex).entrySet()) {
            def = (MultiValueDef)entry.getKey();
            ScatterDiagramResultType sd = new ScatterDiagramResultType((MultiValueDef)def);
            sd.value().addAll((Collection)entry.getValue());
            group.getScatterDiagramResultTypes().add(sd);
        }
        for (Map.Entry<ValueDefinition, Object> entry : results.samples(groupIndex).entrySet()) {
            def = (VectorDef)entry.getKey();
            group.getSamplesResultTypes().add(new SamplesResultType(def.name(), def.unit(), (List[])entry.getValue()));
        }
        for (Map.Entry<ValueDefinition, Object> entry : results.single(groupIndex).entrySet()) {
            group.getSingleValueTypes().add((SingleValueTypes<?>)entry.getValue());
        }
        for (Map.Entry<ValueDefinition, Object> entry : results.function(groupIndex).entrySet()) {
            group.getFunctionResultTypes().add(new FunctionResultType((UniqueValueDef)entry.getKey(), (Function)entry.getValue()));
        }
    }

    public static long calculateEventSeed(long simulationSeed, int eventNumber) {
        return simulationSeed + (long)((eventNumber + 1) * 31);
    }

    @Override
    public void fixSeed(long simulationSeed, int eventNumber) {
        RandomAccessor.fixSeed(InterferenceSimulationEngine.calculateEventSeed(simulationSeed, eventNumber));
    }

    private void collectResults(SingleResult single, PartialSimulationResults results) {
        results.processed(single.eventNo);
        this.handleGroup(results, (CollectorImpl)((Object)single.vResults), 0, single.eventNo);
        for (Map.Entry<Integer, InterfererResultCollector> entry : single.iResults.entrySet()) {
            this.handleGroup(results, (CollectorImpl)((Object)entry.getValue()), entry.getKey(), single.eventNo);
        }
        for (Map.Entry<Integer, Collector> entry : single.eppResults.entrySet()) {
            this.handleGroup(results, (CollectorImpl)entry.getValue(), entry.getKey(), single.eventNo);
        }
        if (single.hasSamples()) {
            results.getVictimSamples().addAll(single.victimSamples);
            results.getInterfererSamples().addAll(single.interfererSamples);
        }
    }

    private void handleGroup(PartialSimulationResults results, CollectorImpl collector, int group, int event) {
        VectorDef def;
        for (Map.Entry<VectorDef, Double> entry : collector.values().entrySet()) {
            def = entry.getKey();
            if (def.intermediate()) continue;
            results.vector(def, group, event, entry.getValue());
        }
        for (Map.Entry<VectorDef, Object> entry : collector.samples().entrySet()) {
            def = entry.getKey();
            if (def.intermediate()) continue;
            results.sample(def, group, event, (List)entry.getValue());
        }
        for (Map.Entry<ValueDefinition, Object> entry : collector.getBarValues().entrySet()) {
            if (((MultiValueDef)entry.getKey()).intermediate()) continue;
            results.bar((MultiValueDef)entry.getKey(), group, (List)entry.getValue());
        }
        for (Map.Entry<ValueDefinition, Object> entry : collector.getScatterValues().entrySet()) {
            if (((MultiValueDef)entry.getKey()).intermediate()) continue;
            results.scatter((MultiValueDef)entry.getKey(), group, (List)entry.getValue());
        }
        for (Map.Entry<ValueDefinition, Object> entry : collector.getSingleValues().entrySet()) {
            if (((UniqueValueDef)entry.getKey()).intermediate()) continue;
            results.single((UniqueValueDef)entry.getKey(), group, (SingleValueTypes)entry.getValue());
        }
        for (Map.Entry<ValueDefinition, Object> entry : collector.getFunctions().entrySet()) {
            results.function((UniqueValueDef)entry.getKey(), group, ((FunctionResultType)entry.getValue()).value());
        }
    }

    private void calculateBlockAverage() {
        RadioSystem victim = this.scenario.getVictim().getSystem();
        Function maskOrigin = victim.getReceiver().getPseudoBlockingMask();
        if (!maskOrigin.isConstant() && maskOrigin.getPoints().size() < 2) {
            maskOrigin = Factory.functionFactory().constantFunction(0.0);
        }
        this.bwVLR = victim.getReceiver().getBandwidth();
        Distribution frequencyVLR = this.scenario.getVictim().getFrequency();
        double bwOffsetVLR = 0.0;
        if (!maskOrigin.isConstant()) {
            this.setPseudoEmission(maskOrigin);
            Bounds boundsVLR = this.getBoundsVLR(maskOrigin);
            bwOffsetVLR = !boundsVLR.isBounded() ? 0.0 : Math.rint(((boundsVLR.getMax() - boundsVLR.getMin()) / 2.0 - boundsVLR.getMax()) * 1000.0) / 1000.0;
        }
        for (InterferenceLink link : this.scenario.getInterferenceLinks()) {
            ArrayList<Point2D> maskPoints = new ArrayList<Point2D>();
            RadioSystem system = link.getInterferer().getSystem();
            Distribution frequencyILT = link.getFrequency();
            double bwOffsetILT = system.getTransmitter().getBandwidthOffset();
            double bwILT = system.getTransmitter().getBandwidth();
            double step = Math.min(0.1, bwILT / 20.0);
            if (this.bwVLR < 1.0) {
                step = Math.min(0.1, this.bwVLR / 20.0);
            }
            step = Math.rint(step * 1000.0) / 1000.0;
            UniformDistribution fOffsets = Factory.distributionFactory().getUniformDistribution(Math.rint((frequencyILT.getBounds().getMin() - frequencyVLR.getBounds().getMax()) * 1000.0) / 1000.0, Math.rint((frequencyILT.getBounds().getMax() - frequencyVLR.getBounds().getMin()) * 1000.0) / 1000.0);
            if (Mathematics.equals(step, 0.0, 1.0E-5)) {
                step = 0.001;
            }
            double fOffssetLow = Math.rint(fOffsets.getBounds().getMin() / step - 0.5) * step;
            fOffsets = Factory.distributionFactory().getUniformDistribution(fOffssetLow, fOffsets.getBounds().getMax());
            if (maskOrigin.isConstant()) {
                ArrayList<Point2D> points = new ArrayList<Point2D>();
                points.add(new Point2D(fOffsets.getBounds().getMin(), maskOrigin.getConstant()));
                points.add(new Point2D(0.0, maskOrigin.getConstant()));
                points.add(new Point2D(fOffsets.getBounds().getMax(), maskOrigin.getConstant()));
                maskOrigin = Factory.functionFactory().discreteFunction(points);
            }
            this.checkMaskBounds(maskOrigin, fOffsets, bwILT);
            double margin = 0.0;
            if (!Mathematics.equals(fOffsets.getBounds().getMax(), fOffsets.getBounds().getMin(), 0.001)) {
                margin = step;
            }
            for (double tOffset = fOffsets.getBounds().getMin(); tOffset <= fOffsets.getBounds().getMax() + margin; tOffset += step) {
                double blockingResponse;
                if (Math.abs(tOffset = Math.rint(tOffset * 1000.0) / 1000.0) < (bwILT + this.bwVLR) / 2.0) {
                    double correction;
                    double fOffset;
                    double upper;
                    double lower;
                    if (tOffset - bwOffsetILT - bwOffsetVLR - bwILT / 2.0 >= -this.bwVLR / 2.0 && tOffset - bwOffsetILT - bwOffsetVLR + bwILT / 2.0 <= this.bwVLR / 2.0) {
                        blockingResponse = 1000.0;
                    } else if (Math.rint((tOffset - bwOffsetILT - bwOffsetVLR - bwILT / 2.0) * 1000.0) / 1000.0 < -this.bwVLR / 2.0 && Math.rint((tOffset - bwOffsetILT - bwOffsetVLR + bwILT / 2.0) * 1000.0) / 1000.0 > this.bwVLR / 2.0) {
                        lower = tOffset - bwOffsetILT - bwOffsetVLR - bwILT / 2.0;
                        upper = -this.bwVLR / 2.0 - bwOffsetVLR;
                        fOffset = upper - (upper - lower) / 2.0;
                        double partBelow = this.getIntegral(Math.rint((upper - lower) * 1000.0) / 1000.0, maskOrigin, fOffset);
                        partBelow = -10.0 * Math.log10(Math.pow(10.0, -partBelow / 10.0) * Math.abs(upper - lower) / bwILT);
                        lower = this.bwVLR / 2.0 - bwOffsetVLR;
                        upper = tOffset - bwOffsetILT - bwOffsetVLR + bwILT / 2.0;
                        fOffset = lower + (upper - lower) / 2.0;
                        double partAbove = this.getIntegral(Math.rint((upper - lower) * 1000.0) / 1000.0, maskOrigin, fOffset);
                        partAbove = -10.0 * Math.log10(Math.pow(10.0, -partAbove / 10.0) * Math.abs(upper - lower) / bwILT);
                        blockingResponse = -10.0 * Math.log10(Math.pow(10.0, -partAbove / 10.0) + Math.pow(10.0, -partBelow / 10.0));
                    } else if (Math.rint((tOffset - bwOffsetILT - bwOffsetVLR + bwILT / 2.0) * 1000.0) / 1000.0 > this.bwVLR / 2.0) {
                        lower = this.bwVLR / 2.0 - bwOffsetVLR;
                        upper = tOffset - bwOffsetILT - bwOffsetVLR + bwILT / 2.0;
                        correction = Math.abs(upper - lower) / bwILT;
                        fOffset = lower + Math.abs(upper - lower) / 2.0;
                        blockingResponse = this.getIntegral(Math.rint((upper - lower) * 1000.0) / 1000.0, maskOrigin, fOffset);
                        blockingResponse = -10.0 * Math.log10(Math.pow(10.0, -blockingResponse / 10.0) * correction);
                    } else {
                        lower = tOffset - bwOffsetILT - bwOffsetVLR - bwILT / 2.0;
                        upper = -this.bwVLR / 2.0 - bwOffsetVLR;
                        correction = Math.abs(upper - lower) / bwILT;
                        fOffset = upper - (upper - lower) / 2.0;
                        blockingResponse = this.getIntegral(Math.rint((upper - lower) * 1000.0) / 1000.0, maskOrigin, fOffset);
                        blockingResponse = -10.0 * Math.log10(Math.pow(10.0, -blockingResponse / 10.0) * correction);
                    }
                } else {
                    blockingResponse = this.getIntegral(bwILT, maskOrigin, tOffset);
                }
                maskPoints.add(new Point2D(tOffset, blockingResponse));
            }
            if (maskPoints.size() > 1) {
                Collections.sort(maskPoints, Point2D.X_COMPARATOR);
                Function rBlockingMask = Factory.functionFactory().discreteFunction(maskPoints);
                this.results.getResults(link).getFunctionResultTypes().add(new FunctionResultType(Receiver.BLOCKING_MASK_INTEGRAL, rBlockingMask));
                continue;
            }
            if (maskPoints.size() != 1) continue;
            Function rBlockingMask = Factory.functionFactory().constantFunction(Math.rint(((Point2D)maskPoints.get(0)).getY() * 10.0) / 10.0);
            this.results.getResults(link).getFunctionResultTypes().add(new FunctionResultType(Receiver.BLOCKING_MASK_INTEGRAL, rBlockingMask));
        }
    }

    private Bounds getBoundsVLR(Function maskOrigin) {
        if (maskOrigin.getBounds().isBounded()) {
            double max;
            double ref = maskOrigin.evaluate(0.0);
            double min = 0.0;
            if (!Mathematics.equals(ref, maskOrigin.evaluateMax(), 0.1)) {
                for (max = 0.0; maskOrigin.evaluate(max) - ref <= 3.0 && max < maskOrigin.getBounds().getMax(); max += 0.01) {
                }
                while (maskOrigin.evaluate(min) - ref <= 3.0 && min > maskOrigin.getBounds().getMin()) {
                    min -= 0.01;
                }
                return new Bounds(min, max, true);
            }
            return new Bounds(min, max, false);
        }
        throw new RuntimeException("Function not bounded");
    }

    private double getIntegral(double rangeToIntegrate, Function maskOrigin, double tOffset) {
        if (maskOrigin.isConstant()) {
            return maskOrigin.getConstant();
        }
        if (this.getPseudoEmission() == null || this.getPseudoEmission().getPoints().size() < 2) {
            this.setPseudoEmission(maskOrigin);
            return this.getIntegral(rangeToIntegrate, maskOrigin, tOffset);
        }
        double att = -this.getPseudoEmission().integrate(tOffset, rangeToIntegrate);
        return att += 10.0 * Math.log10(rangeToIntegrate);
    }

    private MaskFunction getPseudoEmission() {
        return this.pseudoEmission;
    }

    private void setPseudoEmission(Function maskOrigin) {
        ArrayList<Double> ref = new ArrayList<Double>();
        ArrayList<Point2D> pseudoMask = new ArrayList<Point2D>();
        for (int i = 0; i < maskOrigin.getPoints().size(); ++i) {
            ref.add(this.bwVLR * 1000.0);
            pseudoMask.add(new Point2D(maskOrigin.getPoints().get(i).getX(), -1.0 * maskOrigin.getPoints().get(i).getY()));
        }
        this.pseudoEmission = Factory.functionFactory().maskFunction(pseudoMask, ref);
    }

    private void checkMaskBounds(Function maskOrigin, Distribution fOffsets, double bwILT) {
        ArrayList<Point2D> point2Ds = new ArrayList<Point2D>();
        point2Ds.addAll(maskOrigin.getPoints());
        boolean isChanged = false;
        if (maskOrigin.getBounds().getMin() > fOffsets.getBounds().getMin() - bwILT) {
            point2Ds.add(new Point2D(fOffsets.getBounds().getMin() - bwILT, ((Point2D)point2Ds.get(0)).getY()));
            isChanged = true;
        }
        if (maskOrigin.getBounds().getMax() < fOffsets.getBounds().getMax() + bwILT) {
            Point2D p = new Point2D(fOffsets.getBounds().getMax() + bwILT, maskOrigin.getPoints().get(maskOrigin.getPoints().size() - 1).getY());
            point2Ds.add(p);
            isChanged = true;
        }
        if (isChanged) {
            Collections.sort(point2Ds, Point2D.X_COMPARATOR);
            this.setPseudoEmission(Factory.functionFactory().discreteFunction(point2Ds));
        }
    }
}

