/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.engines;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.engines.IndexedValueDef;
import org.seamcat.model.engines.ScenarioResults;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.SingleValueTypes;

public class PartialSimulationResults
implements ScenarioResults {
    private long simulationSeed;
    private long beginSimulationTime;
    private long beginEventTime;
    private int events;
    private int groupCount;
    private LinkedHashMap<IndexedValueDef<VectorDef>, double[]> vectorResults = new LinkedHashMap();
    private LinkedHashMap<IndexedValueDef<VectorDef>, List<Double>[]> sampleResults = new LinkedHashMap();
    private LinkedHashMap<IndexedValueDef<MultiValueDef>, List<BarChartValue>> barCharts = new LinkedHashMap();
    private LinkedHashMap<IndexedValueDef<MultiValueDef>, List<Point2D>> scatterPlots = new LinkedHashMap();
    private LinkedHashMap<IndexedValueDef<MultiValueDef>, List<LinkResult>> linkResults = new LinkedHashMap();
    private LinkedHashMap<IndexedValueDef<UniqueValueDef>, SingleValueTypes<?>> singleValues = new LinkedHashMap();
    private LinkedHashMap<IndexedValueDef<UniqueValueDef>, Function> functions = new LinkedHashMap();
    private Results victimResults;
    private Map<InterferenceLink, Results> results;
    private final List<LinkResult> victimSamples = new ArrayList<LinkResult>();
    private final List<LinkResult> interfererSamples = new ArrayList<LinkResult>();
    private List<Integer> unprocessed = new ArrayList<Integer>();

    public PartialSimulationResults(int numberOfEvents, int groupCount) {
        this.simulationSeed = RandomAccessor.getRandom().nextLong();
        this.events = numberOfEvents;
        this.groupCount = groupCount;
        for (int idx = 0; idx < this.events; ++idx) {
            this.unprocessed.add(idx);
        }
    }

    void processed(int i) {
        this.unprocessed.remove((Object)i);
    }

    public List<Integer> getUnprocessed() {
        return this.unprocessed;
    }

    void vector(VectorDef def, int groupIndex, int event, double value) {
        this.ensure((VectorDef)def, (int)groupIndex)[event] = value;
    }

    void sample(VectorDef def, int groupIndex, int event, List<Double> samples) {
        this.ensureSample((VectorDef)def, (int)groupIndex)[event] = samples;
    }

    void bar(MultiValueDef def, int groupIndex, List<BarChartValue> values) {
        this.ensure(def, groupIndex).addAll(values);
    }

    void scatter(MultiValueDef def, int groupIndex, List<Point2D> points) {
        this.ensureScatter(def, groupIndex).addAll(points);
    }

    void single(UniqueValueDef def, int groupCount, SingleValueTypes value) {
        this.singleValues.put(new IndexedValueDef<UniqueValueDef>(groupCount, def), value);
    }

    void function(UniqueValueDef def, int groupCount, Function function) {
        this.functions.put(new IndexedValueDef<UniqueValueDef>(groupCount, def), function);
    }

    public List<LinkResult> getVictimSamples() {
        return this.victimSamples;
    }

    public List<LinkResult> getInterfererSamples() {
        return this.interfererSamples;
    }

    private double[] ensure(VectorDef def, int groupIndex) {
        IndexedValueDef<VectorDef> nameDef = new IndexedValueDef<VectorDef>(groupIndex, def);
        double[] values = this.vectorResults.get(nameDef);
        if (values == null) {
            values = new double[this.events];
            this.vectorResults.put(nameDef, values);
        }
        return values;
    }

    private List<Double>[] ensureSample(VectorDef def, int groupIndex) {
        IndexedValueDef<VectorDef> nameDef = new IndexedValueDef<VectorDef>(groupIndex, def);
        List<Double>[] values = this.sampleResults.get(nameDef);
        if (values == null) {
            values = new List[this.events];
            this.sampleResults.put(nameDef, values);
        }
        return values;
    }

    private List<BarChartValue> ensure(MultiValueDef def, int groupIndex) {
        IndexedValueDef<MultiValueDef> named = new IndexedValueDef<MultiValueDef>(groupIndex, def);
        List<BarChartValue> list = this.barCharts.get(named);
        if (list == null) {
            list = new ArrayList<BarChartValue>();
            this.barCharts.put(named, list);
        }
        return list;
    }

    private List<Point2D> ensureScatter(MultiValueDef def, int groupIndex) {
        IndexedValueDef<MultiValueDef> named = new IndexedValueDef<MultiValueDef>(groupIndex, def);
        List<Point2D> list = this.scatterPlots.get(named);
        if (list == null) {
            list = new ArrayList<Point2D>();
            this.scatterPlots.put(named, list);
        }
        return list;
    }

    double[] removeVector(int groupIndex, String name) {
        Map.Entry<IndexedValueDef<VectorDef>, double[]> found = null;
        for (Map.Entry<IndexedValueDef<VectorDef>, double[]> entry : this.vectorResults.entrySet()) {
            if (entry.getKey().getIndex() != groupIndex || !entry.getKey().getDef().name().equals(name)) continue;
            found = entry;
            break;
        }
        if (found != null) {
            this.vectorResults.remove(found.getKey());
            return (double[])found.getValue();
        }
        throw new RuntimeException("Not found: " + name);
    }

    LinkedHashMap<VectorDef, double[]> vectorResults(int groupIndex) {
        LinkedHashMap<VectorDef, double[]> results = new LinkedHashMap<VectorDef, double[]>();
        for (Map.Entry<IndexedValueDef<VectorDef>, double[]> entry : this.vectorResults.entrySet()) {
            if (entry.getKey().getIndex() != groupIndex) continue;
            results.put(entry.getKey().getDef(), entry.getValue());
        }
        return results;
    }

    LinkedHashMap<MultiValueDef, List<BarChartValue>> barCharts(int groupIndex) {
        LinkedHashMap<MultiValueDef, List<BarChartValue>> results = new LinkedHashMap<MultiValueDef, List<BarChartValue>>();
        for (Map.Entry<IndexedValueDef<MultiValueDef>, List<BarChartValue>> entry : this.barCharts.entrySet()) {
            if (entry.getKey().getIndex() != groupIndex) continue;
            results.put(entry.getKey().getDef(), entry.getValue());
        }
        return results;
    }

    LinkedHashMap<MultiValueDef, List<Point2D>> scatterPlots(int groupIndex) {
        LinkedHashMap<MultiValueDef, List<Point2D>> results = new LinkedHashMap<MultiValueDef, List<Point2D>>();
        for (Map.Entry<IndexedValueDef<MultiValueDef>, List<Point2D>> entry : this.scatterPlots.entrySet()) {
            if (entry.getKey().getIndex() != groupIndex) continue;
            results.put(entry.getKey().getDef(), entry.getValue());
        }
        return results;
    }

    LinkedHashMap<VectorDef, List<Double>[]> samples(int groupIndex) {
        LinkedHashMap<VectorDef, List<Double>[]> results = new LinkedHashMap<VectorDef, List<Double>[]>();
        for (Map.Entry<IndexedValueDef<VectorDef>, List<Double>[]> entry : this.sampleResults.entrySet()) {
            if (entry.getKey().getIndex() != groupIndex) continue;
            results.put(entry.getKey().getDef(), entry.getValue());
        }
        return results;
    }

    LinkedHashMap<UniqueValueDef, SingleValueTypes> single(int groupIndex) {
        LinkedHashMap<UniqueValueDef, SingleValueTypes> results = new LinkedHashMap<UniqueValueDef, SingleValueTypes>();
        for (Map.Entry<IndexedValueDef<UniqueValueDef>, SingleValueTypes<?>> entry : this.singleValues.entrySet()) {
            if (entry.getKey().getIndex() != groupIndex) continue;
            results.put(entry.getKey().getDef(), entry.getValue());
        }
        return results;
    }

    LinkedHashMap<UniqueValueDef, Function> function(int groupIndex) {
        LinkedHashMap<UniqueValueDef, Function> results = new LinkedHashMap<UniqueValueDef, Function>();
        for (Map.Entry<IndexedValueDef<UniqueValueDef>, Function> entry : this.functions.entrySet()) {
            if (entry.getKey().getIndex() != groupIndex) continue;
            results.put(entry.getKey().getDef(), entry.getValue());
        }
        return results;
    }

    public long getBeginSimulationTime() {
        return this.beginSimulationTime;
    }

    public void setBeginSimulationTime(long beginSimulationTime) {
        this.beginSimulationTime = beginSimulationTime;
    }

    public long getBeginEventTime() {
        return this.beginEventTime;
    }

    public void setBeginEventTime(long beginEventTime) {
        this.beginEventTime = beginEventTime;
    }

    public long getSimulationSeed() {
        return this.simulationSeed;
    }

    public void setSimulationSeed(long simulationSeed) {
        this.simulationSeed = simulationSeed;
    }

    public int getEvents() {
        return this.events;
    }

    @Override
    public Results getResults(InterferenceLink link) {
        return this.results.get(link);
    }

    public Collection<Results> getResults() {
        return new ArrayList<Results>(this.results.values());
    }

    @Override
    public Results getVictimResults() {
        return this.victimResults;
    }

    public void setResults(Map<InterferenceLink, Results> results) {
        this.results = results;
    }

    public void setVictimResults(Results victimResults) {
        this.victimResults = victimResults;
    }

    public int getGroupCount() {
        return this.groupCount;
    }

    public LinkedHashMap<IndexedValueDef<VectorDef>, double[]> getVectorResults() {
        return this.vectorResults;
    }

    public LinkedHashMap<IndexedValueDef<VectorDef>, List<Double>[]> getSampleResults() {
        return this.sampleResults;
    }

    public LinkedHashMap<IndexedValueDef<MultiValueDef>, List<BarChartValue>> getBarCharts() {
        return this.barCharts;
    }

    public LinkedHashMap<IndexedValueDef<MultiValueDef>, List<Point2D>> getScatterPlots() {
        return this.scatterPlots;
    }

    public LinkedHashMap<IndexedValueDef<MultiValueDef>, List<LinkResult>> getLinkResults() {
        return this.linkResults;
    }

    public LinkedHashMap<IndexedValueDef<UniqueValueDef>, SingleValueTypes<?>> getSingleValues() {
        return this.singleValues;
    }

    public LinkedHashMap<IndexedValueDef<UniqueValueDef>, Function> getFunctions() {
        return this.functions;
    }

    public void setFirstUnprocessed(int firstUnprocessed) {
        this.unprocessed.clear();
        for (int i = firstUnprocessed; i < this.events; ++i) {
            this.unprocessed.add(i);
        }
    }
}

