/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.engines;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.ValueDefinition;
import org.seamcat.model.types.result.BarChartResultType;
import org.seamcat.model.types.result.BarChartValue;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.FunctionResultType;
import org.seamcat.model.types.result.IntegerResultType;
import org.seamcat.model.types.result.LongResultType;
import org.seamcat.model.types.result.ResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.model.types.result.ScatterDiagramResultType;
import org.seamcat.model.types.result.SingleValueTypes;
import org.seamcat.simulation.result.CollectorImpl;
import org.seamcat.simulation.result.ResultsImpl;

public class ResultUtil {
    public static Collector toCollector(Results results) {
        Iterator iterator;
        CollectorImpl collector = new CollectorImpl();
        for (SingleValueTypes<?> singleValueTypes : results.getSingleValueTypes()) {
            if (singleValueTypes instanceof DoubleResultType) {
                DoubleResultType d = (DoubleResultType)singleValueTypes;
                collector.add(d.def(), (double)d.value());
                continue;
            }
            if (singleValueTypes instanceof IntegerResultType) {
                IntegerResultType i = (IntegerResultType)singleValueTypes;
                collector.add(i.def(), i.value());
                continue;
            }
            if (!(singleValueTypes instanceof LongResultType)) continue;
            LongResultType l = (LongResultType)singleValueTypes;
            collector.add(l.def(), l.value());
        }
        for (FunctionResultType functionResultType : results.getFunctionResultTypes()) {
            collector.add(functionResultType.def(), functionResultType.value());
        }
        for (BarChartResultType barChartResultType : results.getBarChartResultTypes()) {
            iterator = barChartResultType.value().iterator();
            while (iterator.hasNext()) {
                BarChartValue point = (BarChartValue)iterator.next();
                collector.add(barChartResultType.def(), point);
            }
        }
        for (ScatterDiagramResultType scatterDiagramResultType : results.getScatterDiagramResultTypes()) {
            iterator = scatterDiagramResultType.value().iterator();
            while (iterator.hasNext()) {
                Point2D point2D = (Point2D)iterator.next();
                collector.add(scatterDiagramResultType.def(), point2D);
            }
        }
        return collector;
    }

    public static Results toResults(Collector collector, String name) {
        ResultType<List<BarChartValue>> type;
        ResultsImpl results = new ResultsImpl(name);
        CollectorImpl impl = (CollectorImpl)collector;
        for (Map.Entry<MultiValueDef, List<BarChartValue>> entry : impl.getBarValues().entrySet()) {
            type = new BarChartResultType(entry.getKey());
            ((BarChartResultType)type).value().addAll((Collection)entry.getValue());
            results.getBarChartResultTypes().add((BarChartResultType)type);
        }
        for (Map.Entry<MultiValueDef, List<Object>> entry : impl.getScatterValues().entrySet()) {
            type = new ScatterDiagramResultType(entry.getKey());
            ((ScatterDiagramResultType)type).value().addAll((Collection)entry.getValue());
            results.getScatterDiagramResultTypes().add((ScatterDiagramResultType)type);
        }
        for (Map.Entry<ValueDefinition, Object> entry : impl.getSingleValues().entrySet()) {
            results.getSingleValueTypes().add((SingleValueTypes<?>)entry.getValue());
        }
        for (Map.Entry<ValueDefinition, Object> entry : impl.getFunctions().entrySet()) {
            results.getFunctionResultTypes().add((FunctionResultType)entry.getValue());
        }
        return results;
    }
}

