/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.engines;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.log4j.Logger;
import org.seamcat.exception.SimulationInvalidException;
import org.seamcat.model.Scenario;
import org.seamcat.model.antenna.BeamFormingComposite;
import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.engines.ScenarioResults;
import org.seamcat.model.engines.SeedFixer;
import org.seamcat.model.engines.SingleResult;
import org.seamcat.model.engines.VectorDefinitions;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.antenna.BeamFormingCompositeInput;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.simulation.result.Collector;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterferenceLinkResult;
import org.seamcat.model.simulation.result.Interferer;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.MultiValueDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.CorrelationSetting;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.Receiver;
import org.seamcat.simulation.Simulation;
import org.seamcat.simulation.calculator.InterferenceCalculator;
import org.seamcat.simulation.generic.Intermodulation;
import org.seamcat.simulation.generic.Overloading;
import org.seamcat.simulation.result.CollectorImpl;
import org.seamcat.simulation.result.EventResultImpl;
import org.seamcat.simulation.result.InterferenceLinkResultImpl;
import org.seamcat.simulation.result.InterfererResultCollectorImpl;
import org.seamcat.simulation.result.VictimResultCollectorImpl;

public class SingleEvent
implements Callable<SingleResult> {
    public static final MultiValueDef SYSTEM_CENTER = Factory.results().intermediateMulti("SYSTEM CENTER", "km", "km");
    private static Logger LOG = Logger.getLogger(SingleEvent.class);
    private SeedFixer seedFixer;
    private long simulationSeed;
    private final int eventNumber;
    private ScenarioResults scenarioResults;
    private Simulation simulation;

    public SingleEvent(SeedFixer seedFixer, long simulationSeed, int eventNumber, ScenarioResults scenarioResults, Simulation simulation) {
        this.seedFixer = seedFixer;
        this.simulationSeed = simulationSeed;
        this.eventNumber = eventNumber;
        this.scenarioResults = scenarioResults;
        this.simulation = simulation;
    }

    @Override
    public SingleResult call() {
        try {
            EventResult single = this.single();
            SingleResult result = new SingleResult();
            result.numberOfEvents = this.simulation.getScenario().numberOfEvents();
            result.eventNo = single.getEventNumber();
            result.vResults = single.getVictimResult();
            result.iResults = new LinkedHashMap<Integer, InterfererResultCollector>();
            result.eppResults = new LinkedHashMap<Integer, Collector>();
            int group = 1;
            for (InterferenceLink link : this.simulation.getScenario().getInterferenceLinks()) {
                List<InterferenceLinkResult> results = single.getInterferenceLinkResult(link);
                if (results.size() > 0) {
                    result.iResults.put(group, results.get(0).getInterferingSystemResult());
                }
                ++group;
            }
            for (Collector res : single.getEventProcessingResults()) {
                result.eppResults.put(group, res);
                ++group;
            }
            int events = this.simulation.getScenario().numberOfEvents();
            if (single.getEventNumber() < 1000) {
                this.sample(result);
            }
            if (single.getEventNumber() == events - 1) {
                result.eventResult = single;
            }
            return result;
        }
        catch (SimulationInvalidException e) {
            throw e;
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw new SimulationInvalidException("Simulation terminated due to error", e);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error");
        }
    }

    private void sample(SingleResult single) {
        int vSize;
        Set<Integer> sampleIdx;
        double pick = 1.0;
        if (single.numberOfEvents < 1000) {
            pick = 1000.0 / (double)single.numberOfEvents;
        }
        if ((sampleIdx = this.sample(vSize = single.vResults.getVictims().size(), pick)) == null) {
            for (Victim victim : single.vResults.getVictims()) {
                single.addVictimSample(victim.getLinkResult());
            }
        } else {
            for (Integer idx : sampleIdx) {
                single.addVictimSample(single.vResults.getVictims().get(idx).getLinkResult());
            }
        }
        ArrayList<Interferer> all = new ArrayList<Interferer>();
        for (InterfererResultCollector collector : single.iResults.values()) {
            all.addAll(collector.getInterferingElements());
        }
        sampleIdx = this.sample(all.size(), pick);
        if (sampleIdx == null) {
            for (Interferer interferer : all) {
                LinkResult linkResult = interferer.getLinkResult();
                linkResult.setValue(InterferenceSimulationEngine.INTERFERENCE_LINK_INDEX, interferer.getInterferenceLinkIndex());
                single.addInterfererSample(linkResult);
            }
        } else {
            for (Integer idx : sampleIdx) {
                LinkResult linkResult = ((Interferer)all.get(idx)).getLinkResult();
                linkResult.setValue(InterferenceSimulationEngine.INTERFERENCE_LINK_INDEX, ((Interferer)all.get(idx)).getInterferenceLinkIndex());
                single.addInterfererSample(linkResult);
            }
        }
    }

    private Set<Integer> sample(int size, double pick) {
        if ((double)size <= pick) {
            return null;
        }
        HashSet<Integer> sampleIdx = new HashSet<Integer>();
        while (pick > 0.0) {
            pick -= 1.0;
            this.sampleUnique(size, sampleIdx);
            if (!(pick < 1.0)) continue;
            pick -= 1.0;
            if (!(RandomAccessor.getRandom().nextDouble() < pick)) continue;
            this.sampleUnique(size, sampleIdx);
        }
        return sampleIdx;
    }

    private void sampleUnique(int size, Set<Integer> sample) {
        int i;
        while (sample.contains(i = RandomAccessor.getRandom().nextInt(size))) {
        }
        sample.add(i);
    }

    public EventResult single() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("===================================================");
            LOG.debug("==============  Begin event number " + this.eventNumber + " =====================");
            LOG.debug("===================================================");
        }
        this.seedFixer.fixSeed(this.simulationSeed, this.eventNumber);
        Scenario scenario = this.simulation.getScenario();
        VictimResultCollectorImpl vCollector = new VictimResultCollectorImpl(this.scenarioResults.getVictimResults());
        SimulationInstance victimSimulation = scenario.getVictim().simulationInstance();
        victimSimulation.victimSimulation(vCollector);
        EventResultImpl eventResult = new EventResultImpl(this.eventNumber, scenario.getInterferenceLinks(), vCollector);
        ArrayList<SimulationInstance> simulations = new ArrayList<SimulationInstance>();
        simulations.add(victimSimulation);
        ArrayList<InterferenceLink> coLocatedLinks = new ArrayList<InterferenceLink>();
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            CorrelationSetting correlation = link.getCorrelationSettings();
            if (link.isCoLocated()) {
                coLocatedLinks.add(link);
                continue;
            }
            SimulationInstance iSim = this.getISim(link, eventResult, simulations);
            InterfererResultCollector iCollector = eventResult.getInterferingSystemResult(link);
            Point2D victimPos = scenario.getVictim().getCorrelationDefinitions().getVictimPosition(vCollector, link.getCorrelationSettings().getPositionRelativeTo());
            Point2D correlationVector = correlation.getCorrelationMode().getCorrelationVector(link, iCollector.getPreSimulationResults());
            Point2D deltaVector = correlation.trialDelta();
            Point2D interferingSystemPosition = victimPos.add(deltaVector).add(correlationVector);
            iSim.interferingSystemSimulation(eventResult, link, interferingSystemPosition);
            iCollector.add(SYSTEM_CENTER, interferingSystemPosition);
        }
        for (InterferenceLink link : coLocatedLinks) {
            SimulationInstance iSim = this.getISim(link, eventResult, simulations);
            InterfererResultCollector iCollector = eventResult.getInterferingSystemResult(link);
            CorrelationSetting correlation = link.getCorrelationSettings();
            InterfererResultCollector coLocated = eventResult.getInterferingSystemResult(correlation.getCoLocatedWith());
            for (Interferer inter : coLocated.getInterferingElements()) {
                LinkResult result = inter.getLinkResult().add(correlation.trialDelta());
                List<Point2D> points = coLocated.getScatterPoints(SYSTEM_CENTER);
                Point2D position = result.txAntenna().getPosition();
                if (points.contains(inter.getLinkResult().rxAntenna().getPosition())) {
                    position = result.rxAntenna().getPosition();
                }
                iCollector.add(SYSTEM_CENTER, position);
                iSim.interferingSystemSimulation(eventResult, link, position, result);
            }
        }
        Map<Victim, List<InterferenceLinkResult>> victimResultMap = this.combine(eventResult);
        victimSimulation.interferedVictimSimulation(eventResult);
        Receiver victimReceiver = scenario.getVictim().getSystem().getReceiver();
        if (victimReceiver.isUsingOverloading()) {
            new Overloading(scenario).collect(eventResult);
        }
        if (victimReceiver.isIntermodulationRejectionOption()) {
            new Intermodulation(scenario).collect(eventResult);
        }
        this.calculateIRSS(scenario, eventResult, victimSimulation, victimResultMap);
        victimSimulation.postEvent(eventResult);
        for (EventProcessing epp : scenario.getEventProcessingList()) {
            CollectorImpl rc = new CollectorImpl();
            epp.evaluate(scenario, eventResult, rc);
            eventResult.getEventProcessingResults().add(rc);
        }
        this.simulation.eventComplete(eventResult, simulations);
        return eventResult;
    }

    private SimulationInstance getISim(InterferenceLink link, EventResult eventResult, List<SimulationInstance> simulations) {
        InterfererResultCollectorImpl iCollector = new InterfererResultCollectorImpl(this.scenarioResults.getResults(link), link);
        eventResult.addInterfererResultCollector(iCollector);
        SimulationInstance iSim = link.getInterferer().simulationInstance();
        simulations.add(iSim);
        return iSim;
    }

    private Map<Victim, List<InterferenceLinkResult>> combine(EventResult eventResult) {
        HashMap<Victim, List<InterferenceLinkResult>> result = new HashMap<Victim, List<InterferenceLinkResult>>();
        for (Victim victim : eventResult.getVictimResult().getVictims()) {
            result.put(victim, new ArrayList());
            double sumUnw_mW = 0.0;
            double sumBloc_mW = 0.0;
            for (InterfererResultCollector collector : eventResult.getAllInterferingSystemResults()) {
                for (Interferer interferer : collector.getInterferingElements()) {
                    InterferenceLinkResultImpl iLink = new InterferenceLinkResultImpl(collector.getLink(), victim, interferer, eventResult.getVictimResult(), collector);
                    ((List)result.get(victim)).add(iLink);
                    eventResult.addInterferenceLinkResult(iLink);
                    AntennaGain vAntennaGain = victim.getAntennaGain();
                    iLink.rxAntenna().setGain(vAntennaGain.evaluate(iLink, iLink.rxAntenna()));
                    Double vElementGain = (Double)iLink.getValue(BeamFormingComposite.ELEMENT_GAIN);
                    AntennaGain iAntennaGain = interferer.getAntennaGain();
                    iLink.txAntenna().setGain(iAntennaGain.evaluate(iLink, iLink.txAntenna()));
                    Double iElementGain = (Double)iLink.getValue(BeamFormingComposite.ELEMENT_GAIN);
                    this.itVrPropagationLoss(iLink, interferer.getMinimumCouplingLoss());
                    iLink.setRiRSSUnwantedValue(InterferenceCalculator.unwantedInterference(collector.getPreSimulationResults(), iLink));
                    iLink.setBlockingAttenuation(InterferenceCalculator.blockingAttenuation(collector.getPreSimulationResults(), iLink));
                    iLink.setRiRSSBlockingValue(InterferenceCalculator.blockingInterference(iLink));
                    if (!this.hasOverlap(iLink)) {
                        double compositeGain;
                        BeamFormingCompositeInput input;
                        if (vAntennaGain.getPlugin() instanceof BeamFormingComposite && (input = (BeamFormingCompositeInput)vAntennaGain.getModel()).pattern() == BeamFormingCompositeInput.AntennaPattern.ELEMENT) {
                            compositeGain = iLink.rxAntenna().getGain();
                            iLink.rxAntenna().setGain(vElementGain);
                            this.itVrEffectivePropagationLoss(iLink, interferer.getMinimumCouplingLoss());
                            iLink.setBlockingAttenuation(InterferenceCalculator.blockingAttenuation(collector.getPreSimulationResults(), iLink));
                            iLink.setRiRSSBlockingValue(InterferenceCalculator.blockingInterference(iLink));
                            iLink.rxAntenna().setGain(compositeGain);
                            this.itVrEffectivePropagationLoss(iLink, interferer.getMinimumCouplingLoss());
                        }
                        iLink.txAntenna().setGain(iAntennaGain.evaluate(iLink, iLink.txAntenna()));
                        if (iAntennaGain.getPlugin() instanceof BeamFormingComposite && (input = (BeamFormingCompositeInput)iAntennaGain.getModel()).pattern() == BeamFormingCompositeInput.AntennaPattern.ELEMENT) {
                            compositeGain = iLink.txAntenna().getGain();
                            iLink.txAntenna().setGain(iElementGain);
                            this.itVrEffectivePropagationLoss(iLink, interferer.getMinimumCouplingLoss());
                            iLink.setRiRSSUnwantedValue(InterferenceCalculator.unwantedInterference(collector.getPreSimulationResults(), iLink));
                            iLink.txAntenna().setGain(compositeGain);
                            this.itVrEffectivePropagationLoss(iLink, interferer.getMinimumCouplingLoss());
                        }
                    }
                    eventResult.addExternalInterferer(victim, interferer, iLink.getRiRSSUnwantedValue(), iLink.getRiRSSBlockingValue());
                    sumUnw_mW += Mathematics.dB2Linear(iLink.getRiRSSUnwantedValue());
                    sumBloc_mW += Mathematics.dB2Linear(iLink.getRiRSSBlockingValue());
                }
            }
            double totalU = Mathematics.linear2dB(sumUnw_mW);
            double totalB = Mathematics.linear2dB(sumBloc_mW);
            victim.adjustTotalInterference(totalU, totalB);
            eventResult.setTotalInterference(victim, totalU, totalB);
        }
        return result;
    }

    private boolean hasOverlap(InterferenceLinkResult iLink) {
        double vBandwidth = iLink.getInterferenceLink().getVictim().getSystem().getReceiver().getBandwidth();
        double iBandwidth = iLink.getInterferenceLink().getInterferer().getSystem().getTransmitter().getBandwidth();
        double iFrequency = iLink.getFrequency();
        double vFrequency = iLink.getVictim().getLinkResult().getFrequency();
        return Mathematics.equals(iFrequency, vFrequency, (vBandwidth + iBandwidth) / 2.0);
    }

    private void calculateIRSS(Scenario scenario, EventResult eventResult, SimulationInstance victimSimulation, Map<Victim, List<InterferenceLinkResult>> victimResultMap) {
        double irssBlo_dBm;
        double irssUnw_dBm;
        VictimResultCollector vCollector = eventResult.getVictimResult();
        double sumUnw_mW = 0.0;
        double sumBloc_mW = 0.0;
        ArrayList<Double> unwAll = new ArrayList<Double>();
        ArrayList<Double> bloAll = new ArrayList<Double>();
        ArrayList<Double> intAll = new ArrayList<Double>();
        List<Victim> victims = victimSimulation.getResultingVictims(vCollector);
        ArrayList relevantResults = new ArrayList();
        for (Victim vic : victims) {
            double u = eventResult.totalInterferenceUnwanted(vic);
            sumUnw_mW += Mathematics.dB2Linear(u);
            double b = eventResult.totalInterferenceBlocking(vic);
            sumBloc_mW += Mathematics.dB2Linear(b);
            unwAll.add(u);
            bloAll.add(b);
            intAll.add(Mathematics.linear2dB(Mathematics.dB2Linear(u) + Mathematics.dB2Linear(b)));
            relevantResults.addAll(victimResultMap.get(vic));
        }
        if (scenario.getInterferenceLinks().size() > 1) {
            for (int i = 0; i < scenario.getInterferenceLinks().size(); ++i) {
                InterferenceLink link = scenario.getInterferenceLinks().get(i);
                double u_contribution = 0.0;
                double b_contribution = 0.0;
                for (InterferenceLinkResult linkResult : eventResult.getInterferenceLinkResult(link)) {
                    if (!relevantResults.remove(linkResult)) continue;
                    u_contribution += Mathematics.dB2Linear(linkResult.getRiRSSUnwantedValue());
                    b_contribution += Mathematics.dB2Linear(linkResult.getRiRSSBlockingValue());
                }
                String uName = "iRSS Unwanted: Link " + (i + 1) + " (" + link.getInterferer().getName() + ")";
                vCollector.add(Factory.results().group("iRSS Unwanted", uName, "dBm"), Mathematics.linear2dB(u_contribution));
                String bName = "iRSS Blocking: Link " + (i + 1) + " (" + link.getInterferer().getName() + ")";
                vCollector.add(Factory.results().group("iRSS Blocking", bName, "dBm"), Mathematics.linear2dB(b_contribution));
            }
        }
        VectorDefinitions names = this.simulation.getNames();
        vCollector.add(names.getEXTERNAL_INTER_UNW(), unwAll);
        vCollector.add(names.getEXTERNAL_INTER_BLOC(), bloAll);
        vCollector.add(names.getEXTERNAL_INTERFERENCE(), intAll);
        if (victims.isEmpty()) {
            irssUnw_dBm = -1000.0;
            irssBlo_dBm = -1000.0;
        } else {
            irssUnw_dBm = Mathematics.linear2dB(sumUnw_mW);
            irssBlo_dBm = Mathematics.linear2dB(sumBloc_mW);
        }
        vCollector.add(names.getIRSS_UNWANTED(), irssUnw_dBm);
        vCollector.add(names.getIRSS_BLOCKING(), irssBlo_dBm);
        vCollector.add(Factory.results().value(names.getIRSS_UNWANTED().name() + " + " + names.getIRSS_BLOCKING().name(), "dBm"), Mathematics.linear2dB(Mathematics.dB2Linear(irssUnw_dBm) + Mathematics.dB2Linear(irssBlo_dBm)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("External Unwanted = " + irssUnw_dBm + " dBm");
            LOG.debug("External Blocking = " + irssBlo_dBm + " dBm");
        }
    }

    private void itVrPropagationLoss(InterferenceLinkResult result, double minimumCouplingLoss) {
        result.setTxRxPathLoss(result.getInterferenceLink().getPropagationModel().evaluate(result));
        this.itVrEffectivePropagationLoss(result, minimumCouplingLoss);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Interfering Transmitter -> Victim Receiver Antenna Gain = " + result.txAntenna().getGain());
            LOG.debug("Victim Receiver -> Interfering Transmitter Antenna Gain = " + result.rxAntenna().getGain());
            LOG.debug("Interfering Transmitter -> Victim Receiver Path Loss = " + result.getTxRxPathLoss());
            LOG.debug("Interfering Transmitter -> Victim Receiver Effective Path Loss (with MCL)= " + result.getEffectiveTxRxPathLoss());
        }
    }

    private void itVrEffectivePropagationLoss(InterferenceLinkResult result, double minimumCouplingLoss) {
        double loss = result.getTxRxPathLoss();
        double txG = result.txAntenna().getGain();
        double rxG = result.rxAntenna().getGain();
        result.setEffectiveTxRxPathLoss(Math.max(loss - txG - rxG, minimumCouplingLoss));
    }
}

