/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.eventprocessing;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import org.seamcat.model.Scenario;
import org.seamcat.model.plugin.eventprocessing.ModelPanel;
import org.seamcat.model.plugin.eventprocessing.PanelDefinition;
import org.seamcat.model.plugin.eventprocessing.Panels;
import org.seamcat.model.plugin.eventprocessing.PostProcessingUI;
import org.seamcat.plugin.PostProcessingUIState;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.components.BorderPanel;
import org.seamcat.presentation.genericgui.panelbuilder.GenericPanelEditor;

public class PostProcessingUIPanels
implements PostProcessingUI {
    private PostProcessingUI decorated;
    private PostProcessingUIState state;
    private Map<String, ModelPanel> panelsMap;
    private Panels panels;

    public PostProcessingUIPanels(PostProcessingUI decorated, PostProcessingUIState state) {
        this.decorated = decorated;
        this.state = state;
        this.panelsMap = new HashMap<String, ModelPanel>();
        for (Map.Entry<PanelDefinition<?>, Object> entry : state.get().entrySet()) {
            final PanelDefinition<?> key = entry.getKey();
            final GenericPanelEditor<Object> editor = new GenericPanelEditor<Object>(MainWindow.getInstance(), key.getModelClass(), entry.getValue());
            final BorderPanel panel = new BorderPanel(new JScrollPane(editor), key.getName());
            this.panelsMap.put(key.getName(), new ModelPanel(){

                @Override
                public JPanel getPanel() {
                    return panel;
                }

                public Object getModel() {
                    return editor.getMutableMapListsModel();
                }

                @Override
                public PanelDefinition getDefinition() {
                    return key;
                }
            });
        }
        this.panels = new Panels(){

            @Override
            public <T> ModelPanel<T> get(String name) {
                return (ModelPanel)PostProcessingUIPanels.this.panelsMap.get(name);
            }
        };
    }

    public PostProcessingUIState getState() {
        HashMap models = new HashMap();
        for (ModelPanel mp : this.panelsMap.values()) {
            models.put(mp.getDefinition(), mp.getModel());
        }
        return new PostProcessingUIState(this.state.getId(), models);
    }

    @Override
    public String getTitle() {
        return this.decorated.getTitle();
    }

    @Override
    public void buildUI(Scenario scenario, JPanel canvas, Panels panels) {
        this.decorated.buildUI(scenario, canvas, this.panels);
    }

    @Override
    public PanelDefinition[] panelDefinitions() {
        return this.decorated.panelDefinitions();
    }

    public PostProcessingUI getDecorated() {
        if (this.decorated instanceof PostProcessingUIPanels) {
            return ((PostProcessingUIPanels)this.decorated).getDecorated();
        }
        return this.decorated;
    }

    public Panels getPanels() {
        return this.panels;
    }

    public void updateModel() {
        this.state.get().clear();
        this.state.get().putAll(this.getState().get());
    }
}

