/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.UIPosition;
import org.seamcat.model.plugin.UITab;

public class Cache {
    private static Map<Class<?>, List<Method>> cache = new HashMap();

    public static List<Method> ordered(Class<?> compositeClass) {
        if (cache.containsKey(compositeClass)) {
            return cache.get(compositeClass);
        }
        TreeMap<Integer, Method> positions = new TreeMap<Integer, Method>();
        TreeMap<Integer, Method> tabs = new TreeMap<Integer, Method>();
        for (Method method : compositeClass.getDeclaredMethods()) {
            UITab tab;
            UIPosition panel = method.getAnnotation(UIPosition.class);
            if (panel != null) {
                positions.put(panel.col() * 10 + panel.row(), method);
            }
            if ((tab = method.getAnnotation(UITab.class)) == null) continue;
            tabs.put(tab.order(), method);
        }
        ArrayList<Method> ordered = new ArrayList<Method>(positions.values());
        ordered.addAll(tabs.values());
        cache.put(compositeClass, ordered);
        return ordered;
    }

    public static List<Method> orderedConfig(Class panelClass) {
        if (cache.containsKey(panelClass)) {
            return cache.get(panelClass);
        }
        TreeMap<Integer, Method> methods = new TreeMap<Integer, Method>();
        for (Method method : panelClass.getDeclaredMethods()) {
            Config config = method.getAnnotation(Config.class);
            if (config == null) continue;
            methods.put(config.order(), method);
        }
        ArrayList<Method> ordered = new ArrayList<Method>(methods.values());
        cache.put(panelClass, ordered);
        return ordered;
    }

    public static <T extends Annotation> LinkedHashMap<Method, T> ordered(Class<T> annClass, Class<?> clazz, Order<T> order) {
        HashMap<Method, T> annotations = new HashMap<Method, T>();
        TreeMap<Integer, Method> sorted = new TreeMap<Integer, Method>();
        for (Method method : clazz.getDeclaredMethods()) {
            T t = method.getAnnotation(annClass);
            if (t == null) continue;
            sorted.put(order.getOrder(t), method);
            annotations.put(method, t);
        }
        LinkedHashMap result = new LinkedHashMap();
        for (Method method : sorted.values()) {
            result.put(method, annotations.get(method));
        }
        return result;
    }

    public static interface Order<T> {
        public int getOrder(T var1);
    }
}

