/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.prefs.Preferences;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.apache.log4j.PatternLayout;
import org.seamcat.Seamcat;
import org.seamcat.commands.LibraryUpdatedEvent;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.eventprocessing.DemoEPP_10_OFDMA_Internals;
import org.seamcat.eventprocessing.DemoEPP_13_ValidateDataAP;
import org.seamcat.eventprocessing.DemoEPP_1_collectIntermediaryResults;
import org.seamcat.eventprocessing.DemoEPP_2_developNewAlgorithm;
import org.seamcat.eventprocessing.DemoEPP_3_developNewAlgorithm_checkTxPower;
import org.seamcat.eventprocessing.DemoEPP_4_generate_CoverI_results;
import org.seamcat.eventprocessing.DemoEPP_5_Tx_Power;
import org.seamcat.eventprocessing.DemoEPP_6_CellularInternals;
import org.seamcat.eventprocessing.DemoEPP_7_Frequency;
import org.seamcat.eventprocessing.DemoEPP_8_Distance;
import org.seamcat.eventprocessing.DemoEPP_9_Intermod;
import org.seamcat.eventprocessing.demo11.DempEPP_11_ReportAntennaGains;
import org.seamcat.eventprocessing.ituantennas.DemoEPP_12_TestITUantennas;
import org.seamcat.loadsave.WorkspaceLoader;
import org.seamcat.loadsave.WorkspaceSaver;
import org.seamcat.marshalling.LibraryMarshaller;
import org.seamcat.migration.IOUtils;
import org.seamcat.migration.MigrationIssue;
import org.seamcat.migration.workspace.WorkspaceMigrator;
import org.seamcat.model.InterferenceLinkElement;
import org.seamcat.model.Library;
import org.seamcat.model.LibraryModel;
import org.seamcat.model.Workspace;
import org.seamcat.model.antenna.AntennaManufacturerData;
import org.seamcat.model.antenna.Antenna_3GPP_TR_36_814;
import org.seamcat.model.antenna.Antenna_3GPP_TR_37_840;
import org.seamcat.model.antenna.BeamFormingComposite;
import org.seamcat.model.antenna.BeamFormingElement;
import org.seamcat.model.antenna.HorizontalVerticalAntenna;
import org.seamcat.model.antenna.ITU_R_F1245;
import org.seamcat.model.antenna.ITU_R_F1336_4_rec_2;
import org.seamcat.model.antenna.ITU_R_F1336_4_rec_3;
import org.seamcat.model.antenna.ITU_R_F699;
import org.seamcat.model.antenna.PeakGainAntenna;
import org.seamcat.model.antenna.SphericalAntenna;
import org.seamcat.model.correlation.Closest;
import org.seamcat.model.correlation.ILRAtCenter;
import org.seamcat.model.distributions.DistributionFactoryImpl;
import org.seamcat.model.engines.SimulationPool;
import org.seamcat.model.factory.BuildersImpl;
import org.seamcat.model.factory.DataExporterImpl;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.FunctionFactoryImpl;
import org.seamcat.model.factory.PluginFactoryImpl;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.IntermodulationRejectionMask;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.propagation.FreeSpacePropagationModel;
import org.seamcat.model.propagation.HataSE21PropagationModel;
import org.seamcat.model.propagation.HataSE24PropagationModel;
import org.seamcat.model.propagation.JTG56PropagationModel;
import org.seamcat.model.propagation.LongleyRice_mod;
import org.seamcat.model.propagation.Model_C_IEEE_802_11_rev3;
import org.seamcat.model.propagation.P1411LowAntennaHeight;
import org.seamcat.model.propagation.P1411ver9PropagationModel;
import org.seamcat.model.propagation.P1546ver1PropagationModel;
import org.seamcat.model.propagation.P1546ver4PropagationModel;
import org.seamcat.model.propagation.P1546ver5PropagationModel;
import org.seamcat.model.propagation.P2001ver2PropagationModel;
import org.seamcat.model.propagation.P452ver14PropagationModel;
import org.seamcat.model.propagation.P452ver16PropagationModel;
import org.seamcat.model.propagation.SDPropagationModel;
import org.seamcat.model.propagation.p528.P528PropagationModel;
import org.seamcat.model.systems.aggregate.AggregateSystemPlugin;
import org.seamcat.model.systems.generic.ReceiverModel;
import org.seamcat.model.systems.generic.SystemModelGeneric;
import org.seamcat.model.systems.generic.TransmitterModel;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020uplink.IMT2020UpLinkSystemPlugin;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.EventProcessing;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.SystemPluginConfiguration;
import org.seamcat.model.workspace.InterferenceLinkUI;
import org.seamcat.model.workspace.SimulationControl;
import org.seamcat.persistence.Marshaller;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.plugin.AntennaGainFactoryImpl;
import org.seamcat.plugin.BuiltInPlugins;
import org.seamcat.plugin.CorrelationModeFactoryImpl;
import org.seamcat.plugin.CoverageRadiusConfiguration;
import org.seamcat.plugin.CoverageRadiusFactoryImpl;
import org.seamcat.plugin.EventProcessingConfiguration;
import org.seamcat.plugin.EventProcessingFactoryImpl;
import org.seamcat.plugin.JarFiles;
import org.seamcat.plugin.PluginSerializerUtil;
import org.seamcat.plugin.PropagationModelConfiguration;
import org.seamcat.plugin.PropagationModelFactoryImpl;
import org.seamcat.presentation.DialogHelper;
import org.seamcat.presentation.MainWindow;
import org.seamcat.presentation.ProgressDialog;
import org.seamcat.presentation.genericgui.LongTaskFailable;
import org.seamcat.presentation.genericgui.LongTaskSwingExecutor;
import org.seamcat.presentation.systems.InterferenceLinksPanel;
import org.seamcat.presentation.systems.SystemListItem;
import org.seamcat.simulation.coverageradius.NoiseLimitedCoverageRadius;
import org.seamcat.simulation.coverageradius.TrafficLimitedNetworkCoverageRadius;
import org.seamcat.simulation.coverageradius.UserDefinedCoverageRadius;
import org.seamcat.simulation.generic.GenericSystemPlugin;
import org.seamcat.simulation.hybrid.HybridCDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMADownLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin;
import org.seamcat.simulation.result.ResultFactoryImpl;

public final class Model {
    public static File seamcatHome;
    private static final Logger LOG;
    private static final ResourceBundle STRINGLIST;
    private static final SimulationPool simulationPool;
    private static boolean SHOW_WELCOME;
    private static final String DEFAULT_SETTINGS_FILE_NAME = "/default-library.sli";
    private static final String SETTINGS_FILE_NAME = "settings.xml";
    private static final String PREHISTORIC_SETTINGS_FILE_NAME = "seamcat.xml";
    private static final char[] ILLEGAL_FILENAME_CHARS;
    private static File seamcatTemp;
    private static final Model MODEL;
    private static boolean initialized;
    private static Preferences preferences;
    private final PatternLayout filePattern = new PatternLayout();
    private FileAppender fileAppender = new FileAppender();
    private Library library;
    private final List<Class<? extends Plugin>> builtInPlugins;
    private final List<Class<? extends SystemPlugin>> builtInSystemPlugins;

    public static SimulationPool getSimulationPool() {
        return simulationPool;
    }

    public static String getSeamcatHomeBaseDir() {
        return preferences.get("SEAMCAT_HOME", System.getProperty("user.home") + File.separator + "seamcat-app");
    }

    public static String getSeamcatHomeDir() {
        return Model.getSeamcatHomeBaseDir() + File.separator + STRINGLIST.getString("APPLICATION_TITLE");
    }

    public static void setSeamcatBaseDir(String home) {
        preferences.put("SEAMCAT_HOME", home);
    }

    private static String getSeamcatTempDir() {
        return seamcatTemp.getAbsolutePath();
    }

    private Model() {
        preferences = Preferences.userNodeForPackage(Seamcat.class);
        String scdir = Model.getSeamcatHomeDir();
        seamcatHome = new File(scdir);
        Model.createDir(seamcatHome);
        seamcatTemp = new File(scdir + File.separator + "temp");
        Model.createDir(seamcatTemp);
        Model.createDir(new File(scdir + File.separator + "reports"));
        Model.ensureFile(seamcatHome.getAbsolutePath() + File.separator + DEFAULT_SETTINGS_FILE_NAME, DEFAULT_SETTINGS_FILE_NAME);
        this.builtInPlugins = Model.makeBuiltInPluginsList();
        this.builtInSystemPlugins = Model.makeBuiltInSystemPluginsList();
        PluginSerializerUtil.jarFileSerializerDir = Model.getSeamcatTempDir();
        Factory.initialize(new DistributionFactoryImpl(), new PropagationModelFactoryImpl(), new BuildersImpl(), new AntennaGainFactoryImpl(), new FunctionFactoryImpl(), new CoverageRadiusFactoryImpl(), new EventProcessingFactoryImpl(), new CorrelationModeFactoryImpl(), new PluginFactoryImpl(), new ResultFactoryImpl(), new DataExporterImpl());
        BuiltInPlugins.initialize(this.builtInPlugins, this.builtInSystemPlugins);
    }

    public static List<Class<? extends Plugin>> makeBuiltInPluginsList() {
        ArrayList<Class> tmp = new ArrayList<Class>();
        tmp.add(DemoEPP_1_collectIntermediaryResults.class);
        tmp.add(DemoEPP_2_developNewAlgorithm.class);
        tmp.add(DemoEPP_3_developNewAlgorithm_checkTxPower.class);
        tmp.add(DemoEPP_4_generate_CoverI_results.class);
        tmp.add(DemoEPP_5_Tx_Power.class);
        tmp.add(DemoEPP_6_CellularInternals.class);
        tmp.add(DemoEPP_7_Frequency.class);
        tmp.add(DemoEPP_8_Distance.class);
        tmp.add(DemoEPP_9_Intermod.class);
        tmp.add(DemoEPP_10_OFDMA_Internals.class);
        tmp.add(DempEPP_11_ReportAntennaGains.class);
        tmp.add(DemoEPP_12_TestITUantennas.class);
        tmp.add(DemoEPP_13_ValidateDataAP.class);
        tmp.add(HataSE21PropagationModel.class);
        tmp.add(HataSE24PropagationModel.class);
        tmp.add(P452ver14PropagationModel.class);
        tmp.add(P452ver16PropagationModel.class);
        tmp.add(FreeSpacePropagationModel.class);
        tmp.add(SDPropagationModel.class);
        tmp.add(P528PropagationModel.class);
        tmp.add(P1411LowAntennaHeight.class);
        tmp.add(P1411ver9PropagationModel.class);
        tmp.add(P1546ver1PropagationModel.class);
        tmp.add(P1546ver4PropagationModel.class);
        tmp.add(P1546ver5PropagationModel.class);
        tmp.add(P2001ver2PropagationModel.class);
        tmp.add(JTG56PropagationModel.class);
        tmp.add(Model_C_IEEE_802_11_rev3.class);
        tmp.add(LongleyRice_mod.class);
        tmp.add(UserDefinedCoverageRadius.class);
        tmp.add(NoiseLimitedCoverageRadius.class);
        tmp.add(TrafficLimitedNetworkCoverageRadius.class);
        tmp.add(PeakGainAntenna.class);
        tmp.add(HorizontalVerticalAntenna.class);
        tmp.add(SphericalAntenna.class);
        tmp.add(ITU_R_F699.class);
        tmp.add(ITU_R_F1245.class);
        tmp.add(ITU_R_F1336_4_rec_2.class);
        tmp.add(ITU_R_F1336_4_rec_3.class);
        tmp.add(AntennaManufacturerData.class);
        tmp.add(BeamFormingElement.class);
        tmp.add(BeamFormingComposite.class);
        tmp.add(Antenna_3GPP_TR_36_814.class);
        tmp.add(Antenna_3GPP_TR_37_840.class);
        return Collections.unmodifiableList(tmp);
    }

    public static List<Class<? extends SystemPlugin>> makeBuiltInSystemPluginsList() {
        ArrayList<Class> sysTmp = new ArrayList<Class>();
        sysTmp.add(GenericSystemPlugin.class);
        sysTmp.add(HybridCDMAUpLinkPlugin.class);
        sysTmp.add(HybridCDMADownLinkPlugin.class);
        sysTmp.add(HybridOFDMAUpLinkPlugin.class);
        sysTmp.add(HybridOFDMADownLinkPlugin.class);
        sysTmp.add(IMT2020DownLinkSystemPlugin.class);
        sysTmp.add(IMT2020DownLinkMicroSystemPlugin.class);
        sysTmp.add(IMT2020UpLinkSystemPlugin.class);
        sysTmp.add(IMT2020UpLinkMicroSystemPlugin.class);
        sysTmp.add(AggregateSystemPlugin.class);
        return Collections.unmodifiableList(sysTmp);
    }

    private static void createDir(File dir) {
        if (!dir.exists() && !dir.mkdirs()) {
            LOG.error("Could not create dir: " + dir.getAbsolutePath());
        }
    }

    public List<Class<? extends Plugin>> getBuiltInPlugins() {
        return this.builtInPlugins;
    }

    public List<Class<? extends SystemPlugin>> getBuiltInSystemPlugins() {
        return this.builtInSystemPlugins;
    }

    public static File getReportDirectory() {
        return new File(seamcatHome.getAbsoluteFile() + File.separator + "reports" + File.separator);
    }

    private static File getDefaultLibraryFile() {
        return new File(seamcatHome.getAbsolutePath(), DEFAULT_SETTINGS_FILE_NAME);
    }

    private static File getSettingsFile() {
        return new File(seamcatHome.getAbsolutePath(), SETTINGS_FILE_NAME);
    }

    public static File getPrehistoricSettingsFile() {
        return new File(seamcatHome.getAbsolutePath(), PREHISTORIC_SETTINGS_FILE_NAME);
    }

    private void init() {
        LibraryModel model = null;
        try {
            model = LibraryMarshaller.loadAndParseSettingsFile(Model.getSettingsFile(), Model.getPrehistoricSettingsFile());
        }
        catch (Exception e) {
            LOG.warn("Error parsing settings file. Will revert to default settings", e);
        }
        if (model == null) {
            model = LibraryMarshaller.loadAndParseSettingsFile(Model.getDefaultLibraryFile(), Model.getPrehistoricSettingsFile());
        }
        if (model == null) {
            model = Factory.instance(LibraryModel.class);
        }
        this.library = new Library(model);
        this.filePattern.setConversionPattern(this.getLogPatterns()[0]);
        this.fileAppender.setAppend(true);
        this.fileAppender.setLayout(this.getLogFilePattern());
        this.fileAppender.setFile(seamcatHome.getAbsolutePath() + File.separator + "seamcat.log");
        this.fileAppender.activateOptions();
    }

    private static void ensureFile(String url, String origUrl) {
        try {
            int readLength;
            File file = new File(url);
            BufferedInputStream ins = new BufferedInputStream(Model.class.getResourceAsStream(origUrl));
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[4096];
            while ((readLength = ((InputStream)ins).read(buffer)) > -1) {
                ((OutputStream)out).write(buffer, 0, readLength);
            }
            ((InputStream)ins).close();
            ((OutputStream)out).close();
        }
        catch (IOException ex) {
            LOG.warn("Error copying file: " + origUrl, ex);
        }
    }

    public static Model getInstance() {
        if (!initialized) {
            initialized = true;
            MODEL.init();
            MODEL.getLibrary().ensureConsistentLibrary();
        }
        return MODEL;
    }

    public final Library getLibrary() {
        if (this.library == null) {
            Model.getInstance();
        }
        return this.library;
    }

    public Appender getLogFileAppender() {
        return this.fileAppender;
    }

    public PatternLayout getLogFilePattern() {
        return this.filePattern;
    }

    public final synchronized void persist() {
        File file = seamcatHome;
        if (!file.exists()) {
            file.mkdirs();
        }
        final ProgressDialog progressDialog = new ProgressDialog(MainWindow.getInstance());
        progressDialog.setTitle("Saving SEAMCAT Library");
        progressDialog.setExplanation("Saving the full SEAMCAT Library in: " + file.getAbsolutePath());
        progressDialog.setProgressMessage("Saving SEAMCAT Library");
        LongTaskSwingExecutor.execute(new LongTaskFailable(){

            @Override
            public Object process() throws Exception {
                Marshaller marshaller = IOUtils.fromOutputStream(new FileOutputStream(Model.getSettingsFile()));
                marshaller.beginElement("seamcat");
                GenericTypeMarshaller.toElement(LibraryModel.class, marshaller, Model.this.library.getModel());
                marshaller.endElement("seamcat");
                marshaller.close();
                EventBusFactory.getEventBus().publish(new LibraryUpdatedEvent());
                return null;
            }

            @Override
            public void done(Object result) {
                progressDialog.close();
            }

            @Override
            public void failed(Exception exception) {
                progressDialog.close();
                LOG.error("Exception while saving", exception);
                DialogHelper.saveError();
            }
        });
        progressDialog.showModally();
    }

    public String[] getLogPatterns() {
        return new String[]{"(%F:%L[%M]) - %m%n", "%-5p [%d]: %m%n", "%-5p: %m%n", "[%t]: %m%n", "%m%n", "%d{dd MMM yyyy HH:mm:ss,SSS} %5p [%t] (%F:%L[%M]) - %m%n"};
    }

    public static boolean checkFilename(String filename) {
        int filechars = filename.length();
        for (int x = 0; x < filechars; ++x) {
            char filechar = filename.charAt(x);
            for (char ILLEGAL_FILENAME_CHAR : ILLEGAL_FILENAME_CHARS) {
                if (filechar != ILLEGAL_FILENAME_CHAR) continue;
                return false;
            }
        }
        return true;
    }

    public static String getWorkspacePath() {
        return seamcatHome.getAbsolutePath() + File.separator + "workspaces" + File.separator;
    }

    public static SystemModelGeneric defaultGeneric() {
        SystemModelGeneric system = ProxyHelper.newComposite(SystemModelGeneric.class);
        SystemModelGeneric systemProto = Factory.prototype(SystemModelGeneric.class, system);
        Factory.when(systemProto.receiver()).thenReturn(ProxyHelper.newComposite(ReceiverModel.class));
        Factory.when(systemProto.transmitter()).thenReturn(ProxyHelper.newComposite(TransmitterModel.class));
        return Factory.build(systemProto);
    }

    public static Workspace openDefaultWorkspace() {
        Workspace ws = new Workspace();
        ws.setSystemPlugins(new ArrayList<SystemPlugin>());
        GenericSystemPlugin plugin = new GenericSystemPlugin();
        plugin.setUI(Model.defaultGeneric());
        ws.getSystemPlugins().add(plugin);
        ws.setVictimFrequency(Factory.distributionFactory().getConstantDistribution(900.0));
        ws.setVictimSystemId(plugin.getUI().id());
        ws.setInterferenceLinkUIs(new ArrayList<InterferenceLinkElement>());
        InterferenceLinkUI settings = ProxyHelper.newComposite(InterferenceLinkUI.class);
        Map<Class, Object> customUI = settings.path().correlationSettings().customUI();
        customUI.put(Closest.class, Factory.instance(Closest.class));
        customUI.put(ILRAtCenter.class, Factory.instance(ILRAtCenter.class));
        InterferenceLinkElement ilElement = new InterferenceLinkElement(plugin.getUI().id(), InterferenceLinksPanel.getILName(1, plugin, ws), settings);
        ws.addInterferenceLink(ilElement, Factory.distributionFactory().getConstantDistribution(900.0));
        ws.setSimulationControl(Factory.instance(SimulationControl.class));
        ws.setName(STRINGLIST.getString("WORKSPACE_NAME_PREFIX"));
        return ws;
    }

    public static void saveWorkspace(Workspace workspace) {
        File outputURL = workspace.getPath();
        outputURL = outputURL == null ? Model.ensureDefaultWorkspaceDirectory() : outputURL.getParentFile();
        String filename = workspace.getName();
        if (!Model.checkFilename(filename)) {
            throw new RuntimeException("File contains illegal characters: " + filename);
        }
        File file = new File(outputURL, workspace.getName() + workspace.getFileExtension());
        workspace.setPath(file);
        WorkspaceSaver workspaceSaver = new WorkspaceSaver(workspace);
        workspaceSaver.saveToFile(file);
    }

    public static Workspace openWorkspace(File file) throws Exception {
        ArrayList<MigrationIssue> migrationIssues = new ArrayList<MigrationIssue>();
        File fileToLoad = new WorkspaceMigrator().migrate(file, migrationIssues);
        WorkspaceLoader loader = new WorkspaceLoader();
        Workspace workspace = loader.loadFromFile(fileToLoad);
        workspace.setMigrationIssues(migrationIssues);
        workspace.setPath(file.getAbsoluteFile());
        if (loader.isCancelled()) {
            return null;
        }
        return workspace;
    }

    public boolean showWelcomeScreen() {
        return SHOW_WELCOME;
    }

    public void setShowWelcome(boolean showWelcome) {
        SHOW_WELCOME = showWelcome;
    }

    public static File ensureDefaultWorkspaceDirectory() {
        File outputURL = new File(seamcatHome.getAbsolutePath() + File.separator + "workspaces" + File.separator);
        if (!outputURL.exists() && !outputURL.mkdirs()) {
            LOG.error("Could not create workspaces directory");
        }
        return outputURL;
    }

    public static <M extends LibraryItem> List<M> getDefaultsForType(Class<M> clazz) {
        Library library = new Library(LibraryMarshaller.loadAndParseSettingsFile(Model.getDefaultLibraryFile(), Model.getPrehistoricSettingsFile()));
        library.ensureConsistentLibrary();
        if (clazz == SystemListItem.class) {
            ArrayList<SystemListItem> items = new ArrayList<SystemListItem>();
            for (SystemPluginConfiguration configuration : library.getSystems()) {
                SystemPlugin instance = JarFiles.instance(configuration);
                items.add(new SystemListItem(instance));
            }
            return items;
        }
        if (clazz == EmissionMask.class) {
            return library.getSpectrumEmissionMasks();
        }
        if (clazz == IntermodulationRejectionMask.class) {
            return library.getLibraryFunction(IntermodulationRejectionMask.class);
        }
        if (clazz == BlockingMask.class) {
            return library.getLibraryFunction(BlockingMask.class);
        }
        if (clazz == BitRateMapping.class) {
            return library.getLibraryFunction(BitRateMapping.class);
        }
        if (clazz == ReceiverModel.class) {
            return library.getReceivers();
        }
        if (clazz == TransmitterModel.class) {
            return library.getTransmitters();
        }
        if (clazz == CDMALLD.class) {
            return library.getCDMALinkLevelData();
        }
        if (clazz == AntennaGain.class) {
            return library.getPluginConfigurations(AntennaGainConfiguration.class);
        }
        if (clazz == CoverageRadius.class) {
            return library.getPluginConfigurations(CoverageRadiusConfiguration.class);
        }
        if (clazz == EventProcessing.class) {
            return library.getPluginConfigurations(EventProcessingConfiguration.class);
        }
        if (clazz == PropagationModel.class) {
            return library.getPluginConfigurations(PropagationModelConfiguration.class);
        }
        throw new RuntimeException("No default types for class: " + clazz);
    }

    static {
        LOG = Logger.getLogger(Model.class);
        STRINGLIST = ResourceBundle.getBundle("stringlist", Locale.ENGLISH);
        simulationPool = new SimulationPool();
        SHOW_WELCOME = true;
        ILLEGAL_FILENAME_CHARS = new char[]{'\\', '/', ':', '*', '<', '>', '|'};
        MODEL = new Model();
        initialized = false;
    }
}

