/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Plugin;
import org.seamcat.model.plugin.PluginFactory;
import org.seamcat.model.plugin.antenna.AntennaGainPlugin;
import org.seamcat.model.plugin.coverageradius.CoverageRadiusPlugin;
import org.seamcat.model.plugin.eventprocessing.EventProcessingPlugin;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.types.Configuration;
import org.seamcat.plugin.ConfigurationImpl;

class PluginFactoryImpl
implements PluginFactory {
    PluginFactoryImpl() {
    }

    @Override
    public <Model> Configuration<Plugin<Model>, Model> create(Class<? extends Plugin<Model>> clazz, Model model) {
        ConfigurationImpl<Plugin<Model>, Model> configuration = new ConfigurationImpl<Plugin<Model>, Model>(clazz, model);
        if (AntennaGainPlugin.class.isAssignableFrom(configuration.getPluginClass())) {
            return Factory.antennaGainFactory().getByConfiguration(configuration);
        }
        if (CoverageRadiusPlugin.class.isAssignableFrom(configuration.getPluginClass())) {
            return Factory.coverageRadii().getByConfiguration(configuration);
        }
        if (EventProcessingPlugin.class.isAssignableFrom(configuration.getPluginClass())) {
            return Factory.eventProcessors().getByConfiguration(configuration);
        }
        if (PropagationModelPlugin.class.isAssignableFrom(configuration.getPluginClass())) {
            return Factory.propagationModelFactory().getByConfiguration(configuration);
        }
        throw new RuntimeException("unknown configuration");
    }
}

