/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.UUID;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Cache;
import org.seamcat.model.factory.DefaultValueCache;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.SeamcatInvocationHandler;
import org.seamcat.model.functions.BitRateMapping;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.EmissionMask;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.plugin.CalculatedValue;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.Horizontal;
import org.seamcat.model.plugin.OptionalValue;
import org.seamcat.model.plugin.Spherical;
import org.seamcat.model.plugin.UIPosition;
import org.seamcat.model.plugin.UITab;
import org.seamcat.model.plugin.Vertical;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.SystemModel;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.CDMALLD;
import org.seamcat.model.types.Configuration;
import org.seamcat.model.types.CoverageRadius;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.LibraryItem;
import org.seamcat.model.types.PropagationModel;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.model.types.result.VectorResultType;
import org.seamcat.persistence.impl.GenericTypeMarshaller;
import org.seamcat.plugin.JarConfigurationModel;
import org.seamcat.plugin.PluginClass;

public class ProxyHelper {
    private static final ThreadLocal<Boolean> changeIds = new ThreadLocal<Boolean>(){

        @Override
        protected Boolean initialValue() {
            return true;
        }
    };

    public static <T> T newInstance(Class<T> clazz) {
        return ProxyHelper.newInstance(clazz, ProxyHelper.defaultValues(clazz));
    }

    public static <T> T newInstance(Class<T> clazz, Map<Method, Object> values) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new SeamcatInvocationHandler<T>(clazz, values));
    }

    public static <T> T newInstanceMutableMapLists(Class<T> clazz, Map<Method, Object> values) {
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, new SeamcatInvocationHandler<T>(clazz, values, false));
    }

    public static SeamcatInvocationHandler getHandler(Object object) {
        InvocationHandler handler;
        if (object instanceof Proxy && (handler = Proxy.getInvocationHandler(object)) instanceof SeamcatInvocationHandler) {
            return (SeamcatInvocationHandler)handler;
        }
        throw new RuntimeException("Not an instance of a seamcat proxy");
    }

    public static void initialize(JarConfigurationModel model) {
        for (PluginClass aClass : model.getPluginClasses()) {
            ProxyHelper.defaultValues(aClass.getModelClass(), new HashMap<String, Object>());
        }
        for (PluginClass aClass : model.getPluginClasses()) {
            ProxyHelper.defaultValues(aClass.getModelClass(), DefaultValueCache.staticDefaultValues(aClass.getModelClass()));
        }
    }

    public static LinkedHashMap<Method, Object> defaultValues(Class modelClass) {
        if (DefaultValueCache.hasDefaultValues(modelClass)) {
            return DefaultValueCache.defaultValues(modelClass);
        }
        return ProxyHelper.defaultValues(modelClass, DefaultValueCache.staticDefaultValues(modelClass));
    }

    private static LinkedHashMap<Method, Object> defaultValues(Class modelClass, Map<String, Object> defaultValues) {
        LinkedHashMap<Method, Object> instance = new LinkedHashMap<Method, Object>();
        HashMap<Method, Object> unorderedValues = new HashMap<Method, Object>();
        TreeMap<Integer, Method> map = new TreeMap<Integer, Method>();
        for (Method method : modelClass.getDeclaredMethods()) {
            Type tType;
            Type genericReturnType;
            Class<?> type = method.getReturnType();
            Config con = method.getAnnotation(Config.class);
            if (con == null) continue;
            map.put(con.order(), method);
            OptionalValue<Object> defaultValue = ProxyHelper.getSingleValueDefault(type, method);
            if (defaultValue == null && OptionalValue.class.isAssignableFrom(type) && (genericReturnType = method.getGenericReturnType()) instanceof ParameterizedType && (tType = ((ParameterizedType)genericReturnType).getActualTypeArguments()[0]) instanceof Class) {
                Object tValue = ProxyHelper.getSingleValueDefault((Class)tType, method);
                defaultValue = Factory.results().optional(false, tValue);
            }
            if (defaultValue == null) {
                throw new RuntimeException("No default value for type: " + type);
            }
            if (defaultValues.containsKey(method.getName())) {
                unorderedValues.put(method, defaultValues.get(method.getName()));
                continue;
            }
            unorderedValues.put(method, defaultValue);
        }
        for (Method method : map.values()) {
            instance.put(method, unorderedValues.get(method));
        }
        DefaultValueCache.defaultValues(modelClass, instance);
        return instance;
    }

    private static Object getSingleValueDefault(Class<?> type, Method method) {
        if (type.isPrimitive()) {
            if (Boolean.TYPE.isAssignableFrom(type)) {
                return false;
            }
            if (Double.TYPE.isAssignableFrom(type)) {
                return 0.0;
            }
            if (Integer.TYPE.isAssignableFrom(type)) {
                return 0;
            }
        } else {
            if (Map.class.isAssignableFrom(type)) {
                return new LinkedHashMap();
            }
            if (Boolean.class.isAssignableFrom(type)) {
                return false;
            }
            if (Distribution.class.isAssignableFrom(type)) {
                return Factory.distributionFactory().getConstantDistribution(0.0);
            }
            if (String.class.isAssignableFrom(type)) {
                return "";
            }
            if (EmissionMask.class.isAssignableFrom(type)) {
                return ProxyHelper.defaultEmissionMask();
            }
            if (BlockingMask.class.isAssignableFrom(type)) {
                return Factory.functionFactory().blockingMask(0.0);
            }
            if (Function.class.isAssignableFrom(type)) {
                return ProxyHelper.handleFunction(Factory.functionFactory().constantFunction(0.0), method);
            }
            if (Double.class.isAssignableFrom(type)) {
                return 0.0;
            }
            if (Integer.class.isAssignableFrom(type)) {
                return 0;
            }
            if (PropagationModel.class.isAssignableFrom(type)) {
                return Factory.propagationModelFactory().getHataSE21();
            }
            if (AntennaGain.class.isAssignableFrom(type)) {
                return Factory.antennaGainFactory().getPeakGainAntenna();
            }
            if (List.class.isAssignableFrom(type)) {
                return new ArrayList();
            }
            if (CDMALLD.class.isAssignableFrom(type)) {
                return ProxyHelper.newInstance(CDMALLD.class);
            }
            if (CalculatedValue.class.isAssignableFrom(type)) {
                return new CalculatedValue(null);
            }
            if (Enum.class.isAssignableFrom(type)) {
                ?[] enumConstants = type.getEnumConstants();
                return enumConstants[0];
            }
            if (CorrelationMode.class.isAssignableFrom(type)) {
                return Factory.correlationModes().getNone();
            }
            if (SystemModel.class.isAssignableFrom(type)) {
                return Factory.instance(SystemModel.class);
            }
            if (VectorResultType.class.isAssignableFrom(type)) {
                return new VectorResultType(Factory.results().value("Vector", "dBm"), new double[]{0.0});
            }
            if (BitRateMapping.class.isAssignableFrom(type)) {
                return Factory.functionFactory().bitRateMapping(Factory.functionFactory().constantFunction(0.0), new DescriptionImpl("Bitrate Mapping", ""));
            }
        }
        return null;
    }

    private static EmissionMask defaultEmissionMask() {
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        points.add(Point2D.ORIGIN);
        ArrayList<Double> mask = new ArrayList<Double>();
        mask.add(0.0);
        return Factory.functionFactory().emissionMask(points, mask);
    }

    private static Function handleFunction(Function function, Method method) {
        function = ProxyHelper.ensureDefault(function, method, Horizontal.class, 0, 360);
        function = ProxyHelper.ensureDefault(function, method, Vertical.class, -90, 90);
        return ProxyHelper.ensureDefault(function, method, Spherical.class, 0, 180);
    }

    private static Function ensureDefault(Function function, Method method, Class<? extends Annotation> ann, int min, int max) {
        Annotation annotation = method.getAnnotation(ann);
        if (annotation != null) {
            return Factory.functionFactory().discreteFunction(Arrays.asList(new Point2D(min, 0.0), new Point2D(max, 0.0)));
        }
        return function;
    }

    public static <T> T copy(Class<T> clazz, T model) {
        return ProxyHelper.copyInternal(clazz, model, new LinkedHashMap<Method, Object>());
    }

    private static <T> T copyInternal(Class<T> clazz, T model, Map<Method, Object> values) {
        for (Method m : clazz.getDeclaredMethods()) {
            try {
                Object value = m.invoke(model, new Object[0]);
                if (value instanceof Configuration) {
                    values.put(m, ((Configuration)value).copy());
                    continue;
                }
                if (value instanceof Map) {
                    Map map = (Map)value;
                    LinkedHashMap result = new LinkedHashMap(map);
                    for (Map.Entry entry : map.entrySet()) {
                        if (!(entry.getValue() instanceof Proxy)) continue;
                        SeamcatInvocationHandler handler = ProxyHelper.getHandler(entry.getValue());
                        result.put(entry.getKey(), handler.copy());
                    }
                    values.put(m, result);
                    continue;
                }
                if (value instanceof List) {
                    List l = (List)value;
                    ArrayList<Object> copyList = new ArrayList<Object>();
                    for (Map.Entry o : l) {
                        if (o instanceof SystemPlugin) {
                            copyList.add(ProxyHelper.cloneSystemPlugin((SystemPlugin)((Object)o)));
                            continue;
                        }
                        copyList.add(o);
                    }
                    values.put(m, copyList);
                    continue;
                }
                values.put(m, value);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ProxyHelper.newInstance(clazz, values);
    }

    public static <T extends LibraryItem> T newComposite(Class<T> compositeClass, String name) {
        Map<String, Object> defaults = DefaultValueCache.staticDefaultValues(compositeClass);
        LinkedHashMap<Method, Object> values = new LinkedHashMap<Method, Object>();
        for (Method method : compositeClass.getDeclaredMethods()) {
            if (Description.class.isAssignableFrom(method.getReturnType())) {
                Description prototype = Factory.prototype(Description.class);
                Factory.when(prototype.name()).thenReturn(name);
                values.put(method, Factory.build(prototype));
                continue;
            }
            if (defaults.containsKey(method.getName())) {
                values.put(method, defaults.get(method.getName()));
                continue;
            }
            if (method.getAnnotation(UITab.class) != null) {
                values.put(method, ProxyHelper.newComposite(method.getReturnType()));
                continue;
            }
            if (method.getAnnotation(UIPosition.class) == null) continue;
            Class<?> type = method.getReturnType();
            if (AntennaGain.class.isAssignableFrom(type)) {
                values.put(method, Factory.antennaGainFactory().getPeakGainAntenna());
                continue;
            }
            if (PropagationModel.class.isAssignableFrom(type)) {
                values.put(method, Factory.propagationModelFactory().getHataSE21());
                continue;
            }
            if (CoverageRadius.class.isAssignableFrom(type)) {
                values.put(method, Factory.coverageRadii().getUserDefined());
                continue;
            }
            values.put(method, ProxyHelper.newInstance(method.getReturnType()));
        }
        return (T)((LibraryItem)ProxyHelper.newInstance(compositeClass, values));
    }

    public static <T> T newComposite(Class<T> compositeClass) {
        Map<String, Object> defaults = DefaultValueCache.staticDefaultValues(compositeClass);
        Method[] methods = SystemModel.class.isAssignableFrom(compositeClass) ? compositeClass.getMethods() : compositeClass.getDeclaredMethods();
        LinkedHashMap<Method, Object> values = new LinkedHashMap<Method, Object>();
        for (Method method : methods) {
            if (defaults.containsKey(method.getName())) {
                values.put(method, defaults.get(method.getName()));
                continue;
            }
            if (method.getAnnotation(UITab.class) != null) {
                values.put(method, ProxyHelper.newComposite(method.getReturnType()));
                continue;
            }
            if (method.getAnnotation(UIPosition.class) != null) {
                Class<?> type = method.getReturnType();
                if (AntennaGain.class.isAssignableFrom(type)) {
                    values.put(method, Factory.antennaGainFactory().getPeakGainAntenna());
                    continue;
                }
                if (PropagationModel.class.isAssignableFrom(type)) {
                    values.put(method, Factory.propagationModelFactory().getHataSE21());
                    continue;
                }
                if (CoverageRadius.class.isAssignableFrom(type)) {
                    values.put(method, Factory.coverageRadii().getUserDefined());
                    continue;
                }
                values.put(method, ProxyHelper.newInstance(method.getReturnType()));
                continue;
            }
            if (!method.getName().equals("id") || method.getReturnType() != String.class) continue;
            values.put(method, UUID.randomUUID().toString());
        }
        return ProxyHelper.newInstance(compositeClass, values);
    }

    public static <T> T deepCloneComposite(Class<T> compositeClass, T composite) {
        return ProxyHelper.deepCloneComposite(compositeClass, composite, null);
    }

    public static <T> T deepCloneComposite(Class<T> compositeClass, T composite, Description newDescription) {
        LinkedHashMap<Method, Object> values = new LinkedHashMap<Method, Object>();
        for (Method method : Cache.ordered(compositeClass)) {
            if (newDescription != null && method.getReturnType() == Description.class) {
                values.put(method, newDescription);
                continue;
            }
            Object invoke = null;
            try {
                invoke = method.invoke(composite, new Object[0]);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (method.getAnnotation(UITab.class) != null) {
                values.put(method, ProxyHelper.deepCloneComposite(method.getReturnType(), invoke));
                continue;
            }
            if (method.getAnnotation(UIPosition.class) == null) continue;
            if (invoke instanceof Configuration) {
                values.put(method, ((Configuration)invoke).copy());
                continue;
            }
            values.put(method, ProxyHelper.copy(method.getReturnType(), invoke));
        }
        return ProxyHelper.newInstance(compositeClass, values);
    }

    public static SystemPlugin cloneSystemPluginKeepIds(SystemPlugin plugin) {
        changeIds.set(false);
        SystemPlugin cloned = ProxyHelper.cloneSystemPlugin(plugin);
        changeIds.set(true);
        return cloned;
    }

    public static SystemPlugin cloneSystemPlugin(SystemPlugin plugin) {
        return ProxyHelper.cloneSystemPlugin(plugin, plugin.getUI().description());
    }

    public static SystemPlugin cloneSystemPlugin(SystemPlugin plugin, Description description) {
        try {
            SystemPlugin copy = (SystemPlugin)plugin.getClass().newInstance();
            Class<? extends SystemModel> uiClass = GenericTypeMarshaller.getPluginUIClass(plugin);
            SystemModel systemModel = ProxyHelper.deepCloneComposite(uiClass, plugin.getUI(), description);
            String id = changeIds.get() != false ? UUID.randomUUID().toString() : plugin.getUI().id();
            ProxyHelper.getHandler(systemModel).setId(id);
            copy.setUI(systemModel);
            return copy;
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating plugin", e);
        }
    }
}

