/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.factory;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.factory.ProxyHelper;
import org.seamcat.model.plugin.system.SystemModel;

public class SeamcatInvocationHandler<T>
implements InvocationHandler {
    private Class<T> clazz;
    private Map<Method, Object> values;

    SeamcatInvocationHandler(Class<T> clazz, Map<Method, Object> values) {
        this(clazz, values, true);
    }

    SeamcatInvocationHandler(Class<T> clazz, Map<Method, Object> values, boolean immutableMapLists) {
        this.clazz = clazz;
        this.values = values;
        if (immutableMapLists) {
            for (Map.Entry<Method, Object> entry : values.entrySet()) {
                Object value;
                if (Map.class.isAssignableFrom(entry.getKey().getReturnType())) {
                    value = (Map)entry.getValue();
                    LinkedHashMap newMap = new LinkedHashMap();
                    for (Map.Entry ent : value.entrySet()) {
                        newMap.put(ent.getKey(), ent.getValue());
                    }
                    entry.setValue(newMap);
                    continue;
                }
                if (!List.class.isAssignableFrom(entry.getKey().getReturnType())) continue;
                value = (List)entry.getValue();
                ArrayList newList = new ArrayList();
                if (value != null) {
                    Iterator iterator = value.iterator();
                    while (iterator.hasNext()) {
                        Map.Entry o = iterator.next();
                        newList.add(o);
                    }
                }
                entry.setValue(newList);
            }
        }
    }

    public void setId(String id) {
        try {
            Method idMethod = SystemModel.class.getDeclaredMethod("id", new Class[0]);
            this.values.put(idMethod, id);
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Object invoke(Object o, Method method, Object[] objects) throws Throwable {
        if (method.getName().equals("toString") && method.getReturnType() == String.class) {
            StringBuilder sb = new StringBuilder();
            boolean first = true;
            if (this.values == null) {
                return "";
            }
            for (Map.Entry<Method, Object> entry : this.values.entrySet()) {
                if (first) {
                    first = false;
                } else {
                    sb.append("; ");
                }
                sb.append(entry.getKey().getName()).append("=").append(entry.getValue());
            }
            return sb.toString();
        }
        return this.values.get(method);
    }

    public Map<Method, Object> getValues() {
        return new LinkedHashMap<Method, Object>(this.values);
    }

    public T copy() {
        return ProxyHelper.newInstance(this.clazz, this.getValues());
    }
}

