/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.functions;

public class Bounds {
    public static final Bounds ZERO = new Bounds(0.0, 0.0, true);
    private boolean bounded;
    private double max;
    private double min;

    public Bounds(double constant) {
        this.min = constant;
        this.max = constant;
        this.bounded = true;
    }

    public Bounds(double min, double max, boolean bounded) {
        this.max = max;
        this.min = min;
        this.bounded = bounded;
    }

    public double getMax() {
        return this.max;
    }

    public double getMin() {
        return this.min;
    }

    public boolean isBounded() {
        return this.bounded;
    }

    public boolean contains(double value) {
        if (this.bounded) {
            return value >= this.min && value <= this.max;
        }
        return true;
    }

    public Bounds add(Bounds bounds) {
        return new Bounds(this.min + bounds.getMin(), this.max + bounds.getMax(), true);
    }

    public String toString() {
        return "[" + this.min + "; " + this.max + "]";
    }
}

