/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.generic;

import java.util.List;
import org.seamcat.eventbus.EventBusFactory;
import org.seamcat.events.CorrelatedDistanceSettingChangedEvent;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.presentation.genericgui.item.AbstractItem;
import org.seamcat.presentation.genericgui.item.BooleanItem;
import org.seamcat.presentation.genericgui.panelbuilder.ChangeListener;
import org.seamcat.simulation.generic.RelativeLocation;

public interface RelativeLocationUI {
    public static final Distribution pathAzimuth = Factory.distributionFactory().getUniformDistribution(0.0, 360.0);
    public static final Distribution pathDistanceFactor = Factory.distributionFactory().getUniformPolarDistanceDistribution(1.0);
    public static final RelativeLocation.Shape shape = RelativeLocation.Shape.Hexagon;
    public static final ChangeListener<RelativeLocationUI> change = new ChangeListener<RelativeLocationUI>(){

        @Override
        public void handle(RelativeLocationUI model, List<AbstractItem> items, AbstractItem changedItem) {
            if (changedItem instanceof BooleanItem && changedItem.getLabel().equals("Correlated distance (origin = Transmitter)")) {
                EventBusFactory.getEventBus().publish(new CorrelatedDistanceSettingChangedEvent());
            }
        }
    };

    @Config(order=1, name="Correlated distance (origin = Transmitter)", defineGroup="corr")
    public boolean useCorrelatedDistance();

    @Config(order=2, name="Delta X", unit="km", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "UNIFORM_POLAR_DISTANCE", "STAIR", "DISCRETE_UNIFORM", "GAUSSIAN", "GAUSSIAN_LIMITED", "RAYLEIGH", "RAYLEIGH_LIMITED"})
    public Distribution deltaX();

    @Config(order=3, name="Delta Y", unit="km", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "UNIFORM_POLAR_DISTANCE", "STAIR", "DISCRETE_UNIFORM", "GAUSSIAN", "GAUSSIAN_LIMITED", "RAYLEIGH", "RAYLEIGH_LIMITED"})
    public Distribution deltaY();

    @Config(order=4, name="Path azimuth", unit="deg", invertedGroup="corr", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "UNIFORM_POLAR_ANGLE", "STAIR", "DISCRETE_UNIFORM", "GAUSSIAN_LIMITED", "GAUSSIAN", "RAYLEIGH", "RAYLEIGH_LIMITED"})
    public Distribution pathAzimuth();

    @Config(order=5, name="Path distance factor", invertedGroup="corr", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "UNIFORM_POLAR_DISTANCE", "STAIR", "DISCRETE_UNIFORM", "LOG_NORMAL_LIMITED", "RAYLEIGH", "RAYLEIGH_LIMITED", "GAUSSIAN", "GAUSSIAN_LIMITED"})
    public Distribution pathDistanceFactor();

    @Config(order=6, name="Use a polygon", defineGroup="poly", invertedGroup="corr")
    public boolean usePolygon();

    @Config(order=7, name="Shape of the polygon", group="poly")
    public RelativeLocation.Shape shape();

    @Config(order=8, name="Turn ccw", unit="deg", group="poly", distributions={"CONSTANT", "USER_DEFINED", "UNIFORM", "UNIFORM_POLAR_ANGLE", "STAIR", "DISCRETE_UNIFORM"})
    public Distribution turnCCW();
}

