/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.geometry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemSpaces;

public class PolygonUtil {
    static PointCompare LEFT = new PointCompare(){

        @Override
        public boolean cmp(Point2D point, Point2D other) {
            return point.getX() > other.getX();
        }
    };
    static PointCompare RIGHT = new PointCompare(){

        @Override
        public boolean cmp(Point2D point, Point2D other) {
            return point.getX() < other.getX();
        }
    };
    static PointCompare LOWER = new PointCompare(){

        @Override
        public boolean cmp(Point2D point, Point2D other) {
            return point.getY() > other.getY();
        }

        @Override
        double split(Point2D point) {
            return point.getY();
        }
    };
    static PointCompare UPPER = new PointCompare(){

        @Override
        public boolean cmp(Point2D point, Point2D other) {
            return point.getY() < other.getY();
        }

        @Override
        double split(Point2D point) {
            return point.getY();
        }
    };

    public static Polygon2D convertCircle(double radius, double turnAngle, int edgeCount, Bounds angles) {
        if (edgeCount < 3) {
            edgeCount = 3;
        }
        double minAngle = angles.getMin();
        double maxAngle = angles.getMax();
        double sector = 360 / edgeCount;
        ArrayList<Point2D> edges = new ArrayList<Point2D>();
        edges.add(PolygonUtil.convert(maxAngle + turnAngle, radius));
        for (int i = 0; i < edgeCount; ++i) {
            double angle = 360.0 - sector * (double)i;
            if (!(angle <= maxAngle) || !(minAngle <= angle) || Mathematics.equals(angle, maxAngle, 1.0E-4) || Mathematics.equals(angle, minAngle, 1.0E-4)) continue;
            edges.add(PolygonUtil.convert(angle + turnAngle, radius));
        }
        edges.add(PolygonUtil.convert(minAngle + turnAngle, radius));
        if (Math.abs(maxAngle - minAngle) < 180.0) {
            edges.add(Point2D.ORIGIN);
        }
        return new Polygon2D(edges);
    }

    private static Point2D convert(double angle, double radius) {
        return new Point2D(Mathematics.cosD(angle), Mathematics.sinD(angle)).scale(radius);
    }

    public static Polygon2D add(Bounds rectangleX, Bounds rectangleY, Polygon2D polygon) {
        Map<Orientation, List<Point2D>> map = PolygonUtil.map(polygon);
        ArrayList<Point2D> result = new ArrayList<Point2D>();
        PolygonUtil.addAndTranspose(new Point2D(rectangleX.getMax(), rectangleY.getMax()), map.get((Object)Orientation.UPPER_RIGHT), result);
        PolygonUtil.addAndTranspose(new Point2D(rectangleX.getMax(), rectangleY.getMin()), map.get((Object)Orientation.RIGHT_LOWER), result);
        PolygonUtil.addAndTranspose(new Point2D(rectangleX.getMin(), rectangleY.getMin()), map.get((Object)Orientation.LOWER_LEFT), result);
        PolygonUtil.addAndTranspose(new Point2D(rectangleX.getMin(), rectangleY.getMax()), map.get((Object)Orientation.LEFT_UPPER), result);
        return new Polygon2D(result);
    }

    private static void addAndTranspose(Point2D vector, List<Point2D> shape, List<Point2D> result) {
        for (Point2D point2D : shape) {
            result.add(point2D.add(vector));
        }
    }

    protected static Point2D find(Polygon2D polygon, PointCompare primary, PointCompare secondary) {
        ArrayList<Point2D> candidates = new ArrayList<Point2D>();
        candidates.add(polygon.getVertices().get(0));
        for (Point2D point : polygon.getVertices()) {
            if (primary.cmp((Point2D)candidates.get(0), point)) {
                candidates.clear();
                candidates.add(point);
                continue;
            }
            if (primary.split(point) != primary.split((Point2D)candidates.get(0))) continue;
            candidates.add(point);
        }
        if (candidates.size() == 1) {
            return (Point2D)candidates.get(0);
        }
        Point2D result = (Point2D)candidates.get(0);
        for (Point2D candidate : candidates) {
            if (!secondary.cmp(result, candidate)) continue;
            result = candidate;
        }
        return result;
    }

    protected static Map<Orientation, List<Point2D>> map(Polygon2D polygon) {
        HashMap<Orientation, List<Point2D>> map = new HashMap<Orientation, List<Point2D>>();
        map.put(Orientation.UPPER_RIGHT, PolygonUtil.quadrant(polygon, UPPER, RIGHT));
        map.put(Orientation.RIGHT_LOWER, PolygonUtil.quadrant(polygon, RIGHT, LOWER));
        map.put(Orientation.LOWER_LEFT, PolygonUtil.quadrant(polygon, LOWER, LEFT));
        map.put(Orientation.LEFT_UPPER, PolygonUtil.quadrant(polygon, LEFT, UPPER));
        return map;
    }

    private static List<Point2D> quadrant(Polygon2D polygon, PointCompare primary, PointCompare secondary) {
        ArrayList<Point2D> list = new ArrayList<Point2D>();
        Point2D current = PolygonUtil.find(polygon, primary, secondary);
        list.add(current);
        List<Point2D> vertices = polygon.getVertices();
        int i = vertices.indexOf(current);
        boolean foundEnd = false;
        while (!foundEnd) {
            i = (i + 1) % vertices.size();
            Point2D candidate = vertices.get(i);
            if (secondary.cmp(list.get(list.size() - 1), candidate)) {
                list.add(candidate);
                continue;
            }
            foundEnd = true;
        }
        return list;
    }

    public static List<Point2D> allPoints(SystemSpaces shapes) {
        ArrayList<Point2D> all = new ArrayList<Point2D>();
        if (shapes == null) {
            return all;
        }
        for (Space space : shapes.getRxSpaces()) {
            all.addAll(space.getSpace().getVertices());
        }
        for (Space space : shapes.getTxSpaces()) {
            all.addAll(space.getSpace().getVertices());
        }
        return all;
    }

    public static Point2D getRandomPointInside(Polygon2D polygon) {
        if (polygon.getVertices().size() == 1) {
            return polygon.getVertices().get(0);
        }
        if (polygon.getVertices().size() > 2) {
            Point2D candidate;
            double minX = 0.0;
            double maxX = 0.0;
            double minY = 0.0;
            double maxY = 0.0;
            for (Point2D point : polygon.getVertices()) {
                minX = Math.min(minX, point.getX());
                maxX = Math.max(maxX, point.getX());
                minY = Math.min(minY, point.getY());
                maxY = Math.max(maxY, point.getY());
            }
            UniformDistribution x = Factory.distributionFactory().getUniformDistribution(minX, maxX);
            UniformDistribution y = Factory.distributionFactory().getUniformDistribution(minY, maxY);
            while (!polygon.contains(candidate = new Point2D(x.trial(), y.trial()))) {
            }
            return candidate;
        }
        throw new IllegalArgumentException("Polygon must either be a point or have at least 3 vertices");
    }

    static abstract class PointCompare {
        PointCompare() {
        }

        abstract boolean cmp(Point2D var1, Point2D var2);

        double split(Point2D point) {
            return point.getX();
        }
    }

    static enum Orientation {
        UPPER_RIGHT,
        RIGHT_LOWER,
        LOWER_LEFT,
        LEFT_UPPER;

    }
}

