/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.geometry;

import org.seamcat.model.geometry.Point2D;

public class Vector2D {
    private final double x;
    private final double y;

    public Vector2D(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public static Vector2D fromTo(Point2D a, Point2D b) {
        return new Vector2D(b.getX() - a.getX(), b.getY() - a.getY());
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public Vector2D toUnitVector() {
        double length = this.length();
        return new Vector2D(this.x / length, this.y / length);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vector2D scale(double scale) {
        return new Vector2D(this.x * scale, this.y * scale);
    }

    public double dotProduct(Vector2D other) {
        return this.x * other.x + this.y * other.y;
    }

    public Vector2D add(Vector2D other) {
        return new Vector2D(this.x + other.x, this.y + other.y);
    }

    public Vector2D cwNormal() {
        return new Vector2D(this.y, -this.x);
    }

    public String toString() {
        return "Vector2D [x=" + this.x + ", y=" + this.y + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        long temp = Double.doubleToLongBits(this.x);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.y);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Vector2D other = (Vector2D)obj;
        if (Double.doubleToLongBits(this.x) != Double.doubleToLongBits(other.x)) {
            return false;
        }
        return Double.doubleToLongBits(this.y) == Double.doubleToLongBits(other.y);
    }
}

