/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.mathematics;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.types.result.VectorResultType;

public class Mathematics {
    public static final int KM_TO_METERS = 1000;
    public static final double BPS_TO_KBPS = 1000.0;
    public static final double MHZ_TO_HZ = 1000000.0;
    public static final double DEGRAD = Math.PI / 180;
    public static final double RADEG = 57.29577951308232;
    public static final double DEFAULT_DELOG = -1000.0;
    public static final double DEFAULT_LOG_START_RANGE = 1.0E-4;
    public static final double SQRT3 = Math.sqrt(3.0);
    public static final int PID = 180;

    public static double distance(Point2D from, Point2D to) {
        return Math.sqrt((from.getX() - to.getX()) * (from.getX() - to.getX()) + (from.getY() - to.getY()) * (from.getY() - to.getY()));
    }

    public static double distance(Point2D to) {
        return Math.sqrt(to.getX() * to.getX() + to.getY() * to.getY());
    }

    public static double dB2Linear(double value) {
        return Math.pow(10.0, value / 10.0);
    }

    public static double linear2dB(double value) {
        if (value == 0.0) {
            return -1000.0;
        }
        return 10.0 * Math.log10(value);
    }

    public static double fromdBm2Watt(double dbm) {
        return Math.pow(10.0, (dbm - 30.0) / 10.0);
    }

    public static double fromWatt2dBm(double watt) {
        if (watt == 0.0) {
            return -1000.0;
        }
        return 10.0 * Math.log10(watt) + 30.0;
    }

    public static double getMinimumLogDomainValue(double minimumDistribution, double minRange) {
        double returnValue = minRange == 0.0 ? (minimumDistribution > 1.0E-4 ? 1.0E-4 : minimumDistribution) : minRange;
        return returnValue;
    }

    public static double powerSummation(double ... powers) {
        double total = 0.0;
        for (double power : powers) {
            if (power == 0.0) continue;
            total += Math.pow(10.0, (power - 30.0) / 10.0);
        }
        if (total == 0.0) {
            return -1000.0;
        }
        return 10.0 * Math.log10(total) + 30.0;
    }

    public static double powerSubtract(double value, double sub) {
        return 10.0 * Math.log10(Math.pow(10.0, (value - 30.0) / 10.0) - Math.pow(10.0, (sub - 30.0) / 10.0)) + 30.0;
    }

    public static double round(double d) {
        if (d == 0.0) {
            return 0.0;
        }
        return Math.rint(d * 1000.0) / 1000.0;
    }

    public static double acosD(double angle) {
        return Math.acos(angle) * 57.29577951308232;
    }

    public static double asinD(double x) {
        return Math.asin(x) * 57.29577951308232;
    }

    public static double atan2D(double x, double y) {
        return Math.atan2(y, x) * 57.29577951308232;
    }

    public static double angle(double x1, double y1, double x2, double y2) {
        return Mathematics.atan2D(x2 - x1, y2 - y1);
    }

    public static double atanD(double angle) {
        return 57.29577951308232 * Math.atan(angle);
    }

    public static double cosD(double angle) {
        return Math.cos(angle * (Math.PI / 180));
    }

    public static double cosh(double x) {
        return (Math.exp(x) + Math.exp(-x)) / 2.0;
    }

    public static double getAverage(double[] p) {
        return Mathematics.getAverage(p, p.length, false);
    }

    public static double getAverage(double[] p, int length, boolean ignoreZeros) {
        double sum = 0.0;
        int len = 0;
        for (int i = 0; i < length && i < p.length; ++i) {
            double n = p[i];
            if (ignoreZeros && n == 0.0) continue;
            sum += n;
            ++len;
        }
        return len > 0 ? sum / (double)len : 0.0;
    }

    public static double getMedian(double[] p, int length, boolean ignoreZeros) {
        double median;
        if (ignoreZeros) {
            p = Mathematics.stripZeros(p);
        }
        if (length < 0) {
            return 0.0;
        }
        if ((length = Math.min(length, p.length)) == 0) {
            median = 0.0;
        } else if (length == 1) {
            median = p[0];
        } else {
            double[] sorted = new double[length];
            System.arraycopy(p, 0, sorted, 0, sorted.length);
            Arrays.sort(sorted);
            if (length % 2 == 0) {
                int index = length / 2;
                median = Mathematics.fromWatt2dBm((Mathematics.fromdBm2Watt(sorted[index]) + Mathematics.fromdBm2Watt(sorted[index - 1])) / 2.0);
            } else {
                median = sorted[length / 2];
            }
        }
        return median;
    }

    public static double[] stripZeros(double[] array) {
        double[] strippedArray;
        double[] target = new double[array.length];
        int len = 0;
        for (int x = 0; x < target.length; ++x) {
            double n = array[x];
            if (n == 0.0) continue;
            target[len++] = n;
        }
        if (len == target.length) {
            strippedArray = target;
        } else {
            strippedArray = new double[len];
            System.arraycopy(target, 0, strippedArray, 0, strippedArray.length);
        }
        return strippedArray;
    }

    public static double getAverage(double[] p, double minValue, double maxValue) {
        return Mathematics.getAverage(p, p.length, minValue, maxValue, false);
    }

    public static double getAverage(double[] p, int length, double minValue, double maxValue, boolean ignoreZeros) {
        double sum = 0.0;
        int count = 0;
        for (int i = 0; i < length && i < p.length; ++i) {
            double a = p[i];
            if (!(a > minValue) || !(a < maxValue) || ignoreZeros && a == 0.0) continue;
            sum += a;
            ++count;
        }
        return count > 0 ? sum / (double)count : 0.0;
    }

    public static double getStdDev(double[] p) {
        return Mathematics.getStdDev(p, Mathematics.getAverage(p), p.length);
    }

    public static double getStdDev(double[] p, double ave) {
        return Mathematics.getStdDev(p, ave, p.length);
    }

    public static double getStdDev(double[] p, double ave, int length, double minValue, double maxValue) {
        return Mathematics.getStdDev(p, ave, length, minValue, maxValue, false);
    }

    public static double getStdDev(double[] p, double ave, int length, double minValue, double maxValue, boolean ignoreZeros) {
        double stddev;
        if (p.length == 1) {
            stddev = 0.0;
        } else {
            double sum = 0.0;
            int count = 0;
            for (int i = 0; i < length && i < p.length; ++i) {
                double a = p[i];
                if (!(a > minValue) || !(a < maxValue) || ignoreZeros && a == 0.0) continue;
                double dev = ave - a;
                sum += dev * dev;
                ++count;
            }
            stddev = count > 0 ? Math.sqrt(sum / (double)(count - 1)) : 0.0;
        }
        return stddev;
    }

    public static double getStdDev(double[] p, double ave, int length, boolean ignoreZeros) {
        double stddev;
        if (length == 1) {
            stddev = 0.0;
        } else {
            double sum = 0.0;
            int len = 0;
            for (int i = 0; i < length && i < p.length; ++i) {
                double a = p[i];
                if (ignoreZeros && a == 0.0) continue;
                double dev = ave - a;
                sum += dev * dev;
                ++len;
            }
            stddev = len > 0 ? Math.sqrt(sum / (double)(len - 1)) : 0.0;
        }
        return stddev;
    }

    public static double getStdDev(double[] p, double ave, int length) {
        return Mathematics.getStdDev(p, ave, length, false);
    }

    public static double max(double[] p) {
        double max = Double.NEGATIVE_INFINITY;
        for (double element : p) {
            if (!(element > max)) continue;
            max = element;
        }
        return max;
    }

    public static double min(double[] p) {
        double min = Double.MAX_VALUE;
        for (double element : p) {
            if (!(element < min)) continue;
            min = element;
        }
        return min;
    }

    public static double max(double[] p, double minValue, double maxValue) {
        double max = Double.NEGATIVE_INFINITY;
        for (double a : p) {
            if (!(a > max) || !(a > minValue) || !(a < maxValue)) continue;
            max = a;
        }
        return max;
    }

    public static double min(double[] p, double minValue, double maxValue) {
        double min = Double.MAX_VALUE;
        for (double a : p) {
            if (!(a < min) || !(a > minValue) || !(a < maxValue)) continue;
            min = a;
        }
        return min;
    }

    public static double sinD(double angle) {
        return Math.sin(angle * (Math.PI / 180));
    }

    public static double sinh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / 2.0;
    }

    public static double tanD(double angle) {
        return Math.tan(angle * (Math.PI / 180));
    }

    public static double tanh(double x) {
        return (Math.exp(x) - Math.exp(-x)) / (Math.exp(x) + Math.exp(-x));
    }

    public static double calculateCorrelation(double[] a, double[] b) {
        double result = 0.0;
        double sum_sq_x = 0.0;
        double sum_sq_y = 0.0;
        double sum_coproduct = 0.0;
        double mean_x = a[0];
        double mean_y = b[0];
        for (int i = 2; i < a.length + 1; ++i) {
            double sweep = Double.valueOf(i - 1) / (double)i;
            double delta_x = a[i - 1] - mean_x;
            double delta_y = b[i - 1] - mean_y;
            sum_sq_x += delta_x * delta_x * sweep;
            sum_sq_y += delta_y * delta_y * sweep;
            sum_coproduct += delta_x * delta_y * sweep;
            mean_x += delta_x / (double)i;
            mean_y += delta_y / (double)i;
        }
        double pop_sd_x = Math.sqrt(sum_sq_x / (double)a.length);
        double pop_sd_y = Math.sqrt(sum_sq_y / (double)a.length);
        double cov_x_y = sum_coproduct / (double)a.length;
        result = cov_x_y / (pop_sd_x * pop_sd_y);
        return result;
    }

    public static <T> T[] sortBest(T[] elements) {
        ArrayList<T> best = null;
        if (elements != null && elements.length > 0) {
            best = new ArrayList<T>();
            Arrays.sort(elements);
            T bestElement = elements[elements.length - 1];
            best.add(bestElement);
            for (int x = elements.length - 2; x >= 0 && ((Comparable)bestElement).compareTo(elements[x]) == 0; --x) {
                best.add(elements[x]);
            }
        }
        return best != null && best.size() > 0 ? best.toArray((Object[])Array.newInstance(best.get(0).getClass(), best.size())) : null;
    }

    public static double linearInterpolate(double wantedX, Point2D first, Point2D second) {
        double rX1 = first.getX();
        double rY1 = first.getY();
        double rX2 = second.getX();
        double rY2 = second.getY();
        if (rX2 == rX1) {
            return rY2;
        }
        double rT = (wantedX - rX1) / (rX2 - rX1);
        return rT * rY2 + (1.0 - rT) * rY1;
    }

    public static boolean equals(double a, double b, double tolerance) {
        return Math.abs(a - b) < tolerance;
    }

    public static double Qi(double x) {
        try {
            double c0 = 2.515517;
            double c1 = 0.802853;
            double c2 = 0.010328;
            double d1 = 1.432788;
            double d2 = 0.189269;
            double d3 = 0.001308;
            double t = x <= 0.5 ? Math.sqrt(-2.0 * Math.log(x)) : Math.sqrt(-2.0 * Math.log(1.0 - x));
            double xi = ((c2 * t + c1) * t + c0) / (((d3 * t + d2) * t + d1) * t + 1.0);
            double Q = x <= 0.5 ? t - xi : -(t - xi);
            return Q;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public static double calculateKartesianAngle(Point2D to, Point2D from) {
        double linearyDistance = Mathematics.distance(to, from);
        double yProjection = Math.abs(from.getY() - to.getY());
        double angle = Mathematics.asinD(yProjection / linearyDistance);
        if (Double.isNaN(angle)) {
            angle = 0.0;
        }
        if (to.getX() < from.getX() && to.getY() >= from.getY()) {
            angle = 180.0 - angle;
        } else if (to.getX() < from.getX() && to.getY() <= from.getY()) {
            angle += 180.0;
        } else if (to.getX() >= from.getX() && to.getY() < from.getY() && angle != 0.0) {
            angle = 360.0 - angle;
        }
        return angle;
    }

    public static double convertAngleToConfineToHorizontalDefinedRange(double angle) {
        if (angle < 0.0) {
            angle += (double)(360 * ((int)Math.abs(angle / 360.0) + 1));
        } else if (angle > 360.0) {
            angle -= (double)(360 * (int)(angle / 360.0));
        }
        if (angle == 360.0) {
            angle = 0.0;
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }

    public static double calculateKartesianAngle(Point2D to) {
        return Mathematics.calculateKartesianAngle(to, Point2D.ORIGIN);
    }

    public static double calculateElevation(Point2D from, double fromHeight, Point2D to, double toHeight) {
        double threshold = 1.0E-5;
        double distance = Mathematics.distance(from, to);
        if (Mathematics.equals(distance, 0.0, threshold)) {
            if (fromHeight > toHeight) {
                return -90.0;
            }
            if (fromHeight < toHeight) {
                return 90.0;
            }
            if (Mathematics.equals(fromHeight, toHeight, threshold)) {
                return 0.0;
            }
        }
        return Mathematics.atanD((toHeight - fromHeight) / (distance * 1000.0));
    }

    public static double calculateElevation(AntennaResult from, AntennaResult to) {
        return Mathematics.calculateElevation(from.getPosition(), from.getHeight(), to.getPosition(), to.getHeight());
    }

    public static double calculateAvgPercentage(VectorResultType vector1, VectorResultType vector2) {
        double[] v2;
        double[] v1 = vector1.getValue().asArray();
        if (v1.length != (v2 = vector2.getValue().asArray()).length) {
            return 0.0;
        }
        double temp = 0.0;
        int count = 0;
        for (int i = 0; i < v1.length; ++i) {
            double initialValue = v1[i];
            double interferedValue = v2[i];
            if (initialValue == 0.0) continue;
            temp += 1.0 - interferedValue / initialValue;
            ++count;
        }
        if (count > 0) {
            temp = 100.0 * (temp / (double)count);
            return Mathematics.round(temp);
        }
        return 0.0;
    }

    public static double convertAngleToConfineToVerticalDefinedRange(double angle) {
        if (angle < -90.0) {
            return -(angle += 180.0);
        }
        if (angle > 90.0) {
            return -(angle -= 180.0);
        }
        if (Double.isNaN(angle)) {
            return 0.0;
        }
        return angle;
    }
}

