/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.antenna;

import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.types.AntennaGain;

public interface BeamFormingCompositeInput {
    public static final int nh = 8;
    public static final int nv = 8;
    public static final double horizontalSpacing = 0.5;
    public static final double verticalSpacing = 0.5;
    public static final AntennaGain element = Factory.antennaGainFactory().getBeamFormingElementAntenna();
    public static final AntennaPattern pattern = AntennaPattern.ELEMENT;

    @Config(order=10, name="Number of elements in horizontal line")
    public int nh();

    @Config(order=12, name="Number of elements in vertical line")
    public int nv();

    @Config(order=13, name="Horizontal element spacing")
    public double horizontalSpacing();

    @Config(order=14, name="Vertical element spacing")
    public double verticalSpacing();

    @Config(order=17, name="Element antenna")
    public AntennaGain element();

    @Config(order=18, name="Adjacent channel simulation", renderHint="radio")
    public AntennaPattern pattern();

    public static enum AntennaPattern {
        ELEMENT("use element antenna pattern"),
        COMPOSITE("use composite antenna pattern");

        private String title;

        private AntennaPattern(String title) {
            this.title = title;
        }

        public String toString() {
            return this.title;
        }
    }

    public static enum UEpointing {
        RANDOM("Random orientation (based on user behaviour)"),
        FIXED("Fixed pointing towards BS");

        private String pointing;

        private UEpointing(String pointing) {
            this.pointing = pointing;
        }

        public String toString() {
            return this.pointing;
        }
    }
}

