/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.plugin.Config;

public interface HataInput {
    public static final boolean variations = true;
    public static final Environment generalEnvironment = Environment.Urban;
    public static final double wallLossInIn = 5.0;
    public static final double wallLossStdDev = 10.0;
    public static final double adjacentFloorLoss = 18.3;
    public static final double empiricalParameters = 0.46;
    public static final double sizeOfRoom = 4.0;
    public static final double floorHeight = 3.0;

    @Config(order=1, name="General environment")
    public Environment generalEnvironment();

    @Config(order=2, name="Propagation environment")
    public PropEnvironment propagationEnvironment();

    @Config(order=3, name="Wall loss (indoor indoor)", unit="dB")
    public double wallLossInIn();

    @Config(order=4, name="Wall loss std. dev. (indoor indoor)", unit="dB", toolTip="Wall loss standard deviation (indoor indoor)")
    public double wallLossStdDev();

    @Config(order=5, name="Loss between adjacent floor", unit="dB")
    public double adjacentFloorLoss();

    @Config(order=6, name="Empirical parameters")
    public double empiricalParameters();

    @Config(order=7, name="Size of the room", unit="m", toolTip=" droom")
    public double sizeOfRoom();

    @Config(order=8, name="Height of each floor", unit="m", toolTip="hfloor")
    public double floorHeight();

    public static enum PropEnvironment {
        Above_roof("Above roof"),
        Below_roof("Below roof");

        String name;

        private PropEnvironment(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Environment {
        Urban,
        Suburban,
        Rural;

    }
}

