/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;

public interface P1411ver9Input {
    public static final Distribution locPercentage = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final Env_below_rt Environment_below_rt = Env_below_rt.LOS;
    public static final Env_above_rt Environment_above_rt = Env_above_rt.LOS;
    public static final Env_low_height Environment_low_antenna = Env_low_height.URBAN;
    public static final double w = 30.0;
    public static final boolean variations = false;
    public static final boolean belowRoofTop = true;
    public static final boolean aboveRoofTop = false;
    public static final boolean lowAntennaHeight = false;

    @Config(order=1, name="Location percentage", unit="%", distributions={"UNIFORM", "STAIR", "DISCRETE_UNIFORM", "USER_DEFINED", "CONSTANT"})
    public Distribution locPercentage();

    @Config(order=2, name="\u00a74.1.1: Both Tx and Rx are located below-rooftop (street canyons)", defineGroup="belowRoofTop", radioGroup="topSelection")
    public boolean belowRoofTop();

    @Config(order=3, name="Local environment", group="belowRoofTop")
    public Env_below_rt Environment_below_rt();

    @Config(order=4, name="\u00a74.2.1: Either Tx or Rx is located above-rooftop", defineGroup="aboveRoofTop", radioGroup="topSelection")
    public boolean aboveRoofTop();

    @Config(order=5, name="Local environment", group="aboveRoofTop")
    public Env_above_rt Environment_above_rt();

    @Config(order=6, name="\u00a74.3.1: Tx and Rx are below-rooftop near street level", defineGroup="lowAntennaHeight", radioGroup="topSelection")
    public boolean lowAntennaHeight();

    @Config(order=7, name="Local environment", group="lowAntennaHeight")
    public Env_low_height Environment_low_antenna();

    @Config(order=8, name="Use user specified value for LoS/NLoS transition", defineGroup="width", group="lowAntennaHeight")
    public boolean widthUserSpecified();

    @Config(order=9, name="LoS/NLoS transition width", unit="m", group="width")
    public double w();

    public static enum Env_low_height {
        SUB("Suburban", 1),
        URBAN("Urban", 2),
        DENSE("Dense urban/high-rise", 3);

        private String name;
        private int type;

        private Env_low_height(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }

        public int type() {
            return this.type;
        }
    }

    public static enum Env_above_rt {
        LOS("LoS: Urban (high-rise, low-rise)/Suburban", 1),
        NLOS_URBAN("NLoS: Urban high-rise", 2);

        private String name;
        private int type;

        private Env_above_rt(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }

        public int type() {
            return this.type;
        }
    }

    public static enum Env_below_rt {
        LOS("LoS: Urban (high-rise, low-rise)/Suburban", 1),
        NLOS_URBAN("NLoS: Urban high-rise", 2),
        NLOS_SUBURBAN("NLoS: Urban low-rise/Suburban", 3);

        private String name;
        private int type;

        private Env_below_rt(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public String toString() {
            return this.name;
        }

        public int type() {
            return this.type;
        }
    }
}

