/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.OptionalValue;

public interface P1546ver4Input {
    public static final Environment generalEnvironment = Environment.Urban;
    public static final Distribution timePercentage = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final OptionalValue<Double> localClutter = Factory.results().optional(false, 0.0);
    public static final OptionalValue<Double> stdDev = Factory.results().optional(false, 0.0);
    public static final boolean terminalDesignations = true;
    public static final boolean uniformBuildingHeight = true;
    public static final boolean variations = false;

    @Config(order=1, name="General environment")
    public Environment generalEnvironment();

    @Config(order=2, name="System")
    public System system();

    @Config(order=3, name="Time percentage", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution timePercentage();

    @Config(order=4, name="User specified local clutter height", unit="m")
    public OptionalValue<Double> localClutter();

    @Config(order=5, name="User specified std. dev.", unit="dB", toolTip="User specified standard deviation")
    public OptionalValue<Double> stdDev();

    @Config(order=6, name="Area of location variability")
    public Area area();

    @Config(order=7, name="Terminal designations (Annex 5.1,1): use option a), b) and c (recommended)")
    public boolean terminalDesignations();

    @Config(order=8, name="Buildings of uniform height are assumed (recommended)")
    public boolean uniformBuildingHeight();

    public static enum Area {
        _500_x_500_m("500 x 500 m"),
        lessthan_2_km_radius("< 2 km radius"),
        lessthan_50_km_radius("< 50 km radius");

        private String name;

        private Area(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum System {
        Mobile("Mobile"),
        Broadcasting_digital("Broadcasting digital"),
        Broadcasting_analogue("Broadcasting analogue");

        private String name;

        private System(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum Environment {
        Urban("Urban"),
        Suburban("Suburban"),
        Rural("Rural"),
        Dense_Urban("Dense Urban");

        private String name;

        private Environment(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

