/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;

public interface P452ver14Input {
    public static final boolean diffraction = true;
    public static final boolean troposphericScatter = true;
    public static final boolean layerReflection = true;
    public static final double waterConcentration = 3.0;
    public static final double surfacePressure = 1013.25;
    public static final double refractionIndex = 40.0;
    public static final double surfaceTemperature = 15.0;
    public static final double latitude = 45.0;
    public static final double seaLevelSurfaceRefractivity = 325.0;
    public static final Distribution timePercentage = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);

    @Config(order=1, name="Diffraction")
    public boolean diffraction();

    @Config(order=2, name="Tropospheric scatter")
    public boolean troposphericScatter();

    @Config(order=3, name="Ducting/layer reflection")
    public boolean layerReflection();

    @Config(order=4, name="Water concentration", unit="g/m\u00b3")
    public double waterConcentration();

    @Config(order=5, name="Surface pressure", unit="hPa")
    public double surfacePressure();

    @Config(order=6, name="Refraction index gradient", unit="1/km")
    public double refractionIndex();

    @Config(order=7, name="Surface temperature", unit="deg C")
    public double surfaceTemperature();

    @Config(order=8, name="Latitude", unit="deg")
    public double latitude();

    @Config(order=9, name="Additional clutter loss at the Tx", unit="dB", toolTip="Additional clutter loss at the transmitter")
    public double clutterLossTx();

    @Config(order=10, name="Additional clutter loss at the Rx", unit="dB", toolTip="Additional clutter loss at the receiver")
    public double clutterLossRx();

    @Config(order=11, name="Antenna gain at the Tx", unit="dB", toolTip="Antenna gain at the transmitter")
    public double antennaGainTx();

    @Config(order=12, name="Antenna gain at the Rx", unit="dB", toolTip="Antenna gain at the receiver")
    public double antennaGainRx();

    @Config(order=13, name="Sea level surface refractivity")
    public double seaLevelSurfaceRefractivity();

    @Config(order=14, name="Time percentage", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution timePercentage();
}

