/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.propagation.P452ver16Clutter;

public interface P452ver16Input {
    public static final double waterConcentration = 3.0;
    public static final double surfacePressure = 1013.25;
    public static final double refractionIndex = 40.0;
    public static final double surfaceTemperature = 15.0;
    public static final double latitude = 45.0;
    public static final double seaLevelSurfaceRefractivity = 325.0;
    public static final Distribution timePercentage = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);
    public static final boolean variations = false;

    @Config(order=0, name="Diffraction only")
    public boolean diffractionOnly();

    @Config(order=1, name="Water concentration", unit="g/m\u00b3")
    public double waterConcentration();

    @Config(order=2, name="Surface pressure", unit="hPa")
    public double surfacePressure();

    @Config(order=3, name="Refraction index gradient", unit="1/km")
    public double refractionIndex();

    @Config(order=4, name="Surface temperature", unit="deg C")
    public double surfaceTemperature();

    @Config(order=5, name="Latitude", unit="deg")
    public double latitude();

    @Config(order=8, name="Sea level surface refractivity")
    public double seaLevelSurfaceRefractivity();

    @Config(order=9, name="Time percentage", unit="%", distributions={"CONSTANT", "DISCRETE_UNIFORM", "UNIFORM", "USER_DEFINED", "STAIR"})
    public Distribution timePercentage();

    @Config(order=12, name="Apply clutter environment", defineGroup="useClutter")
    public boolean useClutter();

    @Config(order=15, name="Local clutter conditions - Rx", group="useClutter")
    public P452ver16Clutter clutterAtRx();

    @Config(order=17, name="Local clutter conditions - Tx", group="useClutter")
    public P452ver16Clutter clutterAtTx();

    @Config(order=19, name="Local clutter conditions - user specified", defineGroup="clutter", group="useClutter")
    public boolean clutterUserSpecified();

    @Config(order=20, name="Clutter nominal height at the Tx", unit="m", group="clutter")
    public double clutterNominalHeightTx();

    @Config(order=21, name="Clutter nominal distance from the Tx", unit="km", group="clutter")
    public double clutterNominalDistanceTx();

    @Config(order=22, name="Clutter nominal height at the Rx", unit="m", group="clutter")
    public double clutterNominalHeightRx();

    @Config(order=23, name="Clutter nominal distance from the Rx", unit="km", group="clutter")
    public double clutterNominalDistanceRx();
}

