/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.plugin.Config;

public interface SphericalDiffractionInput {
    public static final boolean variations = false;
    public static final double wallLossInIn = 5.0;
    public static final double wallLossStdDev = 10.0;
    public static final double adjacentFloorLoss = 18.3;
    public static final double empiricalParameters = 0.46;
    public static final double sizeOfRoom = 4.0;
    public static final double floorHeight = 3.0;
    public static final double waterConcentration = 3.0;
    public static final double earthSurfaceAdm = 1.0E-5;
    public static final double refractionGradient = 40.0;
    public static final double refractionProb = 1.0;
    public static final Distribution timePercentage = Factory.distributionFactory().getUniformDistribution(50.0, 50.0);

    @Config(order=1, name="Wall loss (indoor indoor)", unit="dB")
    public double wallLossInIn();

    @Config(order=2, name="Wall loss std. dev. (indoor indoor)", unit="dB", toolTip="Wall loss standard deviation (indoor indoor)")
    public double wallLossStdDev();

    @Config(order=3, name="Loss between adjacent Floor", unit="dB")
    public double adjacentFloorLoss();

    @Config(order=4, name="Empirical parameters")
    public double empiricalParameters();

    @Config(order=5, name="Size of the room", unit="m", toolTip="droom")
    public double sizeOfRoom();

    @Config(order=6, name="Height of each floor", unit="m", toolTip="hfloor")
    public double floorHeight();

    @Config(order=7, name="Water concentration", unit="g/m")
    public double waterConcentration();

    @Config(order=8, name="Earth surface admittance")
    public double earthSurfaceAdm();

    @Config(order=9, name="Refraction index gradient", unit="1/km")
    public double refractionGradient();

    @Config(order=10, name="Refraction layer probability", unit="%")
    public double refractionProb();

    @Config(order=11, name="Time percentage", unit="%")
    public Distribution timePercentage();
}

