/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.plugin.system;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.plugin.system.SectorProperty;
import org.seamcat.model.plugin.system.optional.SectorPropertyDescription;

public class Space {
    private static final SectorPropertyDescription rxDesc = new SectorPropertyDescription("Rx");
    private static final SectorPropertyDescription txDesc = new SectorPropertyDescription("Tx");
    private final Polygon2D space;
    private List<SectorProperty> properties;
    private final boolean isRx;

    public Space(Polygon2D space, boolean isRx, SectorProperty ... properties) {
        this.space = space;
        this.isRx = isRx;
        this.properties = new ArrayList<SectorProperty>();
        for (SectorProperty property : properties) {
            this.properties.add(property);
        }
    }

    public Polygon2D getSpace() {
        return this.space;
    }

    public boolean hasProperty(SectorProperty property) {
        return this.properties.contains(property);
    }

    private <T extends SectorProperty> T getProperty(Class<T> clazz) {
        for (SectorProperty property : this.properties) {
            if (!clazz.isAssignableFrom(property.getClass())) continue;
            return (T)property;
        }
        return null;
    }

    public List<SectorProperty> getProperties() {
        return new ArrayList<SectorProperty>(this.properties);
    }

    public boolean isRx() {
        return this.isRx;
    }

    public SectorPropertyDescription getDescription() {
        SectorPropertyDescription property = this.getProperty(SectorPropertyDescription.class);
        if (property == null) {
            return this.isRx() ? rxDesc : txDesc;
        }
        return property;
    }
}

