/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import java.util.ArrayList;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.HataInput;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.Helper;
import org.seamcat.model.propagation.LocalEnvCorrections;
import org.seamcat.model.propagation.PluginCheckUtilsToBeRemoved;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;
import org.seamcat.simulation.hybrid.HybridCDMAUpLinkPlugin;
import org.seamcat.simulation.hybrid.HybridOFDMAUpLinkPlugin;

public class HataSE21PropagationModel
implements PropagationModelPlugin<HataInput> {
    private HataInput input;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, HataInput input, Validator validator) {
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        ArrayList<String> info = new ArrayList<String>();
        Distribution frequency = context.getFrequency();
        if (frequency != null) {
            Bounds bounds = frequency.getBounds();
            if (bounds.getMin() < 30.0) {
                validator.error("Hata model not applicable below 30 MHz" + PluginCheckUtilsToBeRemoved.getExceptionHint());
            }
            if (bounds.getMax() > 3000.0) {
                validator.error("Hata model not applicable above 3 GHz" + PluginCheckUtilsToBeRemoved.getExceptionHint());
            }
        }
        Bounds coverage = context.getCoverage();
        double maxDistance = Math.rint(coverage.getMax() * 10.0 + 0.5) / 10.0;
        if (coverage.getMax() > 100.0) {
            String msg = "<HtMl>Extended Hata model not applicable for distances larger than 100 km <br/> (probably up to " + maxDistance + " km shall be simulated)";
            if (context.getOrigin() == Origin.INTERFERENCE_LINK && (context.getInterferenceLink().getVictim().getSystemPlugin() instanceof HybridOFDMAUpLinkPlugin || context.getInterferenceLink().getVictim().getSystemPlugin() instanceof HybridCDMAUpLinkPlugin)) {
                msg = msg + "<i style='color:blue'><br/>This could be caused by selecting the reference cell NOT at the centre or at the edges of a wrap-around network.</i>";
            }
            msg = msg + PluginCheckUtilsToBeRemoved.getExceptionHint();
            validator.error(msg);
        }
        Bounds rx = context.getRxSettings().getHeight();
        Bounds tx = context.getTxSettings().getHeight();
        if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            rx = context.getInterferenceLink().getVictim().getSystem().getReceiver().getHeight().getBounds();
            tx = context.getInterferenceLink().getInterferer().getSystem().getTransmitter().getHeight().getBounds();
        }
        if (rx.getMax() > 200.0 || tx.getMax() > 200.0) {
            info.add("antenna heights > 200 m");
        }
        if (rx.getMin() < 30.0 && tx.getMin() < 30.0) {
            info.add("both antenna heights below 30 m ");
        }
        if (info.size() > 0) {
            validator.error(((Object)info).toString() + PluginCheckUtilsToBeRemoved.getManualReference(""));
        }
    }

    protected double calculateMedianLoss(double rFreq, double rDist, double rHTx, double rHRx) {
        double rL = 0.0;
        double rCorr = 0.0;
        double rD1 = 0.04;
        double rD2 = 0.1;
        double rHm = Math.min(rHTx, rHRx);
        if (rHm < 1.0) {
            rHm = 1.0;
        }
        double rHb = Math.max(rHTx, rHRx);
        double rL0 = 32.4 + 20.0 * Math.log10(rFreq) + 10.0 * Math.log10(rDist * rDist + (rHb - rHm) * (rHb - rHm) / 1000000.0);
        double rA = (1.1 * Math.log10(rFreq) - 0.7) * Math.min(10.0, rHm) - (1.56 * Math.log10(rFreq) - 0.8) + Math.max(0.0, 20.0 * Math.log10(rHm / 10.0));
        double rB = Math.min(0.0, 20.0 * Math.log10(rHb / 30.0));
        if (rDist <= 20.0) {
            double rAlpha = 1.0;
            rCorr = Math.log10(rDist);
        } else {
            double rAlpha = 1.0 + (0.14 + 1.87E-4 * rFreq + 0.00107 * rHb) * Math.pow(Math.log10(rDist / 20.0), 0.8);
            rCorr = Math.pow(Math.log10(rDist), rAlpha);
        }
        if (rDist <= 0.04) {
            rL = rL0;
        } else if (rDist >= 0.1) {
            rL = rFreq > 30.0 && rFreq <= 150.0 ? 69.6 + 26.2 * Math.log10(150.0) - 20.0 * Math.log10(150.0 / rFreq) - 13.82 * Math.log10(Math.max(30.0, rHb)) + (44.9 - 6.55 * Math.log10(Math.max(30.0, rHb))) * rCorr - rA - rB : (rFreq <= 1500.0 ? 69.6 + 26.2 * Math.log10(rFreq) - 13.82 * Math.log10(Math.max(30.0, rHb)) + (44.9 - 6.55 * Math.log10(Math.max(30.0, rHb))) * rCorr - rA - rB : (rFreq <= 2000.0 ? 46.3 + 33.9 * Math.log10(rFreq) - 13.82 * Math.log10(Math.max(30.0, rHb)) + (44.9 - 6.55 * Math.log10(Math.max(30.0, rHb))) * rCorr - rA - rB : 46.3 + 33.9 * Math.log10(2000.0) + 10.0 * Math.log10(rFreq / 2000.0) - 13.82 * Math.log10(Math.max(30.0, rHb)) + (44.9 - 6.55 * Math.log10(Math.max(30.0, rHb))) * rCorr - rA - rB));
        } else {
            double rL1 = this.calculateMedianLoss(rFreq, 0.04, rHTx, rHRx);
            rL1 = Helper.generalEnvCorrections(rL1, rFreq, 0.04, this.input.generalEnvironment());
            double rL2 = this.calculateMedianLoss(rFreq, 0.1, rHTx, rHRx);
            rL2 = Helper.generalEnvCorrections(rL2, rFreq, 0.1, this.input.generalEnvironment());
            rL = rL1 + (Math.log10(rDist) - Math.log10(0.04)) / (Math.log10(0.1) - Math.log10(0.04)) * (rL2 - rL1);
        }
        return rL;
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, HataInput input) {
        double rFreq = linkResult.getFrequency();
        double rDist = linkResult.getTxRxDistance();
        double rHTx = linkResult.txAntenna().getHeight();
        double rHRx = linkResult.rxAntenna().getHeight();
        this.input = input;
        double medianLoss = 0.0;
        double standardDeviation = 0.0;
        double temp = 0.0;
        if (rFreq < 30.0 || rFreq > 3000.0) {
            throw new RuntimeException("Frequencies below 30 MHz or above 3000 MHz are not supported by the Extended Hata propagation model");
        }
        if (rDist > 100.0) {
            throw new RuntimeException("Distances above 100 km are not supported by the Extended Hata propagation model");
        }
        double freeSpaceAttenuation = 32.44 + 20.0 * Math.log10(rFreq) + 10.0 * Math.log10(rDist * rDist + (rHTx - rHRx) * (rHTx - rHRx) / 1000000.0);
        if (Double.isInfinite(freeSpaceAttenuation)) {
            freeSpaceAttenuation = 20.0 * Math.log10(rFreq) - 100.0;
        }
        medianLoss = this.calculateMedianLoss(rFreq, rDist, rHTx, rHRx);
        standardDeviation = Helper.variationsStdDev(rDist, input.propagationEnvironment());
        if ((medianLoss = Helper.generalEnvCorrections(medianLoss, rFreq, rDist, input.generalEnvironment())) < freeSpaceAttenuation) {
            medianLoss = freeSpaceAttenuation;
        }
        LocalEnvCorrections lec = Helper.localEnvCorrections(new LocalEnvCorrections(medianLoss, standardDeviation), linkResult, input.floorHeight(), input.sizeOfRoom(), input.wallLossInIn(), input.adjacentFloorLoss(), input.empiricalParameters(), input.wallLossStdDev());
        medianLoss = lec.rMedianLoss;
        standardDeviation = lec.rStdDev;
        if (variations) {
            medianLoss += Factory.distributionFactory().getGaussianDistribution(0.0, standardDeviation).trial();
        }
        if (Double.isInfinite(medianLoss)) {
            medianLoss = 20.0 * Math.log10(rFreq) - 100.0;
        }
        return medianLoss;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Extended Hata", "<b><u>Frequency range:</u></b><br>30 MHz - 3 GHz<br><b><u>Distance range:</u></b><br>up to 40 km<br><b><u>Antenna height range:</u></b><br>1 m &lt;=  Hmin &lt;= 10 m<br>30 &lt;= Hmax &lt;= 200 m<br><b><u>Typical application area:</u></b><br>Mobile services and other services working in non-LOS/cluttered environment. Note that in theory, the model can go up to 100 km since the curvature of the earth is included, but in practice it is recommended to use it up to 40 km.<br><b><u>Information:</u></b><br>Note that the Hata model assumes that the specified antenna heights of transmitter and receiver are heights above ground.");
    }
}

