/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.HataInput;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.Helper;
import org.seamcat.model.propagation.LocalEnvCorrections;
import org.seamcat.model.propagation.PluginCheckUtilsToBeRemoved;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class HataSE24PropagationModel
implements PropagationModelPlugin<HataInput> {
    private HataInput input;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, HataInput input, Validator validator) {
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        Bounds bounds = frequency.getBounds();
        if (bounds.getMin() < 30.0 || bounds.getMax() > 3000.0) {
            validator.error("Frequencies below 30 MHz or above 3000 MHz are not supported by the Extended Hata propagation SRD model" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if (context.getCoverage().getMax() > 0.3) {
            String errorMessage = "Distances above 300 m are not supported by the Extended Hata propagation SRD model";
            validator.error(errorMessage + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        Bounds rx = context.getRxSettings().getHeight();
        Bounds tx = context.getTxSettings().getHeight();
        if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            rx = context.getInterferenceLink().getVictim().getSystem().getReceiver().getHeight().getBounds();
            tx = context.getInterferenceLink().getInterferer().getSystem().getTransmitter().getHeight().getBounds();
        }
        if (rx.getMax() > 3.0 || tx.getMax() > 3.0) {
            validator.error(PluginCheckUtilsToBeRemoved.getManualReference("e.g. antenna heights above 3 m"));
        }
    }

    private double calculateMedianLoss(double frequency, double distance, double heightOfTransmitter, double heightOfReceiver) {
        double medianLoss = 0.0;
        double rCorr = 0.0;
        double firstLimitDistance = 0.04;
        double secondLimitDistance = 0.1;
        double rHm = Math.min(heightOfTransmitter, heightOfReceiver);
        if (rHm < 1.0) {
            rHm = 1.0;
        }
        double rHb = Math.max(heightOfTransmitter, heightOfReceiver);
        double freeSpaceAttenuation = 32.4 + 20.0 * Math.log10(frequency) + 10.0 * Math.log10(distance * distance + (rHb - rHm) * (rHb - rHm) / 1000000.0);
        double rA = (1.1 * Math.log10(frequency) - 0.7) * Math.min(10.0, rHm) - (1.56 * Math.log10(frequency) - 0.8) + Math.max(0.0, 20.0 * Math.log10(rHm / 10.0));
        double rB = (1.1 * Math.log10(frequency) - 0.7) * Math.min(10.0, rHb) - (1.56 * Math.log10(frequency) - 0.8) + Math.max(0.0, 20.0 * Math.log10(rHb / 10.0));
        if (distance <= 20.0) {
            double rAlpha = 1.0;
            rCorr = Math.log10(distance);
        } else {
            double rAlpha = 1.0 + (0.14 + 1.87E-4 * frequency + 0.00107 * rHb) * Math.pow(Math.log10(distance / 20.0), 0.8);
            rCorr = Math.pow(Math.log10(distance), rAlpha);
        }
        if (distance <= 0.04) {
            medianLoss = freeSpaceAttenuation;
        } else if (distance >= 0.1) {
            if (frequency > 30.0 && frequency <= 150.0) {
                medianLoss = 69.6 + 26.2 * Math.log10(150.0) - 20.0 * Math.log10(150.0 / frequency) - 13.82 * Math.log10(Math.max(30.0, rHb)) + (44.9 - 6.55 * Math.log10(Math.max(30.0, rHb))) * rCorr - rA - rB;
            } else if (frequency <= 1500.0) {
                medianLoss = 69.6 + 26.2 * Math.log10(frequency) - 13.82 * Math.log10(Math.max(30.0, rHb)) + (44.9 - 6.55 * Math.log10(Math.max(30.0, rHb))) * rCorr - rA - rB;
            } else if (frequency <= 2000.0) {
                medianLoss = 46.3 + 33.9 * Math.log10(frequency) - 13.82 * Math.log10(Math.max(30.0, rHb)) + (44.9 - 6.55 * Math.log10(Math.max(30.0, rHb))) * rCorr - rA - rB;
            } else if (frequency <= 3000.0) {
                medianLoss = 46.3 + 33.9 * Math.log10(2000.0) + 10.0 * Math.log10(frequency / 2000.0) - 13.82 * Math.log10(Math.max(30.0, rHb)) + (44.9 - 6.55 * Math.log10(Math.max(30.0, rHb))) * rCorr - rA - rB;
            }
        } else {
            double lossForFirstLimitDistance = this.calculateMedianLoss(frequency, 0.04, heightOfTransmitter, heightOfReceiver);
            lossForFirstLimitDistance = Helper.generalEnvCorrections(lossForFirstLimitDistance, frequency, 0.04, this.input.generalEnvironment());
            double lossForSecondLimitDistance = this.calculateMedianLoss(frequency, 0.1, heightOfTransmitter, heightOfReceiver);
            lossForSecondLimitDistance = Helper.generalEnvCorrections(lossForSecondLimitDistance, frequency, 0.1, this.input.generalEnvironment());
            medianLoss = lossForFirstLimitDistance + (Math.log10(distance) - Math.log10(0.04)) / (Math.log10(0.04) - Math.log10(0.1)) * (lossForFirstLimitDistance - lossForSecondLimitDistance);
        }
        return medianLoss;
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, HataInput input) {
        double rFreq = linkResult.getFrequency();
        double rDist = linkResult.getTxRxDistance();
        double rHTx = linkResult.txAntenna().getHeight();
        double rHRx = linkResult.rxAntenna().getHeight();
        this.input = input;
        double medianLoss = 0.0;
        double standardDeviation = 0.0;
        double temp = 0.0;
        if (rFreq < 30.0 || rFreq > 3000.0) {
            throw new RuntimeException("Frequencies below 30 MHz or above 3000 MHz are not supported by the Extended Hata propagation SRD model");
        }
        if (rDist > 0.3) {
            throw new RuntimeException("Distances above 300 m are not supported by the Extended Hata propagation SRD model");
        }
        double freeSpaceAttenuation = 32.4 + 20.0 * Math.log10(rFreq) + 10.0 * Math.log10(rDist * rDist + (rHTx - rHRx) * (rHTx - rHRx) / 1000000.0);
        if (Double.isInfinite(freeSpaceAttenuation)) {
            freeSpaceAttenuation = 20.0 * Math.log10(rFreq) - 100.0;
        }
        medianLoss = this.calculateMedianLoss(rFreq, rDist, rHTx, rHRx);
        standardDeviation = Helper.variationsStdDev(rDist, input.propagationEnvironment());
        medianLoss = Helper.generalEnvCorrections(medianLoss, rFreq, rDist, input.generalEnvironment());
        LocalEnvCorrections lec = Helper.localEnvCorrections(new LocalEnvCorrections(medianLoss, standardDeviation), linkResult, input.floorHeight(), input.sizeOfRoom(), input.wallLossInIn(), input.adjacentFloorLoss(), input.empiricalParameters(), input.wallLossStdDev());
        medianLoss = lec.rMedianLoss;
        standardDeviation = lec.rStdDev;
        if (variations) {
            medianLoss += Factory.distributionFactory().getGaussianDistribution(0.0, standardDeviation).trial();
            temp = Factory.distributionFactory().getGaussianDistribution(0.0, 3.5).trial();
        }
        freeSpaceAttenuation += temp;
        if (standardDeviation > 3.5 && medianLoss < freeSpaceAttenuation) {
            medianLoss = freeSpaceAttenuation;
        }
        if (Double.isInfinite(medianLoss)) {
            medianLoss = 20.0 * Math.log10(rFreq) - 100.0;
        }
        return medianLoss;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("Extended Hata - SRD", "<html><body><b><u>Frequency range:</u></b><br>30 MHz - 3 GHz<br><b><u>Distance range:</u></b><br>up to 300 m<br><b><u>Typical application area:</u></b><br>Short range links under direct-LOS <br> assumption,<br> <b>important: antenna heights up to 3 m </b>. <br><b><u>Information:</u></b><br>Note that the Hata model assumes that the <br>specified antenna heights of transmitter <br>and receiver are heights above ground.</body></html>");
    }
}

