/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.P1411ver9Input;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.model.types.result.DescriptionImpl;

public class P1411ver9PropagationModel
implements PropagationModelPlugin<P1411ver9Input> {
    @Override
    public void consistencyCheck(ConsistencyCheckContext context, P1411ver9Input input, Validator validator) {
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        if (input.belowRoofTop() && input.aboveRoofTop()) {
            validator.error("Make sure only one checkbox, \u00a74.1.1, \u00a74.2.1, or \u00a74.3.1 is selected.");
        }
        if (input.belowRoofTop() && input.lowAntennaHeight()) {
            validator.error("Make sure only one checkbox, \u00a74.1.1, \u00a74.2.1, or \u00a74.3.1 is selected.");
        }
        if (input.lowAntennaHeight() && input.aboveRoofTop()) {
            validator.error("Make sure only one checkbox, \u00a74.1.1, \u00a74.2.1, or \u00a74.3.1 is selected.");
        }
        if (!(input.belowRoofTop() || input.aboveRoofTop() || input.lowAntennaHeight())) {
            validator.error("Make sure only one checkbox, \u00a74.1.1 or \u00a74.2.1, or \u00a74.3.1 is selected.");
        }
        Bounds bounds = frequency.getBounds();
        Bounds dbounds = context.getCoverage();
        Bounds pbounds = input.locPercentage().getBounds();
        Bounds rx = context.getRxSettings().getHeight();
        Bounds tx = context.getTxSettings().getHeight();
        if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            rx = context.getInterferenceLink().getVictim().getSystem().getReceiver().getHeight().getBounds();
            tx = context.getInterferenceLink().getInterferer().getSystem().getTransmitter().getHeight().getBounds();
        }
        if (pbounds.getMin() <= 0.0 || pbounds.getMax() >= 100.0) {
            validator.error("The model is valid for probabilities in the range (0, 100)%");
        }
        if (input.belowRoofTop()) {
            int type = input.Environment_below_rt().type();
            if (type == 1) {
                if (bounds.getMin() < 800.0 || bounds.getMax() > 73000.0) {
                    validator.error("The chosen model is valid for frequencies in the range [0.8, 73] GHz");
                }
                if (dbounds.getMin() < 0.005 || dbounds.getMax() > 0.66) {
                    validator.error("The chosen model is valid for distances in the range [5, 660] m");
                }
            } else if (type == 2) {
                if (bounds.getMin() < 800.0 || bounds.getMax() > 38000.0) {
                    validator.error("The chosen model is valid for frequencies in the range [0.8, 38] GHz");
                }
                if (dbounds.getMin() < 0.03 || dbounds.getMax() > 0.715) {
                    validator.error("The chosen model is valid for distances in the range [30, 715] m");
                }
            } else if (type == 3) {
                if (bounds.getMin() < 10000.0 || bounds.getMax() > 73000.0) {
                    validator.error("The chosen model is valid for frequencies in the range [10, 73] GHz");
                }
                if (dbounds.getMin() < 0.03 || dbounds.getMax() > 0.25) {
                    validator.error("The chosen model is valid for distances in the range [30, 250] m");
                }
            }
        } else if (input.aboveRoofTop()) {
            int type = input.Environment_above_rt().type();
            if (type == 1) {
                if (bounds.getMin() < 2200.0 || bounds.getMax() > 73000.0) {
                    validator.error("The chosen model is valid for frequencies in the range [2.2, 73] GHz");
                }
                if (dbounds.getMin() < 0.055 || dbounds.getMax() > 1.2) {
                    validator.error("The chosen model is valid for distances in the range [55, 1200] m");
                }
            } else if (type == 2) {
                if (bounds.getMin() < 2200.0 || bounds.getMax() > 66500.0) {
                    validator.error("The chosen model is valid for frequencies in the range [2.2, 66.5] GHz");
                }
                if (dbounds.getMin() < 0.36 || dbounds.getMax() > 1.2) {
                    validator.error("The chosen model is valid for distances in the range [360, 1200] m");
                }
            }
        } else {
            double w;
            if (bounds.getMin() < 300.0 || bounds.getMax() > 3000.0) {
                validator.error("The chosen model is valid for frequencies in the range [300, 3000] MHz");
            }
            if (dbounds.getMin() <= 0.0 || dbounds.getMax() > 3.0) {
                validator.error("The chosen model is valid for distances in the range (0, 3000] m");
            }
            if (tx.getMin() < 1.9 || tx.getMax() > 3.0 || rx.getMin() < 1.9 || rx.getMax() > 3.0) {
                validator.error("The chosen model is valid for Tx/Rx antenna heights in the range [1.9, 3] m");
            }
            if (input.widthUserSpecified() && (w = input.w()) <= 0.0) {
                validator.error("The value for w must be positive.");
            }
        }
        boolean environmentClutter = false;
        for (LocalEnvironment env : context.getRxSettings().getLocalEnvironments()) {
            if (env.getEnvironment() != LocalEnvironment.Environment.Outdoor || !env.isUsingClutter()) continue;
            environmentClutter = true;
        }
        for (LocalEnvironment env : context.getTxSettings().getLocalEnvironments()) {
            if (env.getEnvironment() != LocalEnvironment.Environment.Outdoor || !env.isUsingClutter()) continue;
            environmentClutter = true;
        }
        if (environmentClutter) {
            validator.error("Applying clutter twice: the environment selection and propagation model ITU-R P.1411-9 Site-General Model are both applying clutter");
        }
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, P1411ver9Input input) {
        double fMHz = linkResult.getFrequency();
        double Dt = linkResult.getTxRxDistance();
        double h1 = linkResult.txAntenna().getHeight();
        double h2 = linkResult.rxAntenna().getHeight();
        double L = 0.0;
        double StdDev = 0.0;
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double sigma = 0.0;
        double f = fMHz / 1000.0;
        double d = Math.sqrt(Math.pow(1000.0 * Dt, 2.0) + Math.pow(h1 - h2, 2.0));
        double p = input.locPercentage().trial();
        if (p <= 0.0 || p >= 100.0) {
            throw new RuntimeException("P.1411ver9: Location percentage is outside the valid domain (0, 100) %");
        }
        if (input.belowRoofTop()) {
            int type = input.Environment_below_rt().type();
            L = this.pl_1411_belowroof(f, d, type, p);
        } else if (input.aboveRoofTop()) {
            int type = input.Environment_above_rt().type();
            L = this.pl_1411_aboveroof(f, d, type, p);
        } else {
            int type = input.Environment_low_antenna().type();
            double w = 20.0;
            if (input.widthUserSpecified()) {
                w = input.w();
            }
            L = this.pl_1411_lowheight(f, d / 1000.0, type, p, w);
        }
        return L;
    }

    public double pl_1411_belowroof(double f, double d, int type, double p) {
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double sigma = 0.0;
        if (type == 1) {
            alpha = 2.12;
            beta = 29.2;
            gamma = 2.11;
            sigma = 5.06;
        } else if (type == 2) {
            alpha = 4.0;
            beta = 10.2;
            gamma = 2.36;
            sigma = 7.6;
        } else if (type == 3) {
            alpha = 5.06;
            beta = -4.68;
            gamma = 2.02;
            sigma = 9.33;
        }
        double L = 10.0 * alpha * Math.log10(d) + beta + 10.0 * gamma * Math.log10(f) + this.norminv(p / 100.0, 0.0, sigma);
        return L;
    }

    public double pl_1411_aboveroof(double f, double d, int type, double p) {
        double alpha = 0.0;
        double beta = 0.0;
        double gamma = 0.0;
        double sigma = 0.0;
        if (type == 1) {
            alpha = 2.29;
            beta = 28.6;
            gamma = 1.96;
            sigma = 3.48;
        } else if (type == 2) {
            alpha = 4.39;
            beta = -6.27;
            gamma = 2.3;
            sigma = 6.89;
        }
        double L = 10.0 * alpha * Math.log10(d) + beta + 10.0 * gamma * Math.log10(f) + this.norminv(p / 100.0, 0.0, sigma);
        return L;
    }

    public double pl_1411_lowheight(double fGHz, double dm, int type, double p, double w) {
        double L;
        if (p <= 0.0 || p >= 100.0) {
            throw new RuntimeException("Location percentage is outside of the valid domain (0, 100) %");
        }
        double Lurban = 0.0;
        if (type == 1) {
            Lurban = 0.0;
        } else if (type == 2) {
            Lurban = 6.8;
        } else if (type == 3) {
            Lurban = 2.3;
        } else {
            throw new RuntimeException("Wrong value in the environmental variable type.");
        }
        double fMHz = fGHz * 1000.0;
        if (fMHz < 300.0 || fMHz > 3000.0) {
            throw new RuntimeException("Frequency is outside of the valid domain (300, 3000) MHz");
        }
        double LLoSMedian = 32.45 + 20.0 * Math.log10(fMHz) + 20.0 * Math.log10(dm / 1000.0);
        double sigma = 7.0;
        double DeltaLLoS = 1.5624 * sigma * (Math.sqrt(-2.0 * Math.log(1.0 - p / 100.0)) - 1.1774);
        double LLoS = LLoSMedian + DeltaLLoS;
        double LNLoSMedian = 9.5 + 45.0 * Math.log10(fMHz) + 40.0 * Math.log10(dm / 1000.0) + Lurban;
        double DeltaLNLoS = this.norminv(p / 100.0, 0.0, sigma);
        double LNLoS = LNLoSMedian + DeltaLNLoS;
        double dLoS = 0.0;
        dLoS = p < 45.0 ? 212.0 * Math.pow(Math.log10(p / 100.0), 2.0) - 64.0 * Math.log10(p / 100.0) : 79.2 - 70.0 * (p / 100.0);
        if (dm < dLoS) {
            L = LLoS;
        } else if (dm > dLoS + w) {
            L = LNLoS;
        } else {
            LLoSMedian = 32.45 + 20.0 * Math.log10(fMHz) + 20.0 * Math.log10(dLoS / 1000.0);
            LLoS = LLoSMedian + DeltaLLoS;
            LNLoSMedian = 9.5 + 45.0 * Math.log10(fMHz) + 40.0 * Math.log10((dLoS + w) / 1000.0) + Lurban;
            LNLoS = LNLoSMedian + DeltaLNLoS;
            L = LLoS + (LNLoS - LLoS) * (dm - dLoS) / w;
        }
        return L;
    }

    private double norminv(double p, double mu, double sigma) {
        double y = mu + sigma * this.Qi(1.0 - p);
        return y;
    }

    private double Qi(double x) {
        double out = x <= 0.5 ? this.T(x) - this.C(x) : -(this.T(1.0 - x) - this.C(1.0 - x));
        return out;
    }

    private double T(double y) {
        double outT = Math.sqrt(-2.0 * Math.log(y));
        return outT;
    }

    private double C(double z) {
        double C0 = 2.515517;
        double C1 = 0.802853;
        double C2 = 0.010328;
        double D1 = 1.432788;
        double D2 = 0.189269;
        double D3 = 0.001308;
        double outC = ((C2 * this.T(z) + C1) * this.T(z) + C0) / (((D3 * this.T(z) + D2) * this.T(z) + D1) * this.T(z) + 1.0);
        return outC;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R P.1411-9 Site-General Model", "<b><u>\u00a74.1.1 both Tx and Rx are below rooftop (street canyon):</u></b><br> <b>1 - LoS, Urban (high-rise, low-rise)/Suburban</b><br>     f = 0.8 - 73 GHz, d = 5 - 660 m <br> <b>2 - NLoS, Urban high-rise</b><br>     f = 0.8 - 38 GHz, d = 30 - 715 m<br> <b>3 - NLoS,  Urban low-rise/Suburban</b><br>    f = 10 - 73 GHz, d = 30 - 250 m<br> <b><u>\u00a74.2.1 either Tx or Rx is above rooftop:</u></b><br> <b>1 - LoS, Urban (high-rise, low-rise)/Suburban</b><br>     f = 2.2 - 73 GHz, d = 55 - 1200 m <br> <b>2 - NLoS, Urban high-rise</b><br>     f = 2.2 - 66.5 GHz, d = 360 - 1200 m <br> <b><u>\u00a74.3.1 Both Tx and Rx are below rooftop (near street level):</u></b><br>  h = 1.9 - 3 m, f = 300 - 3000 MHz, d up to 3000 m");
    }
}

