/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.P2001ver2Input;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.P2001ver2DigitalMaps;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class P2001ver2PropagationModel
implements PropagationModelPlugin<P2001ver2Input> {
    private P2001ver2DigitalMaps maps;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, P2001ver2Input input, Validator validator) {
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Distribution frequency = context.getFrequency();
        Bounds bounds = frequency.getBounds();
        if (bounds.getMin() < 30.0 || bounds.getMax() > 50000.0) {
            validator.error("P2001-2 model applicable for frequencies in the range 30 MHz to 50 GHz");
        }
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, P2001ver2Input input) {
        if (this.maps == null) {
            this.maps = new P2001ver2DigitalMaps();
        }
        double rFreq = linkResult.getFrequency();
        double rDist = linkResult.getTxRxDistance();
        double rHTx = linkResult.txAntenna().getHeight();
        double rHRx = linkResult.rxAntenna().getHeight();
        double Gtx = linkResult.txAntenna().getGain();
        double Grx = linkResult.rxAntenna().getGain();
        double rL = 0.0;
        double rStdDev = 0.0;
        double rP = input.timePercentage().trial();
        double rStep = 0.01;
        int rTotalLength = Math.max(5, (int)Math.round(rDist / rStep));
        rStep = rDist / (double)(rTotalLength - 1);
        double[] rDisti = new double[rTotalLength];
        double[] rHighti = new double[rTotalLength];
        int[] iZonei = new int[rTotalLength];
        rDisti[0] = 0.0;
        rHighti[0] = 0.0;
        iZonei[0] = 4;
        int rpol = 0;
        double Phire = input.rxLongitude();
        double Phirn = input.rxLatitude();
        double Phite = input.txLongitude();
        double Phitn = input.txLatitude();
        int type = input.Polarization().type();
        rpol = type == 1 ? 0 : 1;
        for (int i = 1; i < rTotalLength; ++i) {
            rDisti[i] = rDisti[i - 1] + rStep;
            rHighti[i] = 0.0;
            iZonei[i] = 4;
        }
        rL = this.tl_p2001(this.maps, rDisti, rHighti, iZonei, rFreq / 1000.0, rP, Phire, Phirn, Phite, Phitn, rHRx, rHTx, Grx, Gtx, rpol);
        if (variations) {
            rL += Factory.distributionFactory().getGaussianDistribution(0.0, rStdDev).trial();
        }
        return rL;
    }

    /*
     * WARNING - void declaration
     */
    public double tl_p2001(P2001ver2DigitalMaps maps, double[] d, double[] h, int[] z, double GHz, double Tpc, double Phire, double Phirn, double Phite, double Phitn, double Hrg, double Htg, double Grx, double Gtx, int FlagVP) {
        void Lb;
        void Lbm4;
        void Lbm3;
        void Lbm12;
        double Lm;
        void tse;
        void Ags;
        void Awrs;
        void A2;
        void Aws;
        void Aos;
        void gat;
        void A2r;
        void Pm2;
        void i22;
        double c0 = 2.998E8;
        double Re = 6371.0;
        double Tpcp = Tpc + 1.0E-5 * (50.0 - Tpc) / 50.0;
        double Tpcq = 100.0 - Tpcp;
        int n = d.length;
        double dt = d[n - 1];
        boolean FlagShort = false;
        if (dt < 0.1) {
            FlagShort = true;
        }
        double dpnt = 0.5 * dt;
        double Phime = 0.0;
        double Phimn = 0.0;
        double Bt2r = 0.0;
        double Dgc = 0.0;
        double[] gcp = this.great_circle_path(Phire, Phite, Phirn, Phitn, Re, dpnt);
        Phime = gcp[0];
        Phimn = gcp[1];
        Bt2r = gcp[2];
        Dgc = gcp[3];
        int mp = 0;
        double Hmid = 0.0;
        if (n % 2 == 1) {
            mp = (n + 1) / 2 - 1;
            Hmid = h[mp];
        } else {
            mp = n / 2 - 1;
            Hmid = 0.5 * (h[mp] + h[mp + 1]);
        }
        double omega = this.path_fraction(d, z, 1);
        boolean FlagSea = false;
        if (omega >= 0.75) {
            FlagSea = true;
        }
        double Hts = Htg + h[0];
        double Hrs = Hrg + h[n - 1];
        double H1 = h[0];
        double Hn = h[n - 1];
        double Hhi = Math.max(Hts, Hrs);
        double Hlo = Math.min(Hts, Hrs);
        double Sp = (Hhi - Hlo) / dt;
        double SdN = maps.GetSdN(Phime, Phimn);
        double Nd1km50 = -SdN;
        double SdNsup = maps.GetSdNsup(Phime, Phimn);
        double SdNsub = maps.GetSdNsub(Phime, Phimn);
        double Nd1kmp = 0.0;
        Nd1kmp = Tpcp < 50.0 ? Nd1km50 + SdNsup * Math.log10(0.02 * Tpcp) : Nd1km50 - SdNsub * Math.log10(0.02 * Tpcq);
        double Nd65m1 = maps.GetNd65m1(Phime, Phimn);
        double Reff50 = 157.0 * Re / (157.0 + Nd1km50);
        double Cp = (157.0 + Nd1kmp) / (157.0 * Re);
        double Reffp = 1000000.0;
        if (Cp > 1.0E-6) {
            Reffp = 1.0 / Cp;
        }
        double Thetae = dt / Reff50;
        double Wave = 1.0E-9 * c0 / GHz;
        double[] seh = this.smooth_earth_heights(d, h, Hts, Hrs, Reff50, Wave);
        double Thetat = seh[0];
        double Thetar = seh[1];
        double Thetatpos = seh[2];
        double Thetarpos = seh[3];
        double Dlt = seh[4];
        double Dlr = seh[5];
        int Ilt = (int)seh[6];
        int Ilr = (int)seh[7];
        double Hstip = seh[8];
        double Hsrip = seh[9];
        double Hstipa = seh[10];
        double Hsripa = seh[11];
        double Htea = seh[12];
        double Hrea = seh[13];
        double Mses = seh[14];
        double Hm = seh[15];
        double Hst = seh[16];
        double Hsr = seh[17];
        double Htep = seh[18];
        double Hrep = seh[19];
        int FlagLos50 = (int)seh[20];
        double[] trp = this.tropospheric_path(dt, Hts, Hrs, Thetae, Thetatpos, Thetarpos, Reff50, Phire, Phite, Phirn, Phitn, Re);
        double Dtcv = trp[0];
        double Drcv = trp[1];
        double Phicve = trp[2];
        double Phicvn = trp[3];
        double Hcv = trp[4];
        double Phitcve = trp[5];
        double Phitcvn = trp[6];
        double Phircve = trp[7];
        double Phircvn = trp[8];
        double[] gas = this.gaseous_abs_surface(maps, Phime, Phimn, Hmid, Hts, Hrs, dt, GHz);
        double Aosur = gas[0];
        double Awsur = gas[1];
        double Awrsur = gas[2];
        double Gamo = gas[3];
        double Gamw = gas[4];
        double Gamwr = gas[5];
        double Wvsurmid = gas[6];
        double Agsur = Aosur + Awsur;
        double[] dlp = this.dl_p(d, h, Hts, Hrs, Htep, Hrep, GHz, omega, Reffp, Cp, FlagVP);
        double Ld = dlp[0];
        double Ldsph = dlp[1];
        double Ldba = dlp[2];
        double Ldbs = dlp[3];
        double Ldbka = dlp[4];
        double Ldbks = dlp[5];
        int FlagLospa = (int)dlp[6];
        int FlagLosps = (int)dlp[7];
        double Q0ca = this.multi_path_activity(GHz, dt, Hts, Hrs, Dlt, Dlr, h[Ilt], h[Ilr], Hlo, Thetat, Thetar, Sp, Nd65m1, Phimn, FlagLos50);
        double phi_e = Phime;
        double phi_n = Phimn;
        double h_rainlo = Hlo;
        double h_rainhi = Hhi;
        double d_rain = dt;
        double[] pfi = this.precipitation_fade_initial(maps, GHz, Tpcq, phi_n, phi_e, h_rainlo, h_rainhi, d_rain, FlagVP);
        double a = pfi[0];
        double b = pfi[1];
        double c = pfi[2];
        double dr = pfi[3];
        double Q0ra = pfi[4];
        double Fwvr = pfi[5];
        double kmod = pfi[6];
        double alpha_mod = pfi[7];
        int ngp = (int)pfi[8];
        double[] Gm = new double[ngp];
        double[] Pm = new double[ngp];
        for (int i = 0; i < ngp; ++i) {
            Gm[i] = pfi[9 + i];
            Pm[i] = pfi[9 + ngp + i];
        }
        int flagrain = (int)pfi[9 + 2 * ngp];
        int flagtropo = 0;
        double A1 = this.Aiter(Tpcq, Q0ca, Q0ra, flagtropo, a, b, c, dr, kmod, alpha_mod, Gm, Pm, flagrain);
        double Lbfs = this.tl_free_space(GHz, dt);
        double Lbm1 = Lbfs + Ld + A1 + Fwvr * (Awrsur - Awsur) + Agsur;
        double[] tlf = this.tl_anomalous_reflection(GHz, d, z, Hts, Hrs, Htea, Hrea, Hm, Thetat, Thetar, Dlt, Dlr, Phimn, omega, Reff50, Tpcp, Tpcq);
        double Lba = tlf[0];
        double Aat = tlf[1];
        double Aad = tlf[2];
        double Aac = tlf[3];
        double Dct = tlf[4];
        double Dcr = tlf[5];
        double Dtm = tlf[6];
        double Dlm = tlf[7];
        double Lbm2 = Lba + Agsur;
        double[] tlt = this.tl_troposcatter(maps, GHz, dt, Thetat, Thetar, Thetae, Phicvn, Phicve, Phitn, Phite, Phirn, Phire, Gtx, Grx, Reff50, Tpcp);
        double Lbs = tlt[0];
        double Thetas = tlt[1];
        int Ztropo = (int)tlt[2];
        Lbs = Math.max(Lbs, Lbfs);
        phi_e = Phitcve;
        phi_n = Phitcvn;
        h_rainlo = Hts;
        h_rainhi = Hcv;
        d_rain = Dtcv;
        pfi = this.precipitation_fade_initial(maps, GHz, Tpcq, phi_n, phi_e, h_rainlo, h_rainhi, d_rain, FlagVP);
        a = pfi[0];
        b = pfi[1];
        c = pfi[2];
        dr = pfi[3];
        Q0ra = pfi[4];
        double Fwvrtx = pfi[5];
        kmod = pfi[6];
        alpha_mod = pfi[7];
        ngp = (int)pfi[8];
        double[] Gm1 = new double[ngp];
        double[] Pm1 = new double[ngp];
        for (int i = 0; i < ngp; ++i) {
            Gm1[i] = pfi[9 + i];
            Pm1[i] = pfi[9 + ngp + i];
        }
        flagrain = (int)pfi[9 + 2 * ngp];
        flagtropo = 1;
        double A2t = this.Aiter(Tpcq, Q0ca, Q0ra, flagtropo, a, b, c, dr, kmod, alpha_mod, Gm1, Pm1, flagrain);
        phi_e = Phircve;
        phi_n = Phircvn;
        h_rainlo = Hrs;
        h_rainhi = Hcv;
        d_rain = Drcv;
        pfi = this.precipitation_fade_initial(maps, GHz, Tpcq, phi_n, phi_e, h_rainlo, h_rainhi, d_rain, FlagVP);
        a = pfi[0];
        b = pfi[1];
        c = pfi[2];
        dr = pfi[3];
        Q0ra = pfi[4];
        double Fwvrrx = pfi[5];
        kmod = pfi[6];
        alpha_mod = pfi[7];
        ngp = (int)pfi[8];
        double[] Gm2 = new double[ngp];
        double[] dArray = new double[ngp];
        boolean bl = false;
        while (i22 < ngp) {
            Gm2[i22] = pfi[9 + i22];
            Pm2[i22] = pfi[9 + ngp + i22];
            ++i22;
        }
        flagrain = (int)pfi[9 + 2 * ngp];
        flagtropo = 1;
        double i22 = this.Aiter(Tpcq, Q0ca, Q0ra, flagtropo, a, b, c, dr, kmod, alpha_mod, Gm2, (double[])Pm2, flagrain);
        double d2 = (A2t * (1.0 + 0.018 * Dtcv) + A2r * (1.0 + 0.018 * Drcv)) / (1.0 + 0.018 * dt);
        double[] dArray2 = this.gaseous_abs_tropo(maps, Phite, Phitn, Phire, Phirn, h[0], h[h.length - 1], Thetatpos, Thetarpos, Dtcv, Drcv, GHz);
        void var262_150 = gat[0];
        void var264_151 = gat[1];
        void var266_152 = gat[2];
        void var268_153 = gat[3];
        void var270_154 = gat[4];
        void var272_155 = gat[5];
        void var274_156 = gat[6];
        void var276_157 = gat[7];
        void var278_158 = gat[8];
        void var280_159 = gat[9];
        void var282_160 = gat[10];
        void var284_161 = Aos + Aws;
        double d3 = Lbs + A2 + 0.5 * (Fwvrtx + Fwvrrx) * (Awrs - Aws) + Ags;
        double[] dArray3 = this.tl_sporadic_e(maps, GHz, dt, Thetat, Thetar, Phimn, Phime, Phitn, Phite, Phirn, Phire, Dlt, Dlr, Reff50, Re, Tpcp);
        void var289_164 = tse[0];
        void var291_165 = tse[1];
        void var293_166 = tse[2];
        void var295_167 = tse[3];
        void var297_168 = tse[4];
        void var299_169 = tse[5];
        void var301_170 = tse[6];
        void var303_171 = tse[7];
        void var305_172 = tse[8];
        void var307_173 = tse[9];
        void var309_174 = tse[10];
        void var311_175 = tse[11];
        void var313_176 = tse[12];
        void var315_177 = tse[13];
        void var317_178 = tse[14];
        double d4 = Math.min(Lbm1, Lbm2);
        void var321_180 = Lm - 10.0 * Math.log10(Math.pow(10.0, -0.1 * (Lbm1 - Lm)) + Math.pow(10.0, -0.1 * (Lbm2 - Lm)));
        Lm = Math.min((double)Lbm12, (double)Lbm3);
        Lm = Math.min(Lm, (double)Lbm4);
        double d5 = Lm - 5.0 * Math.log10(Math.pow(10.0, -0.2 * (Lbm12 - Lm)) + Math.pow(10.0, -0.2 * (Lbm3 - Lm)) + Math.pow(10.0, -0.2 * (Lbm4 - Lm)));
        return (double)Lb;
    }

    public double path_fraction(double[] d, int[] zone, int zone_r) {
        double dm = 0.0;
        int n = d.length;
        for (int i = 0; i < n; ++i) {
            if (zone[i] != zone_r) continue;
            double delta = i == 0 ? (d[1] - d[0]) / 2.0 : (i == n - 1 ? (d[n - 1] - d[n - 2]) / 2.0 : (d[i + 1] - d[i - 1]) / 2.0);
            dm += delta;
        }
        return dm / (d[n - 1] - d[0]);
    }

    public double[] great_circle_path(double Phire, double Phite, double Phirn, double Phitn, double Re, double dpnt) {
        double Dlon = Phire - Phite;
        double r = this.sind(Phitn) * this.sind(Phirn) + this.cosd(Phitn) * this.cosd(Phirn) * this.cosd(Dlon);
        double Phid = Math.acos(r);
        double dgc = Phid * Re;
        double x1 = this.sind(Phirn) - r * this.sind(Phitn);
        double y1 = this.cosd(Phitn) * this.cosd(Phirn) * this.sind(Dlon);
        double Bt2r = Phire;
        Bt2r = Math.abs(x1) < 1.0E-9 && Math.abs(y1) < 1.0E-9 ? Phire : this.atan2d(y1, x1);
        double Phipnt = dpnt / Re;
        double s = this.sind(Phitn) * Math.cos(Phipnt) + this.cosd(Phitn) * Math.sin(Phipnt) * this.cosd(Bt2r);
        double Phipntn = this.asind(s);
        double x2 = Math.cos(Phipnt) - s * this.sind(Phitn);
        double y2 = this.cosd(Phitn) * Math.sin(Phipnt) * this.sind(Bt2r);
        double Phipnte = Bt2r;
        Phipnte = x2 < 1.0E-9 && y2 < 1.0E-9 ? Bt2r : Phite + this.atan2d(y2, x2);
        double[] out = new double[]{Phipnte, Phipntn, Bt2r, dgc};
        return out;
    }

    public double sind(double theta_deg) {
        double theta_rad = theta_deg * Math.PI / 180.0;
        double y = Math.sin(theta_rad);
        return y;
    }

    public double cosd(double theta_deg) {
        double theta_rad = theta_deg * Math.PI / 180.0;
        double y = Math.cos(theta_rad);
        return y;
    }

    public double atan2d(double y, double x) {
        double res = Math.atan2(y, x) * 180.0 / Math.PI;
        return res;
    }

    public double asind(double y) {
        double x = Math.asin(y) * 180.0 / Math.PI;
        return x;
    }

    public double[] smooth_earth_heights(double[] d, double[] h, double hts, double hrs, double ae, double lam) {
        int ii;
        int n = d.length;
        double dtot = d[n - 1];
        double theta_tim = (h[1] - hts) / d[1] - 500.0 * d[1] / ae;
        for (int ii2 = 2; ii2 < n - 1; ++ii2) {
            theta_tim = Math.max(theta_tim, (h[ii2] - hts) / d[ii2] - 500.0 * d[ii2] / ae);
        }
        double theta_tr = (hrs - hts) / dtot - 500.0 * dtot / ae;
        boolean FlagLos50 = true;
        int kindex = 1;
        int lt = 0;
        double dlt = 0.0;
        double dlr = 0.0;
        int lr = 0;
        double theta_t = 0.0;
        double theta_r = 0.0;
        if (theta_tim < theta_tr) {
            FlagLos50 = true;
            ii = 1;
            double numax = (h[ii] + 500.0 * d[ii] * (dtot - d[ii]) / ae - (hts * (dtot - d[ii]) + hrs * d[ii]) / dtot) * Math.sqrt(0.002 * dtot / (lam * d[ii] * (dtot - d[ii])));
            for (ii = 2; ii < n - 1; ++ii) {
                double nu = (h[ii] + 500.0 * d[ii] * (dtot - d[ii]) / ae - (hts * (dtot - d[ii]) + hrs * d[ii]) / dtot) * Math.sqrt(0.002 * dtot / (lam * d[ii] * (dtot - d[ii])));
                if (!(nu > numax)) continue;
                numax = nu;
                kindex = ii;
            }
            lt = kindex;
            dlt = d[lt];
            dlr = dtot - dlt;
            lr = lt;
            theta_t = theta_tr;
            theta_r = -theta_tr - 1000.0 * dtot / ae;
        } else {
            double theta_ri;
            FlagLos50 = false;
            for (ii = 1; ii < n - 1; ++ii) {
                double theta_ti = (h[ii] - hts) / d[ii] - 500.0 * d[ii] / ae;
                if (theta_ti != theta_tim) continue;
                lt = ii;
                dlt = d[lt];
                break;
            }
            theta_t = theta_tim;
            ii = 1;
            double theta_rim = theta_ri = (h[ii] - hrs) / (dtot - d[ii]) - 500.0 * (dtot - d[ii]) / ae;
            for (ii = 2; ii < n - 1; ++ii) {
                theta_ri = (h[ii] - hrs) / (dtot - d[ii]) - 500.0 * (dtot - d[ii]) / ae;
                if (!(theta_ri > theta_rim)) continue;
                theta_rim = theta_ri;
                kindex = ii;
            }
            lr = kindex;
            dlr = dtot - d[lr];
            theta_r = theta_rim;
        }
        double theta_tpos = Math.max(theta_t, 0.0);
        double theta_rpos = Math.max(theta_r, 0.0);
        double v1 = 0.0;
        for (int ii3 = 1; ii3 < n; ++ii3) {
            v1 += (d[ii3] - d[ii3 - 1]) * (h[ii3] + h[ii3 - 1]);
        }
        double v2 = 0.0;
        for (int ii4 = 1; ii4 < n; ++ii4) {
            v2 += (d[ii4] - d[ii4 - 1]) * (h[ii4] * (2.0 * d[ii4] + d[ii4 - 1]) + h[ii4 - 1] * (d[ii4] + 2.0 * d[ii4 - 1]));
        }
        double hstip = (2.0 * v1 * dtot - v2) / (dtot * dtot);
        double hsrip = (v2 - v1 * dtot) / (dtot * dtot);
        double hstipa = Math.min(hstip, h[0]);
        double hsripa = Math.min(hsrip, h[n - 1]);
        double mses = (hsripa - hstipa) / dtot;
        double htea = hts - hstipa;
        double hrea = hrs - hsripa;
        int ii5 = lt;
        double hm = h[ii5] - (hstipa + mses * d[ii5]);
        for (ii5 = lt + 1; ii5 <= lr; ++ii5) {
            hm = Math.max(hm, h[ii5] - (hstipa + mses * d[ii5]));
        }
        ii5 = 1;
        double hobs = h[ii5] - (hts * (dtot - d[ii5]) + hrs * d[ii5]) / dtot;
        double alpha_obt = hobs / d[ii5];
        double alpha_obr = hobs / (dtot - d[ii5]);
        for (ii5 = 2; ii5 < n - 1; ++ii5) {
            double HH = h[ii5] - (hts * (dtot - d[ii5]) + hrs * d[ii5]) / dtot;
            hobs = Math.max(hobs, HH);
            alpha_obt = Math.max(alpha_obt, HH / d[ii5]);
            alpha_obr = Math.max(alpha_obr, HH / (dtot - d[ii5]));
        }
        double gt = alpha_obt / (alpha_obt + alpha_obr);
        double gr = alpha_obr / (alpha_obt + alpha_obr);
        double hst = 0.0;
        double hsr = 0.0;
        if (hobs <= 0.0) {
            hst = hstip;
            hsr = hsrip;
        } else {
            hst = hstip - hobs * gt;
            hsr = hsrip - hobs * gr;
        }
        if (hst >= h[0]) {
            hst = h[0];
        }
        if (hsr > h[n - 1]) {
            hsr = h[n - 1];
        }
        double htep = hts - hst;
        double hrep = hrs - hsr;
        double[] seh = new double[]{theta_t, theta_r, theta_tpos, theta_rpos, dlt, dlr, lt, lr, hstip, hsrip, hstipa, hsripa, htea, hrea, mses, hm, hst, hsr, htep, hrep, (double)FlagLos50};
        return seh;
    }

    public double[] tropospheric_path(double dt, double hts, double hrs, double theta_e, double theta_tpos, double theta_rpos, double ae, double phi_re, double phi_te, double phi_rn, double phi_tn, double Re) {
        double d_tcv = (dt * Math.tan(0.001 * theta_rpos + 0.5 * theta_e) - 0.001 * (hts - hrs)) / (Math.tan(0.001 * theta_tpos + 0.5 * theta_e) + Math.tan(0.001 * theta_rpos + 0.5 * theta_e));
        if (d_tcv < 0.0) {
            d_tcv = 0.0;
        }
        if (d_tcv > dt) {
            d_tcv = dt;
        }
        double d_rcv = dt - d_tcv;
        double[] gcp = this.great_circle_path(phi_re, phi_te, phi_rn, phi_tn, Re, d_tcv);
        double phi_cve = gcp[0];
        double phi_cvn = gcp[1];
        double h_cv = hts + 1000.0 * d_tcv * Math.tan(0.001 * theta_tpos) + 1000.0 * d_tcv * d_tcv / (2.0 * ae);
        double d_pnt = 0.5 * d_tcv;
        gcp = this.great_circle_path(phi_re, phi_te, phi_rn, phi_tn, Re, d_pnt);
        double phi_tcve = gcp[0];
        double phi_tcvn = gcp[1];
        d_pnt = dt - 0.5 * d_rcv;
        gcp = this.great_circle_path(phi_re, phi_te, phi_rn, phi_tn, Re, d_pnt);
        double phi_rcve = gcp[0];
        double phi_rcvn = gcp[1];
        double[] out = new double[]{d_tcv, d_rcv, phi_cve, phi_cvn, h_cv, phi_tcve, phi_tcvn, phi_rcve, phi_rcvn};
        return out;
    }

    public double[] gaseous_abs_surface(P2001ver2DigitalMaps maps, double phi_me, double phi_mn, double h_mid, double hts, double hrs, double dt, double f) {
        double rho_sur = maps.GetRhoSur(phi_me, phi_mn);
        double h_sur = h_mid;
        double[] gamma = this.specific_sea_level_attenuation(f, rho_sur, h_sur);
        double gamma_o = gamma[0];
        double gamma_w = gamma[1];
        double rho_surr = this.water_vapour_density_rain(rho_sur, h_sur);
        double[] gamma_xx = this.specific_sea_level_attenuation(f, rho_surr, h_sur);
        double gamma_wr = gamma_xx[1];
        double h_rho = 0.5 * (hts + hrs);
        double Aosur = gamma_o * dt * Math.exp(-h_rho / 5000.0);
        double Awsur = gamma_w * dt * Math.exp(-h_rho / 2000.0);
        double Awrsur = gamma_wr * dt * Math.exp(-h_rho / 2000.0);
        double[] out = new double[]{Aosur, Awsur, Awrsur, gamma_o, gamma_w, gamma_wr, rho_sur};
        return out;
    }

    public double[] specific_sea_level_attenuation(double f, double rho_sur, double h_sur) {
        double rho_sea = rho_sur * Math.exp(h_sur / 2000.0);
        double eta = 0.955 + 0.006 * rho_sea;
        double gamma_o = (7.2 / (f * f + 0.34) + 0.62 / (Math.pow(54.0 - f, 1.16) + 0.83)) * f * f * 0.001;
        double gamma_w = (0.046 + 0.0019 * rho_sea + 3.98 * eta / (Math.pow(f - 22.235, 2.0) + 9.42 * eta * eta) * (1.0 + Math.pow((f - 22.0) / (f + 22.0), 2.0))) * f * f * rho_sea * 1.0E-4;
        double[] out = new double[]{gamma_o, gamma_w};
        return out;
    }

    public double water_vapour_density_rain(double rho_sur, double h_sur) {
        double rho_surr = 0.0;
        rho_surr = h_sur <= 2600.0 ? rho_sur + 0.4 + 3.0E-4 * h_sur : rho_sur + 5.0 * Math.exp(-h_sur / 1800.0);
        return rho_surr;
    }

    public double[] dl_p(double[] d, double[] h, double hts, double hrs, double hte, double hre, double f, double omega, double ap, double Cp, int polHV) {
        int n = d.length;
        double dtot = d[n - 1];
        double[] Ldsph = this.dl_se(dtot, hte, hre, ap, f, omega);
        double[] dba = this.dl_bull_actual(d, h, hts, hrs, Cp, f);
        double Ldba = dba[0];
        double Ldbka = dba[1];
        double FlagLospa = dba[2];
        double[] dbs = this.dl_bull_smooth(d, h, hte, hre, ap, f);
        double Ldbs = dbs[0];
        double Ldbks = dbs[1];
        double FlagLosps = dbs[2];
        double Ld = Ldba + Math.max(Ldsph[polHV] - Ldbs, 0.0);
        double[] out = new double[]{Ld, Ldsph[polHV], Ldba, Ldbs, Ldbka, Ldbks, FlagLospa, FlagLosps};
        return out;
    }

    public double[] dl_se(double d, double hte, double hre, double ap, double f, double omega) {
        double[] Ldsph = new double[]{0.0, 0.0};
        double c0 = 2.998E8;
        double lam = 1.0E-9 * c0 / f;
        double dlos = Math.sqrt(2.0 * ap) * (Math.sqrt(0.001 * hte) + Math.sqrt(0.001 * hre));
        if (d >= dlos) {
            Ldsph = this.dl_se_ft(d, hte, hre, ap, f, omega);
            return Ldsph;
        }
        double c = (hte - hre) / (hte + hre);
        double m = 250.0 * d * d / (ap * (hte + hre));
        double b = 2.0 * Math.sqrt((m + 1.0) / (3.0 * m)) * Math.cos(1.0471975511965976 + 0.3333333333333333 * Math.acos(3.0 * c / 2.0 * Math.sqrt(3.0 * m / Math.pow(m + 1.0, 3.0))));
        double dse1 = d / 2.0 * (1.0 + b);
        double dse2 = d - dse1;
        double hse = (hte - 500.0 * dse1 * dse1 / ap) * dse2 + (hre - 500.0 * dse2 * dse2 / ap) * dse1;
        double hreq = 17.456 * Math.sqrt(dse1 * dse2 * lam / d);
        if ((hse /= d) > hreq) {
            Ldsph[0] = 0.0;
            Ldsph[1] = 0.0;
            return Ldsph;
        }
        double aem = 500.0 * Math.pow(d / (Math.sqrt(hte) + Math.sqrt(hre)), 2.0);
        double[] Ldft = this.dl_se_ft(d, hte, hre, aem, f, omega);
        if (Ldft[0] < 0.0) {
            Ldsph[0] = 0.0;
            Ldsph[1] = 0.0;
            return Ldsph;
        }
        Ldsph[0] = (1.0 - hse / hreq) * Ldft[0];
        Ldsph[1] = (1.0 - hse / hreq) * Ldft[1];
        return Ldsph;
    }

    public double[] dl_se_ft(double d, double hte, double hre, double adft, double f, double omega) {
        double epsr = 22.0;
        double sigma = 0.003;
        double[] Ldft_land = this.dl_se_ft_inner(epsr, sigma, d, hte, hre, adft, f);
        epsr = 80.0;
        sigma = 5.0;
        double[] Ldft_sea = this.dl_se_ft_inner(epsr, sigma, d, hte, hre, adft, f);
        double[] Ldft = new double[]{omega * Ldft_sea[0] + (1.0 - omega) * Ldft_land[0], omega * Ldft_sea[1] + (1.0 - omega) * Ldft_land[1]};
        return Ldft;
    }

    double[] dl_se_ft_inner(double epsr, double sigma, double d, double hte, double hre, double adft, double f) {
        double[] K;
        K = new double[]{0.036 * Math.pow(adft * f, -0.3333333333333333) * Math.pow(Math.pow(epsr - 1.0, 2.0) + Math.pow(18.0 * sigma / f, 2.0), -0.25), K[0] * Math.pow(Math.pow(epsr, 2.0) + Math.pow(18.0 * sigma / f, 2.0), 0.5)};
        double[] beta_dft = new double[2];
        double[] X = new double[2];
        double[] Yt = new double[2];
        double[] Yr = new double[2];
        for (int ii = 0; ii < 2; ++ii) {
            beta_dft[ii] = (1.0 + 1.6 * Math.pow(K[ii], 2.0) + 0.67 * Math.pow(K[ii], 4.0)) / (1.0 + 4.5 * Math.pow(K[ii], 2.0) + 1.53 * Math.pow(K[ii], 4.0));
            X[ii] = 21.88 * beta_dft[ii] * Math.pow(f / Math.pow(adft, 2.0), 0.3333333333333333) * d;
            Yt[ii] = 0.9575 * beta_dft[ii] * Math.pow(f * f / adft, 0.3333333333333333) * hte;
            Yr[ii] = 0.9575 * beta_dft[ii] * Math.pow(f * f / adft, 0.3333333333333333) * hre;
        }
        double[] Fx = new double[]{0.0, 0.0};
        double[] GYt = new double[]{0.0, 0.0};
        double[] GYr = new double[]{0.0, 0.0};
        double[] Bt = new double[]{0.0, 0.0};
        double[] Br = new double[]{0.0, 0.0};
        double[] Ldft = new double[]{0.0, 0.0};
        for (int ii = 0; ii < 2; ++ii) {
            Fx[ii] = X[ii] >= 1.6 ? 11.0 + 10.0 * Math.log10(X[ii]) - 17.6 * X[ii] : -20.0 * Math.log10(X[ii]) - 5.6488 * Math.pow(X[ii], 1.425);
            Bt[ii] = beta_dft[ii] * Yt[ii];
            Br[ii] = beta_dft[ii] * Yr[ii];
            GYt[ii] = Bt[ii] > 2.0 ? 17.6 * Math.pow(Bt[ii] - 1.1, 0.5) - 5.0 * Math.log10(Bt[ii] - 1.1) - 8.0 : 20.0 * Math.log10(Bt[ii] + 0.1 * Math.pow(Bt[ii], 3.0));
            GYr[ii] = Br[ii] > 2.0 ? 17.6 * Math.pow(Br[ii] - 1.1, 0.5) - 5.0 * Math.log10(Br[ii] - 1.1) - 8.0 : 20.0 * Math.log10(Br[ii] + 0.1 * Math.pow(Br[ii], 3.0));
            if (GYr[ii] < 2.0 + 20.0 * Math.log10(K[ii])) {
                GYr[ii] = 2.0 + 20.0 * Math.log10(K[ii]);
            }
            if (GYt[ii] < 2.0 + 20.0 * Math.log10(K[ii])) {
                GYt[ii] = 2.0 + 20.0 * Math.log10(K[ii]);
            }
            Ldft[ii] = -Fx[ii] - GYt[ii] - GYr[ii];
        }
        return Ldft;
    }

    public double[] dl_bull_actual(double[] d, double[] h, double hts, double hrs, double Cp, double f) {
        double Ldba = 0.0;
        double Ldbka = 0.0;
        boolean FlagLospa = false;
        double c0 = 2.998E8;
        double lam = 1.0E-9 * c0 / f;
        int n = d.length;
        double dtot = d[n - 1] - d[0];
        int ii = 1;
        double Stim = (h[ii] + 500.0 * Cp * d[ii] * (dtot - d[ii]) - hts) / d[ii];
        for (ii = 2; ii < n - 1; ++ii) {
            Stim = Math.max(Stim, (h[ii] + 500.0 * Cp * d[ii] * (dtot - d[ii]) - hts) / d[ii]);
        }
        double Str = (hrs - hts) / dtot;
        if (Stim < Str) {
            FlagLospa = true;
            ii = 1;
            double numax = (h[ii] + 500.0 * Cp * d[ii] * (dtot - d[ii]) - (hts * (dtot - d[ii]) + hrs * d[ii]) / dtot) * Math.sqrt(0.002 * dtot / (lam * d[ii] * (dtot - d[ii])));
            for (ii = 2; ii < n - 1; ++ii) {
                double num = (h[ii] + 500.0 * Cp * d[ii] * (dtot - d[ii]) - (hts * (dtot - d[ii]) + hrs * d[ii]) / dtot) * Math.sqrt(0.002 * dtot / (lam * d[ii] * (dtot - d[ii])));
                if (!(num > numax)) continue;
                numax = num;
            }
            Ldbka = this.dl_knife_edge(numax);
        } else {
            FlagLospa = false;
            ii = 1;
            double Srim = (h[ii] + 500.0 * Cp * d[ii] * (dtot - d[ii]) - hrs) / (dtot - d[ii]);
            for (ii = 2; ii < n - 1; ++ii) {
                double Sri = (h[ii] + 500.0 * Cp * d[ii] * (dtot - d[ii]) - hrs) / (dtot - d[ii]);
                if (!(Sri > Srim)) continue;
                Srim = Sri;
            }
            double dbp = (hrs - hts + Srim * dtot) / (Stim + Srim);
            double nub = (hts + Stim * dbp - (hts * (dtot - dbp) + hrs * dbp) / dtot) * Math.sqrt(0.002 * dtot / (lam * dbp * (dtot - dbp)));
            Ldbka = this.dl_knife_edge(nub);
        }
        Ldba = Ldbka + (1.0 - Math.exp(-Ldbka / 6.0)) * (10.0 + 0.02 * dtot);
        double[] out = new double[]{Ldba, Ldbka, (double)FlagLospa};
        return out;
    }

    double[] dl_bull_smooth(double[] d, double[] h, double htep, double hrep, double ap, double f) {
        boolean FlagLosps = true;
        double Ldbks = 0.0;
        double c0 = 2.998E8;
        double lam = 1.0E-9 * c0 / f;
        int n = d.length;
        double dtot = d[n - 1] - d[0];
        int ii = 1;
        double Stim = 500.0 * (dtot - d[ii]) / ap - htep / d[ii];
        for (ii = 2; ii < n - 1; ++ii) {
            double Sti = 500.0 * (dtot - d[ii]) / ap - htep / d[ii];
            if (!(Sti > Stim)) continue;
            Stim = Sti;
        }
        double Str = (hrep - htep) / dtot;
        if (Stim < Str) {
            FlagLosps = true;
            ii = 1;
            double numax = (500.0 * d[ii] * (dtot - d[ii]) / ap - (htep * (dtot - d[ii]) + hrep * d[ii]) / dtot) * Math.sqrt(0.002 * dtot / (lam * d[ii] * (dtot - d[ii])));
            for (ii = 2; ii < n - 1; ++ii) {
                double num = (500.0 * d[ii] * (dtot - d[ii]) / ap - (htep * (dtot - d[ii]) + hrep * d[ii]) / dtot) * Math.sqrt(0.002 * dtot / (lam * d[ii] * (dtot - d[ii])));
                if (!(num > numax)) continue;
                numax = num;
            }
            Ldbks = this.dl_knife_edge(numax);
        } else {
            FlagLosps = false;
            ii = 1;
            double Srim = 500.0 * d[ii] / ap - hrep / (dtot - d[ii]);
            for (ii = 2; ii < n - 1; ++ii) {
                double Sri = 500.0 * d[ii] / ap - hrep / (dtot - d[ii]);
                if (!(Sri > Srim)) continue;
                Srim = Sri;
            }
            double dbp = (hrep - htep + Srim * dtot) / (Stim + Srim);
            double nub = (htep + Stim * dbp - (htep * (dtot - dbp) + hrep * dbp) / dtot) * Math.sqrt(0.002 * dtot / (lam * dbp * (dtot - dbp)));
            Ldbks = this.dl_knife_edge(nub);
        }
        double Ldbs = Ldbks + (1.0 - Math.exp(-Ldbks / 6.0)) * (10.0 + 0.02 * dtot);
        double[] out = new double[]{Ldbs, Ldbks, (double)FlagLosps};
        return out;
    }

    private double dl_knife_edge(double nu) {
        double J = 0.0;
        if (nu > -0.78) {
            J = 6.9 + 20.0 * Math.log10(Math.sqrt(Math.pow(nu - 0.1, 2.0) + 1.0) + nu - 0.1);
        }
        return J;
    }

    public double multi_path_activity(double f, double dt, double hts, double hrs, double dlt, double dlr, double hlt, double hlr, double hlo, double thetat, double thetar, double epsp, double Nd65m1, double phimn, int FlagLos50) {
        double Q0ca;
        double K = Math.pow(10.0, -(4.6 + 0.0027 * Nd65m1));
        if (FlagLos50 == 1) {
            double dca = dt;
            double epsca = epsp;
            double hca = hlo;
            Q0ca = this.zero_fade_annual_time(dca, epsca, hca, f, K, phimn);
        } else {
            double dca = dlt;
            double epsca = Math.abs(thetat);
            double hca = Math.min(hts, hlt);
            double Q0cat = this.zero_fade_annual_time(dca, epsca, hca, f, K, phimn);
            dca = dlr;
            epsca = Math.abs(thetar);
            hca = Math.min(hrs, hlr);
            double Q0car = this.zero_fade_annual_time(dca, epsca, hca, f, K, phimn);
            Q0ca = Math.max(Q0cat, Q0car);
        }
        return Q0ca;
    }

    public double zero_fade_annual_time(double dca, double epsca, double hca, double f, double K, double phimn) {
        double Cg = 0.0;
        double qw = K * Math.pow(dca, 3.1) * Math.pow(1.0 + epsca, -1.29) * Math.pow(f, 0.8) * Math.pow(10.0, -8.9E-4 * hca);
        Cg = Math.abs(phimn) <= 45.0 ? 10.5 - 5.6 * Math.log10(1.1 + Math.pow(Math.abs(this.cosd(2.0 * phimn)), 0.7)) - 2.7 * Math.log10(dca) + 1.7 * Math.log10(1.0 + epsca) : 10.5 - 5.6 * Math.log10(1.1 - Math.pow(Math.abs(this.cosd(2.0 * phimn)), 0.7)) - 2.7 * Math.log10(dca) + 1.7 * Math.log10(1.0 + epsca);
        if (Cg > 10.8) {
            Cg = 10.8;
        }
        double Q0ca = qw * Math.pow(10.0, -0.1 * Cg);
        return Q0ca;
    }

    public double[] precipitation_fade_initial(P2001ver2DigitalMaps maps, double f, double q, double phi_n, double phi_e, double h_rainlo, double h_rainhi, double d_rain, int pol_hv) {
        int ngp;
        double[] P;
        double[] G;
        double alpha_mod;
        double kmod;
        double dr;
        double c;
        double b;
        double a;
        double Fwvr;
        double Q0ra;
        double flagrain;
        double Pr6 = maps.GetPr6(phi_e, phi_n);
        double Mt = maps.GetMt(phi_e, phi_n);
        double beta_rain = maps.GetBetaRain(phi_e, phi_n);
        double h0 = maps.GetH0(phi_e, phi_n);
        double hR = 360.0 + 1000.0 * h0;
        double hRtop = hR + 2400.0;
        if (Pr6 == 0.0 || h_rainlo >= hRtop) {
            flagrain = 0.0;
            Q0ra = 0.0;
            Fwvr = 0.0;
            a = 0.0;
            b = 0.0;
            c = 0.0;
            dr = 0.0;
            kmod = 0.0;
            alpha_mod = 0.0;
            G = new double[1];
            P = new double[1];
            G[0] = 0.0;
            P[0] = 0.0;
            ngp = 1;
        } else {
            double alpha;
            double k;
            double[] pp;
            flagrain = 1.0;
            double[] H = new double[]{-2400.0, -2300.0, -2200.0, -2100.0, -2000.0, -1900.0, -1800.0, -1700.0, -1600.0, -1500.0, -1400.0, -1300.0, -1200.0, -1100.0, -1000.0, -900.0, -800.0, -700.0, -600.0, -500.0, -400.0, -300.0, -200.0, -100.0, 0.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 1100.0, 1200.0, 1300.0, 1400.0, 1500.0, 1600.0, 1700.0, 1800.0, 1900.0, 2000.0, 2100.0, 2200.0, 2300.0, 2400.0};
            double[] Pi = new double[]{5.55E-4, 8.02E-4, 0.001139, 0.001594, 0.002196, 0.002978, 0.003976, 0.005227, 0.006764, 0.008617, 0.010808, 0.013346, 0.016225, 0.019419, 0.022881, 0.026542, 0.030312, 0.034081, 0.037724, 0.04111, 0.044104, 0.046583, 0.048439, 0.049589, 0.049978, 0.049589, 0.048439, 0.046583, 0.044104, 0.04111, 0.037724, 0.034081, 0.030312, 0.026542, 0.022881, 0.019419, 0.016225, 0.013346, 0.010808, 0.008617, 0.006764, 0.005227, 0.003976, 0.002978, 0.002196, 0.001594, 0.001139, 8.02E-4, 5.55E-4};
            double Mc = beta_rain * Mt;
            double Ms = (1.0 - beta_rain) * Mt;
            Q0ra = Pr6 * (1.0 - Math.exp(-0.0079 * Ms / Pr6));
            double a1 = 1.09;
            double b1 = (Mc + Ms) / (21797.0 * Q0ra);
            double c1 = 26.02 * b1;
            a = a1;
            b = b1;
            c = c1;
            double Qtran = Q0ra * Math.exp(a1 * (2.0 * b1 - c1) / (c1 * c1));
            double eps_rain = 0.001 * (h_rainhi - h_rainlo) / d_rain;
            if (f < 1.0) {
                pp = this.p838(1.0, eps_rain, pol_hv);
                double k1GHz = pp[0];
                double alpha1GHz = pp[1];
                k = f * k1GHz;
                alpha = alpha1GHz;
            } else {
                pp = this.p838(f, eps_rain, pol_hv);
                k = pp[0];
                alpha = pp[1];
            }
            dr = Math.min(d_rain, 300.0);
            double drmin = Math.max(dr, 1.0);
            kmod = Math.pow(1.763, alpha) * k * (0.6546 * Math.exp(-0.009516 * drmin) + 0.3499 * Math.exp(-0.001182 * drmin));
            alpha_mod = (0.753 + 0.197 / drmin) * alpha + 0.1572 * Math.exp(-0.02268 * drmin) - 0.1594 * Math.exp(-3.617E-4 * drmin);
            int nn = H.length;
            double[] Gm = new double[nn];
            double[] Pm = new double[nn];
            Gm[0] = 1.0;
            int m = 0;
            for (int n = 0; n < 49; ++n) {
                double hT = hR + H[n];
                if (h_rainlo >= hT) continue;
                if (h_rainhi > hT - 1200.0) {
                    Gm[m] = this.path_averaged_multiplier(h_rainlo, h_rainhi, hT);
                    Pm[m] = Pi[n];
                    if (n >= 48) continue;
                    ++m;
                    continue;
                }
                Pm[m] = Pm[m] + Pi[n];
                Gm[m] = 1.0;
            }
            int Mlen = m + 1;
            G = new double[Mlen];
            P = new double[Mlen];
            for (int n = 0; n < Mlen; ++n) {
                G[n] = Gm[n];
                P[n] = Pm[n];
            }
            ngp = Mlen;
            double Rwvr = 6.0 * (Math.log10(Q0ra / q) / Math.log10(Q0ra / Qtran)) - 3.0;
            double GP = 0.0;
            for (int n = 0; n < G.length; ++n) {
                GP += G[n] * P[n];
            }
            Fwvr = 0.5 * (1.0 + Math.tanh(Rwvr)) * GP;
        }
        double[] out = new double[2 * ngp + 10];
        out[0] = a;
        out[1] = b;
        out[2] = c;
        out[3] = dr;
        out[4] = Q0ra;
        out[5] = Fwvr;
        out[6] = kmod;
        out[7] = alpha_mod;
        out[8] = ngp;
        for (int i = 0; i < ngp; ++i) {
            out[9 + i] = G[i];
            out[9 + ngp + i] = P[i];
        }
        out[9 + 2 * ngp] = flagrain;
        return out;
    }

    public double[] p838(double f, double theta, int pol) {
        double tau = 0.0;
        tau = pol == 0 ? 0.0 : 1.5707963267948966;
        double[] aj_kh = new double[]{-5.3398, 0.35351, 0.23789, 0.94158};
        double[] bj_kh = new double[]{-0.10008, -1.2697, -0.86036, -0.64552};
        double[] cj_kh = new double[]{1.13098, 0.454, 0.15354, 0.16817};
        double m_kh = -0.18961;
        double c_kh = 0.71147;
        double[] aj_kv = new double[]{-3.80595, -3.44965, -0.39902, 0.50167};
        double[] bj_kv = new double[]{0.56934, -0.22911, 0.73042, 1.07319};
        double[] cj_kv = new double[]{0.81061, 0.51059, 0.11899, 0.27195};
        double m_kv = -0.16398;
        double c_kv = 0.63297;
        double[] aj_ah = new double[]{-0.14318, 0.29591, 0.32177, -5.3761, 16.1721};
        double[] bj_ah = new double[]{1.82442, 0.77564, 0.63773, -0.9623, -3.2998};
        double[] cj_ah = new double[]{-0.55187, 0.19822, 0.13164, 1.47828, 3.4399};
        double m_ah = 0.67849;
        double c_ah = -1.95537;
        double[] aj_av = new double[]{-0.07771, 0.56727, -0.20238, -48.2991, 48.5833};
        double[] bj_av = new double[]{2.3384, 0.95545, 1.1452, 0.791669, 0.791459};
        double[] cj_av = new double[]{-0.76284, 0.54039, 0.26809, 0.116226, 0.116479};
        double m_av = -0.053739;
        double c_av = 0.83433;
        double logkh = 0.0;
        for (int j = 0; j < aj_kh.length; ++j) {
            logkh += aj_kh[j] * Math.exp(-Math.pow((Math.log10(f) - bj_kh[j]) / cj_kh[j], 2.0));
        }
        logkh = logkh + m_kh * Math.log10(f) + c_kh;
        double kh = Math.pow(10.0, logkh);
        double logkv = 0.0;
        for (int j = 0; j < aj_kv.length; ++j) {
            logkv += aj_kv[j] * Math.exp(-Math.pow((Math.log10(f) - bj_kv[j]) / cj_kv[j], 2.0));
        }
        logkv = logkv + m_kv * Math.log10(f) + c_kv;
        double kv = Math.pow(10.0, logkv);
        double ah = 0.0;
        double av = 0.0;
        for (int j = 0; j < aj_ah.length; ++j) {
            ah += aj_ah[j] * Math.exp(-Math.pow((Math.log10(f) - bj_ah[j]) / cj_ah[j], 2.0));
            av += aj_av[j] * Math.exp(-Math.pow((Math.log10(f) - bj_av[j]) / cj_av[j], 2.0));
        }
        ah = ah + m_ah * Math.log10(f) + c_ah;
        av = av + m_av * Math.log10(f) + c_av;
        double k = (kh + kv + (kh - kv) * Math.pow(Math.cos(theta), 2.0) * Math.cos(2.0 * tau)) / 2.0;
        double alpha = (kh * ah + kv * av + (kh * ah - kv * av) * Math.pow(Math.cos(theta), 2.0) * Math.cos(2.0 * tau)) / (2.0 * k);
        double[] out = new double[]{k, alpha};
        return out;
    }

    public double path_averaged_multiplier(double hlo, double hhi, double hT) {
        int slo = (int)(1.0 + Math.floor((hT - hlo) / 100.0));
        int shi = (int)(1.0 + Math.floor((hT - hhi) / 100.0));
        if (slo < 1) {
            double G = 0.0;
            return G;
        }
        if (shi > 12) {
            double G = 1.0;
            return G;
        }
        if (slo == shi) {
            double G = this.multi_layer(0.5 * (hlo + hhi) - hT);
            return G;
        }
        double G = 0.0;
        int sfirst = Math.max(shi, 1);
        int slast = Math.min(slo, 12);
        double delh = 0.0;
        double Q = 0.0;
        for (int s = sfirst; s <= slast; ++s) {
            if (shi < s && s < slo) {
                delh = 100.0 * (0.5 - (double)s);
                Q = 100.0 / (hhi - hlo);
            } else if (s == slo) {
                delh = 0.5 * (hlo - hT - (double)(100 * (s - 1)));
                Q = (hT - (double)(100 * (s - 1)) - hlo) / (hhi - hlo);
            } else if (s == shi) {
                delh = 0.5 * (hhi - hT - (double)(100 * s));
                Q = (hhi - (hT - (double)(100 * s))) / (hhi - hlo);
            }
            double Gamma_slice = this.multi_layer(delh);
            G += Q * Gamma_slice;
        }
        if (slo > 12) {
            Q = (hT - 1200.0 - hlo) / (hhi - hlo);
            G += Q;
        }
        return G;
    }

    double multi_layer(double delh) {
        double Gamma;
        if (delh > 0.0) {
            Gamma = 0.0;
        } else if (delh < -1200.0) {
            Gamma = 1.0;
        } else {
            Gamma = 4.0 * Math.pow(1.0 - Math.exp(delh / 70.0), 2.0);
            Gamma /= 1.0 + Math.pow(1.0 - Math.exp(-Math.pow(delh / 600.0, 2.0)), 2.0) * (Gamma - 1.0);
        }
        return Gamma;
    }

    public double Aiter(double q, double Q0ca, double Q0ra, int flagtropo, double a, double b, double c, double dr, double kmod, double alpha_mod, double[] Gm, double[] Pm, int flagrain) {
        int count;
        double Ainit = 10.0;
        double Ahigh = Ainit / 2.0;
        double Alow = -Ainit / 2.0;
        double Astep = Ainit;
        double qhigh = this.Qiter(Ahigh, Q0ca, Q0ra, flagtropo, a, b, c, dr, kmod, alpha_mod, Gm, Pm, flagrain);
        double qlow = this.Qiter(Alow, Q0ca, Q0ra, flagtropo, a, b, c, dr, kmod, alpha_mod, Gm, Pm, flagrain);
        if (q < qhigh || q > qlow) {
            for (count = 0; count < 11; ++count) {
                if (!(q < qhigh)) continue;
                Alow = Ahigh;
                qlow = qhigh;
                Astep = 2.0 * Astep;
                qhigh = this.Qiter(Ahigh += Astep, Q0ca, Q0ra, flagtropo, a, b, c, dr, kmod, alpha_mod, Gm, Pm, flagrain);
            }
        }
        double Atry = 0.5 * (Alow + Ahigh);
        double Aacc = 0.01;
        int Niter = (int)Math.ceil(3.32 * Math.log10(Astep / Aacc));
        count = 0;
        while (count <= Niter) {
            ++count;
            double qtry = this.Qiter(Atry, Q0ca, Q0ra, flagtropo, a, b, c, dr, kmod, alpha_mod, Gm, Pm, flagrain);
            if (qtry < q) {
                Ahigh = Atry;
            } else {
                Alow = Atry;
            }
            Atry = 0.5 * (Alow + Ahigh);
        }
        return Atry;
    }

    public double Qiter(double Afade, double Q0ca, double Q0ra, int flagtropo, double a, double b, double c, double dr, double kmod, double alpha_mod, double[] Gm, double[] Pm, int flagrain) {
        double QrainA = this.precipitation_fade(Afade, a, b, c, dr, kmod, alpha_mod, Gm, Pm, flagrain);
        double QcafA = flagtropo == 0 ? this.clear_air_fade_surface(Afade, Q0ca) : this.clear_air_fade_tropo(Afade);
        return QrainA * (Q0ra / 100.0) + QcafA * (1.0 - Q0ra / 100.0);
    }

    public double precipitation_fade(double Afade, double a, double b, double c, double dr, double kmod, double alpha_mod, double[] Gm, double[] Pm, int flagrain) {
        double QrainA = 0.0;
        if (Afade < 0.0) {
            QrainA = 100.0;
        } else if (flagrain == 0) {
            QrainA = 0.0;
        } else {
            double drlim = Math.max(dr, 0.001);
            int n = Gm.length;
            QrainA = 0.0;
            for (int i = 0; i < n; ++i) {
                double Rm = Math.pow(Afade / (Gm[i] * drlim * kmod), 1.0 / alpha_mod);
                QrainA += 100.0 * (Pm[i] * Math.exp(-a * Rm * (b * Rm + 1.0) / (c * Rm + 1.0)));
            }
        }
        return QrainA;
    }

    public double clear_air_fade_surface(double A, double Q0ca) {
        double Qcaf;
        if (A >= 0.0) {
            double qt = 3.576 - 1.955 * Math.log10(Q0ca);
            double qa = 2.0 + (1.0 + 0.3 * Math.pow(10.0, -0.05 * A)) * Math.pow(10.0, -0.016 * A) * (qt + 4.3 * (Math.pow(10.0, -0.05 * A) + A / 800.0));
            Qcaf = 100.0 * (1.0 - Math.exp(-Math.pow(10.0, -0.05 * qa * A) * Math.log(2.0)));
        } else {
            double qs = -4.05 - 2.35 * Math.log10(Q0ca);
            double qe = 8.0 + (1.0 + 0.3 * Math.pow(10.0, 0.05 * A)) * Math.pow(10.0, 0.035 * A) * (qs + 12.0 * (Math.pow(10.0, 0.05 * A) - A / 800.0));
            Qcaf = 100.0 * Math.exp(-Math.pow(10.0, 0.05 * qe * A) * Math.log(2.0));
        }
        return Qcaf;
    }

    public double clear_air_fade_tropo(double A) {
        double Qcaftropo = A < 0.0 ? 100.0 : 0.0;
        return Qcaftropo;
    }

    private double tl_free_space(double f, double d) {
        return 92.44 + 20.0 * Math.log10(f) + 20.0 * Math.log10(d);
    }

    public double[] tl_anomalous_reflection(double f, double[] d, int[] z, double hts, double hrs, double htea, double hrea, double hm, double thetat, double thetar, double dlt, double dlr, double phimn, double omega, double ae, double p, double q) {
        double dlm;
        double tau;
        int nl = d.length;
        double dt = d[nl - 1] - d[0];
        int zoner = 34;
        double dtm = this.longest_cont_dist(d, z, zoner);
        double mu1 = Math.pow(Math.pow(10.0, -dtm / (16.0 - 6.6 * (tau = 1.0 - Math.exp(-4.12E-4 * Math.pow(dlm = this.longest_cont_dist(d, z, zoner = 4), 2.41))))) + Math.pow(10.0, -(2.48 + 1.77 * tau)), 0.2);
        if (mu1 > 1.0) {
            mu1 = 1.0;
        }
        double mu4 = Math.abs(phimn) <= 70.0 ? Math.pow(10.0, (-0.935 + 0.0176 * Math.abs(phimn)) * Math.log10(mu1)) : Math.pow(10.0, 0.3 * Math.log10(mu1));
        double b0 = Math.abs(phimn) <= 70.0 ? mu1 * mu4 * Math.pow(10.0, -0.015 * Math.abs(phimn) + 1.67) : 4.17 * mu1 * mu4;
        double gtr = 0.1 * dlt;
        double grr = 0.1 * dlr;
        double thetast = thetat - gtr;
        double thetasr = thetar - grr;
        double Ast = thetast > 0.0 ? 20.0 * Math.log10(1.0 + 0.361 * thetast * Math.sqrt(f * dlt)) + 0.264 * thetast * Math.pow(f, 0.3333333333333333) : 0.0;
        double Asr = thetasr > 0.0 ? 20.0 * Math.log10(1.0 + 0.361 * thetasr * Math.sqrt(f * dlr)) + 0.264 * thetasr * Math.pow(f, 0.3333333333333333) : 0.0;
        double[] dts = this.distance_to_sea(d, z);
        double dct = dts[0];
        double dcr = dts[1];
        double Act = 0.0;
        double Acr = 0.0;
        if (omega >= 0.75) {
            if (dct <= dlt && dct <= 5.0) {
                Act = -3.0 * Math.exp(-0.25 * dct * dct) * (1.0 + Math.tanh(0.07 * (50.0 - hts)));
            }
            if (dcr <= dlr && dcr <= 5.0) {
                Acr = -3.0 * Math.exp(-0.25 * dcr * dcr) * (1.0 + Math.tanh(0.07 * (50.0 - hrs)));
            }
        }
        double Alf = 0.0;
        if (f < 0.5) {
            Alf = (45.375 - 137.0 * f + 92.5 * f * f) * omega;
        }
        double Aac = 102.45 + 20.0 * Math.log10(f * (dlt + dlr)) + Alf + Ast + Asr + Act + Acr;
        double gammad = 5.0E-5 * ae * Math.pow(f, 0.3333333333333333);
        double theta_at = Math.min(thetat, gtr);
        double theta_ar = Math.min(thetar, grr);
        double theta_a = 1000.0 * dt / ae + theta_at + theta_ar;
        double Aad = gammad * theta_a;
        double dar = Math.min(dt - dlt - dlr, 40.0);
        double mu3 = hm > 10.0 ? Math.exp(-4.6E-5 * (hm - 10.0) * (43.0 + 6.0 * dar)) : 1.0;
        double alpha = -0.6 - 3.5E-9 * Math.pow(dt, 3.1) * tau;
        if (alpha < -3.4) {
            alpha = -3.4;
        }
        double mu2 = 500.0 * dt * dt / (ae * Math.pow(Math.sqrt(htea) + Math.sqrt(hrea), 2.0));
        if ((mu2 = Math.pow(mu2, alpha)) > 1.0) {
            mu2 = 1.0;
        }
        double bduct = b0 * mu2 * mu3;
        double Gamma = 1.076 * Math.exp(-1.0E-6 * Math.pow(dt, 1.13) * (9.51 - 4.8 * Math.log10(bduct) + 0.198 * Math.pow(Math.log10(bduct), 2.0))) / Math.pow(2.0058 - Math.log10(bduct), 1.012);
        double Aat = -12.0 + (1.2 + 0.0037 * dt) * Math.log10(p / bduct) + 12.0 * Math.pow(p / bduct, Gamma) + 50.0 / q;
        double Lba = Aac + Aad + Aat;
        double[] out = new double[]{Lba, Aat, Aad, Aac, dct, dcr, dtm, dlm};
        return out;
    }

    public double longest_cont_dist(double[] d, int[] zone, int zone_r) {
        double dm = 0.0;
        double dmc = 0.0;
        int n = d.length;
        if (zone_r == 34) {
            for (int i = 0; i < n; ++i) {
                if (zone[i] == 3 || zone[i] == 4) {
                    double delta = i == 0 ? (d[1] - d[0]) / 2.0 : (i == n - 1 ? (d[n - 1] - d[n - 2]) / 2.0 : (d[i + 1] - d[i - 1]) / 2.0);
                    dm = Math.max(dm, dmc += delta);
                    continue;
                }
                dmc = 0.0;
            }
            return dm;
        }
        for (int i = 0; i < n; ++i) {
            if (zone[i] == zone_r) {
                double delta = i == 0 ? (d[1] - d[0]) / 2.0 : (i == n - 1 ? (d[n - 1] - d[n - 2]) / 2.0 : (d[i + 1] - d[i - 1]) / 2.0);
                dm = Math.max(dm, dmc += delta);
                continue;
            }
            dmc = 0.0;
        }
        return dm;
    }

    public double[] distance_to_sea(double[] d, int[] zone) {
        double dcr;
        double dct;
        int i;
        int nl = d.length;
        int nt = -1;
        int nr = -1;
        for (i = 0; i < nl; ++i) {
            if (zone[i] != 1) continue;
            nt = i;
            break;
        }
        for (i = nl - 1; i >= 0; --i) {
            if (zone[i] != 1) continue;
            nr = i;
            break;
        }
        if (nt == -1 && nr == -1) {
            dct = d[nl - 1];
            dcr = d[nl - 1];
        } else {
            dct = nt == 0 ? 0.0 : (d[nt] + d[nt - 1]) / 2.0 - d[0];
            dcr = nr == nl - 1 ? 0.0 : d[nl - 1] - (d[nr] + d[nr + 1]) / 2.0;
        }
        double[] out = new double[]{dct, dcr};
        return out;
    }

    public double[] tl_troposcatter(P2001ver2DigitalMaps maps, double f, double dt, double thetat, double thetar, double thetae, double phicvn, double phicve, double phitn, double phite, double phirn, double phire, double Gt, double Gr, double ae, double p) {
        int eq;
        double gamma;
        double M;
        int climzone = maps.GetClimZone(phicve, phicvn);
        if (climzone == 0) {
            int climzoner = maps.GetClimZone(phire, phirn);
            int climzonet = maps.GetClimZone(phite, phitn);
            if (climzoner > 0 && climzonet > 0) {
                climzone = Math.min(climzoner, climzonet);
            } else if (climzonet > 0) {
                climzone = climzonet;
            } else if (climzoner > 0) {
                climzone = climzoner;
            }
        }
        if (climzone == 1) {
            M = 129.6;
            gamma = 0.33;
            eq = 8;
        } else if (climzone == 2) {
            M = 119.73;
            gamma = 0.27;
            eq = 6;
        } else if (climzone == 3) {
            M = 109.3;
            gamma = 0.32;
            eq = 9;
        } else if (climzone == 4) {
            M = 128.5;
            gamma = 0.27;
            eq = 10;
        } else if (climzone == 5) {
            M = 119.73;
            gamma = 0.27;
            eq = 6;
        } else if (climzone == 6) {
            M = 123.2;
            gamma = 0.27;
            eq = 6;
        } else {
            M = 116.0;
            gamma = 0.27;
            eq = 7;
        }
        double theta = 1000.0 * thetae + thetat + thetar;
        double H = 2.5E-4 * theta * dt;
        double htrop = 1.25E-7 * theta * theta * ae;
        double LN = 20.0 * Math.log10(5.0 + gamma * H) + 4.34 * gamma * htrop;
        double ds = 0.001 * theta * ae;
        double Y90 = 0.0;
        if (eq == 6) {
            Y90 = -2.2 - (8.1 - 0.23 * Math.min(f, 4.0)) * Math.exp(-0.137 * htrop);
        } else if (eq == 7) {
            Y90 = -9.5 - 3.0 * Math.exp(-0.137 * htrop);
        } else if (eq == 8) {
            Y90 = ds < 100.0 ? -8.2 : (ds >= 1000.0 ? -3.4 : 1.006E-8 * Math.pow(ds, 3.0) - 2.569E-5 * Math.pow(ds, 2.0) + 0.02242 * ds - 10.2);
        } else if (eq == 9) {
            Y90 = ds < 100.0 ? -10.845 : (ds >= 465.0 ? -8.4 : -4.5E-7 * Math.pow(ds, 3.0) + 4.45E-4 * Math.pow(ds, 2.0) - 0.122 * ds - 2.645);
        } else if (eq == 10) {
            Y90 = ds < 100.0 ? -11.5 : (ds >= 550.0 ? -4.0 : -8.519E-8 * Math.pow(ds, 3.0) + 7.444E-5 * Math.pow(ds, 2.0) - 4.18E-4 * ds - 12.1);
        }
        double C = p >= 50.0 ? 1.26 * Math.pow(-Math.log10((100.0 - p) / 50.0), 0.63) : -1.26 * Math.pow(-Math.log10(p / 50.0), 0.63);
        double Yp = C * Y90;
        if (theta < 1.0E-6) {
            theta = 1.0E-6;
        }
        double Ldist = Math.max(10.0 * Math.log10(dt) + 30.0 * Math.log10(theta) + LN, 20.0 * Math.log10(dt) + 0.573 * theta + 20.0);
        double Lfreq = 25.0 * Math.log10(f) - 2.5 * Math.pow(Math.log10(0.5 * f), 2.0);
        double Lcoup = 0.07 * Math.exp(0.055 * (Gt + Gr));
        double Lbs = M + Lfreq + Ldist + Lcoup - Yp;
        double[] out = new double[]{Lbs, theta, climzone};
        return out;
    }

    public double[] gaseous_abs_tropo_t2cv(double rho_sur, double h_sur, double theta_el, double dcv, double f) {
        double[] ssla = this.specific_sea_level_attenuation(f, rho_sur, h_sur);
        double gamma_o = ssla[0];
        double gamma_w = ssla[1];
        double rho_surr = this.water_vapour_density_rain(rho_sur, h_sur);
        double[] ssla1 = this.specific_sea_level_attenuation(f, rho_surr, h_sur);
        double gamma_wr = ssla1[1];
        double d0 = 0.65 * Math.sin(0.001 * theta_el) + 0.35 * Math.sqrt(Math.pow(Math.sin(0.001 * theta_el), 2.0) + 0.00304);
        d0 = 5.0 / d0;
        double dw = 0.65 * Math.sin(0.001 * theta_el) + 0.35 * Math.sqrt(Math.pow(Math.sin(0.001 * theta_el), 2.0) + 0.00122);
        dw = 2.0 / dw;
        double deo = d0 * (1.0 - Math.exp(-dcv / d0)) * Math.exp(-h_sur / 5000.0);
        double dew = dw * (1.0 - Math.exp(-dcv / dw)) * Math.exp(-h_sur / 2000.0);
        double Ao = gamma_o * deo;
        double Aw = gamma_w * dew;
        double Awr = gamma_wr * dew;
        double[] out = new double[]{Ao, Aw, Awr, gamma_o, gamma_w, gamma_wr};
        return out;
    }

    public double[] gaseous_abs_tropo(P2001ver2DigitalMaps maps, double phi_te, double phi_tn, double phi_re, double phi_rn, double h1, double hn, double thetatpos, double thetarpos, double dtcv, double drcv, double f) {
        double rho_sur;
        double Wvsurtx = rho_sur = maps.GetRhoSur(phi_te, phi_tn);
        double h_sur = h1;
        double theta_el = thetatpos;
        double dcv = dtcv;
        double[] gat2tcv = this.gaseous_abs_tropo_t2cv(rho_sur, h_sur, theta_el, dcv, f);
        double Aotcv = gat2tcv[0];
        double Awtcv = gat2tcv[1];
        double Awrtcv = gat2tcv[2];
        double Wvsurrx = rho_sur = maps.GetRhoSur(phi_re, phi_rn);
        h_sur = hn;
        theta_el = thetarpos;
        dcv = drcv;
        double[] gat2rcv = this.gaseous_abs_tropo_t2cv(rho_sur, h_sur, theta_el, dcv, f);
        double Aorcv = gat2rcv[0];
        double Awrcv = gat2rcv[1];
        double Awrrcv = gat2rcv[2];
        double Aos = Aotcv + Aorcv;
        double Aws = Awtcv + Awrcv;
        double Awrs = Awrtcv + Awrrcv;
        double[] out = new double[]{Aos, Aws, Awrs, Aotcv, Awtcv, Awrtcv, Aorcv, Awrcv, Awrrcv, Wvsurtx, Wvsurrx};
        return out;
    }

    double[] tl_sporadic_e(P2001ver2DigitalMaps maps, double f, double dt, double thetat, double thetar, double phimn, double phime, double phitn, double phite, double phirn, double phire, double dlt, double dlr, double ae, double Re, double p) {
        double p2;
        double p1;
        if (p < 1.0) {
            p1 = 0.1;
            p2 = 1.0;
        } else if (p > 10.0) {
            p1 = 10.0;
            p2 = 50.0;
        } else {
            p1 = 1.0;
            p2 = 10.0;
        }
        double foes1 = maps.GetFoEs(phime, phimn, p1);
        double foes2 = maps.GetFoEs(phime, phimn, p2);
        double FoEs1hop = foes1 + (foes2 - foes1) * Math.log10(p / p1) / Math.log10(p2 / p1);
        double Gamma1 = (40.0 / (1.0 + dt / 130.0 + Math.pow(dt / 250.0, 2.0)) + 0.2 * Math.pow(dt / 2600.0, 2.0)) * Math.pow(1000.0 * f / FoEs1hop, 2.0) + Math.exp((dt - 1660.0) / 280.0);
        double hes = 120.0;
        double l1 = 2.0 * Math.pow(Math.pow(ae, 2.0) + Math.pow(ae + hes, 2.0) - 2.0 * ae * (ae + hes) * Math.cos(dt / (2.0 * ae)), 0.5);
        double Lbfs1 = this.tl_free_space(f, l1);
        double alpha1 = dt / (2.0 * ae);
        double epsr1 = 1.5707963267948966 - Math.atan(ae * Math.sin(alpha1) / (hes + ae * (1.0 - Math.cos(alpha1)))) - alpha1;
        double delta1t = 0.001 * thetat - epsr1;
        double delta1r = 0.001 * thetar - epsr1;
        double nu1t = delta1t >= 0.0 ? 3.651 * Math.sqrt(1000.0 * f * dlt * (1.0 - Math.cos(delta1t)) / Math.cos(0.001 * thetat)) : -3.651 * Math.sqrt(1000.0 * f * dlt * (1.0 - Math.cos(delta1t)) / Math.cos(0.001 * thetat));
        double nu1r = delta1r >= 0.0 ? 3.651 * Math.sqrt(1000.0 * f * dlr * (1.0 - Math.cos(delta1r)) / Math.cos(0.001 * thetar)) : -3.651 * Math.sqrt(1000.0 * f * dlr * (1.0 - Math.cos(delta1r)) / Math.cos(0.001 * thetar));
        double Lp1t = this.dl_knife_edge(nu1t);
        double Lp1r = this.dl_knife_edge(nu1r);
        double Lbes1 = Lbfs1 + Gamma1 + Lp1t + Lp1r;
        double d1q = 0.25 * dt;
        double[] gcp = this.great_circle_path(phire, phite, phirn, phitn, Re, d1q);
        double Phi1qe = gcp[0];
        double Phi1qn = gcp[1];
        double d3q = 0.75 * dt;
        double[] gcp3 = this.great_circle_path(phire, phite, phirn, phitn, Re, d3q);
        double Phi3qe = gcp3[0];
        double Phi3qn = gcp3[1];
        double phie = Phi1qe;
        double phin = Phi1qn;
        foes1 = maps.GetFoEs(phie, phin, p1);
        foes2 = maps.GetFoEs(phie, phin, p2);
        double FoEs2hop1q = foes1 + (foes2 - foes1) * Math.log10(p / p1) / Math.log10(p2 / p1);
        phie = Phi3qe;
        phin = Phi3qn;
        foes1 = maps.GetFoEs(phie, phin, p1);
        foes2 = maps.GetFoEs(phie, phin, p2);
        double FoEs2hop3q = foes1 + (foes2 - foes1) * Math.log10(p / p1) / Math.log10(p2 / p1);
        double FoEs2hop = Math.min(FoEs2hop1q, FoEs2hop3q);
        double Gamma2 = (40.0 / (1.0 + dt / 260.0 + Math.pow(dt / 500.0, 2.0)) + 0.2 * Math.pow(dt / 5200.0, 2.0)) * Math.pow(1000.0 * f / FoEs2hop, 2.0) + Math.exp((dt - 3220.0) / 560.0);
        double l2 = 4.0 * Math.pow(ae * ae + Math.pow(ae + hes, 2.0) - 2.0 * ae * (ae + hes) * Math.cos(dt / (4.0 * ae)), 0.5);
        double Lbfs2 = this.tl_free_space(f, l2);
        double alpha2 = dt / (4.0 * ae);
        double epsr2 = 1.5707963267948966 - Math.atan(ae * Math.sin(alpha2) / (hes + ae * (1.0 - Math.cos(alpha2)))) - alpha2;
        double delta2t = 0.001 * thetat - epsr2;
        double delta2r = 0.001 * thetar - epsr2;
        double nu2t = delta2t >= 0.0 ? 3.651 * Math.sqrt(1000.0 * f * dlt * (1.0 - Math.cos(delta2t)) / Math.cos(0.001 * thetat)) : -3.651 * Math.sqrt(1000.0 * f * dlt * (1.0 - Math.cos(delta2t)) / Math.cos(0.001 * thetat));
        double nu2r = delta2r >= 0.0 ? 3.651 * Math.sqrt(1000.0 * f * dlr * (1.0 - Math.cos(delta2r)) / Math.cos(0.001 * thetar)) : -3.651 * Math.sqrt(1000.0 * f * dlr * (1.0 - Math.cos(delta2r)) / Math.cos(0.001 * thetar));
        double Lp2t = this.dl_knife_edge(nu2t);
        double Lp2r = this.dl_knife_edge(nu2r);
        double Lbes2 = Lbfs2 + Gamma2 + Lp2t + Lp2r;
        double Lbe = Lbes1 < Lbes2 - 20.0 ? Lbes1 : (Lbes2 < Lbes1 - 20.0 ? Lbes2 : -10.0 * Math.log10(Math.pow(10.0, -0.1 * Lbes1) + Math.pow(10.0, -0.1 * Lbes2)));
        double[] out = new double[]{Lbe, Lbes1, Lbes2, Lp1t, Lp2t, Lp1r, Lp2r, Gamma1, Gamma2, FoEs1hop, FoEs2hop, Phi1qe, Phi1qn, Phi3qe, Phi3qn};
        return out;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R P.2001-2", "<b><u>Frequency range:</u></b><br>about 30 MHz to 50 GHz<br><b><u>Distance range:</u></b><br>Most accurate between 3 km to at least 1 000 km, no specific lower limit<br><b><u>Typical application area:</u></b><br>Wide range prediction method for the evaluation of interference between stations on the surface of the Earth, accounting for signal enhancements and fading mechanisms over the range from 0% to 100% of an average year. Note that only flat terrain (h = 0 masl) and inland paths are considered at the moment.");
    }
}

