/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.plugin.propagation.PCLUTTERInput;
import org.seamcat.model.simulation.result.LinkResult;

public class PCLUTTER {
    public double evaluate(LinkResult linkResult, boolean variations, PCLUTTERInput input) {
        double fMHz = linkResult.getFrequency();
        double Dt = linkResult.getTxRxDistance();
        double h1 = linkResult.txAntenna().getHeight();
        double h2 = linkResult.rxAntenna().getHeight();
        double StdDev = 0.0;
        double f = fMHz / 1000.0;
        double R = 0.0;
        double ws = 0.0;
        int eqnum = 1;
        double Lctt = 0.0;
        double theta = 0.0;
        double d = Dt;
        if (input.clutter1()) {
            if (input.clutter1Tx()) {
                R = input.Environment_Tx().R();
                eqnum = input.Environment_Tx().eqnum();
                if (input.userSpecifiedClutterTx()) {
                    R = input.clutterHeightTx().getValue();
                    ws = input.wsTx().getValue();
                }
                Lctt += this.cl_loss1(f, h1, eqnum, R, ws);
            }
            if (input.clutter1Rx()) {
                R = input.Environment_Rx().R();
                eqnum = input.Environment_Rx().eqnum();
                if (input.userSpecifiedClutterRx()) {
                    R = input.clutterHeightRx().getValue();
                    ws = input.wsRx().getValue();
                }
                Lctt += this.cl_loss1(f, h1, eqnum, R, ws);
            }
        } else if (input.clutter2()) {
            double p = input.locPercentage2().trial();
            if (input.clutter32Tx()) {
                Lctt += this.cl_loss2(f, d, p);
            }
            if (input.clutter32Rx()) {
                Lctt += this.cl_loss2(f, d, p);
            }
        } else {
            double p = input.locPercentage3().trial();
            theta = input.theta().trial();
            Lctt += this.cl_loss3(f, theta, p);
        }
        return Lctt;
    }

    public double cl_loss1(double f, double h, int eqnum, double R, double ws) {
        double Ah = 0.0;
        if (h >= R) {
            Ah = 0.0;
            return Ah;
        }
        double Knu = 0.342 * Math.sqrt(f);
        double Kh2 = 21.8 + 6.2 * Math.log10(f);
        double hdif = R - h;
        double theta_c = Math.atan(hdif / ws) * 180.0 / Math.PI;
        double nu = Knu * Math.sqrt(hdif * theta_c);
        if (eqnum == 2) {
            Ah = -Kh2 * Math.log10(h / R);
        } else {
            double J = 0.0;
            if (nu > -0.78) {
                J = 6.9 + 20.0 * Math.log10(Math.sqrt(Math.pow(nu - 0.1, 2.0) + 1.0) + nu - 0.1);
            }
            Ah = J - 6.03;
        }
        return Ah;
    }

    public double cl_loss2(double f, double d, double p) {
        if (f < 2.0 || f > 67.0) {
            throw new RuntimeException("Frequency is outside of the valid domain [2, 67] GHz");
        }
        if (p <= 0.0 || p >= 100.0) {
            throw new RuntimeException("Percentage of locations is outside of the valid domain (0, 100) %");
        }
        double Ll = 23.5 + 9.6 * Math.log10(f);
        double Ls = 32.98 + 23.9 * Math.log10(d) + 3.0 * Math.log10(f);
        double Lctt = -5.0 * Math.log10(Math.pow(10.0, -0.2 * Ll) + Math.pow(10.0, -0.2 * Ls)) - 6.0 * this.norminv(1.0 - p / 100.0, 0.0, 1.0);
        return Lctt;
    }

    public double cl_loss3(double f, double th, double p) {
        if (f < 10.0 || f > 100.0) {
            throw new RuntimeException("Frequency is outside of the valid domain [10, 100] GHz");
        }
        if (th < 0.0 || th > 90.0) {
            throw new RuntimeException("Elevation angle is outside of the valid domain [0, 90] degrees");
        }
        if (p <= 0.0 || p >= 100.0) {
            throw new RuntimeException("Percentage of locations is outside of the valid domain (0, 100)");
        }
        double K1 = 93.0 * Math.pow(f, 0.175);
        double A1 = 0.05;
        double L1 = -K1 * Math.log(1.0 - p / 100.0);
        double L2 = 1.0 / Math.tan(A1 * (1.0 - th / 90.0) + Math.PI * th / 180.0);
        double Lces = Math.pow(L1 * L2, 0.5 * (90.0 - th) / 90.0) - 1.0 - 0.6 * this.norminv(1.0 - p / 100.0, 0.0, 1.0);
        return Lces;
    }

    private double norminv(double p, double mu, double sigma) {
        double y = mu + sigma * this.Qi(1.0 - p);
        return y;
    }

    private double Qi(double x) {
        double out = x <= 0.5 ? this.T(x) - this.C(x) : -(this.T(1.0 - x) - this.C(1.0 - x));
        return out;
    }

    private double T(double y) {
        double outT = Math.sqrt(-2.0 * Math.log(y));
        return outT;
    }

    private double C(double z) {
        double C0 = 2.515517;
        double C1 = 0.802853;
        double C2 = 0.010328;
        double D1 = 1.432788;
        double D2 = 0.189269;
        double D3 = 0.001308;
        double outC = ((C2 * this.T(z) + C1) * this.T(z) + C0) / (((D3 * this.T(z) + D2) * this.T(z) + D1) * this.T(z) + 1.0);
        return outC;
    }
}

