/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation;

import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.propagation.LongleyRice_mod;
import org.seamcat.model.propagation.Param2;
import org.seamcat.model.propagation.Param_att;
import org.seamcat.model.propagation.Param_tmp;

class Strefa3 {
    Strefa3() {
    }

    public static double FORTRAN_DIM(double x, double y) {
        if (x > y) {
            return x - y;
        }
        return 0.0;
    }

    public static double ahd(double td) {
        double[] a = new double[]{133.4, 104.6, 71.8};
        double[] b = new double[]{3.32E-4, 2.12E-4, 1.57E-4};
        double[] c = new double[]{-4.343, -1.086, 2.171};
        int i = td <= 10000.0 ? 0 : (td <= 70000.0 ? 1 : 2);
        return a[i] + b[i] * td + c[i] * Math.log(td);
    }

    public static double h0f(double r, double et) {
        double q;
        double[] a = new double[]{25.0, 80.0, 177.0, 395.0, 705.0};
        double[] b = new double[]{24.0, 45.0, 68.0, 80.0, 105.0};
        int it = (int)et;
        if (it <= 0) {
            it = 1;
            q = 0.0;
        } else if (it >= 5) {
            it = 5;
            q = 0.0;
        } else {
            q = et - (double)it;
        }
        double x = Math.pow(1.0 / r, 2.0);
        double h0fv = 4.343 * Math.log((a[it - 1] * x + b[it - 1]) * x + 1.0);
        if (q != 0.0) {
            h0fv = (1.0 - q) * h0fv + q * 4.343 * Math.log((a[it] * x + b[it]) * x + 1.0);
        }
        return h0fv;
    }

    public static double Acsat(double d, Param_tmp param_tmp, Param2 param2) {
        double ascatv;
        if (Mathematics.equals(d, 0.0, 1.0E-4)) {
            param_tmp.ad = param2.dl1 - param2.dl2;
            param_tmp.rr = param2.he2 / param2.he1;
            if (param_tmp.ad < 0.0) {
                param_tmp.ad = -param_tmp.ad;
                param_tmp.rr = 1.0 / param_tmp.rr;
            }
            param_tmp.etq = (5.67E-6 * (double)LongleyRice_mod.input.meanSurface() - 0.00232) * (double)LongleyRice_mod.input.meanSurface() + 0.031;
            param_tmp.h0s = -15.0;
            ascatv = 0.0;
        } else {
            double th;
            double h0;
            if (param_tmp.h0s > 15.0) {
                h0 = param_tmp.h0s;
            } else {
                th = param2.teta_e1 + param2.teta_e2 + d * param2.a;
                double r2 = 2.0 * param2.k * th;
                double r1 = r2 * param2.he1;
                r2 *= param2.he2;
                if (r1 < 0.2 && r2 < 0.2) {
                    return 1001.0;
                }
                double ss = (d - param_tmp.ad) / (d + param_tmp.ad);
                double q = param_tmp.rr / ss;
                ss = Math.max(0.1, ss);
                q = Math.min(Math.max(0.1, q), 10.0);
                double z0 = (d - param_tmp.ad) * (d + param_tmp.ad) * th * 0.25 / d;
                double et = (param_tmp.etq * Math.exp(-Math.pow(Math.min(1.7, z0 / 8000.0), 6.0)) + 1.0) * z0 / 1755.6;
                double ett = Math.max(et, 1.0);
                h0 = (Strefa3.h0f(r1, ett) + Strefa3.h0f(r2, ett)) * 0.5;
                h0 += Math.min(h0, (1.38 - Math.log(ett)) * Math.log(ss) * Math.log(q) * 0.49);
                h0 = Strefa3.FORTRAN_DIM(h0, 0.0);
                if (et < 1.0) {
                    h0 = et * h0 + (1.0 - et) * 4.343 * Math.log(Math.pow((1.0 + 1.4142 / r1) * (1.0 + 1.4142 / r2), 2.0) * (r1 + r2) / (r1 + r2 + 2.8284));
                }
                if (h0 > 15.0 && param_tmp.h0s >= 0.0) {
                    h0 = param_tmp.h0s;
                }
            }
            param_tmp.h0s = h0;
            th = param2.teta_e + d * param2.a;
            ascatv = Strefa3.ahd(th * d) + 4.343 * Math.log(47.7 * param2.k * Math.pow(th, 4.0)) - 0.1 * ((double)LongleyRice_mod.input.meanSurface() - 301.0) * Math.exp(-th * d / 40000.0) + h0;
        }
        return ascatv;
    }

    void strefa3(Param_att param_att, Param2 param2, Param_tmp param_tmp) {
        double d5 = param2.dl + 200000.0;
        double d6 = d5 + 200000.0;
        double q = Strefa3.Acsat(0.0, param_tmp, param2);
        double A5 = Strefa3.Acsat(d5, param_tmp, param2);
        double A6 = Strefa3.Acsat(d6, param_tmp, param2);
        if (A5 < 1000.0) {
            param_att.ms = (A6 - A5) / 200000.0;
            param_att.dx = Math.max(param2.dls, Math.max(param2.dl + 0.3 * param2.Xae * Math.log(47.7 * param2.k), (A5 - param_att.Aed - param_att.ms * d5) / (param_att.md - param_att.ms)));
            param_att.Aes = (param_att.md - param_att.ms) * param_att.dx + param_att.Aed;
        } else {
            param_att.ms = param_att.md;
            param_att.Aes = param_att.Aed;
            param_att.dx = 1.0E7;
        }
    }
}

