/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.propagation.p528;

import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.plugin.propagation.P528Input;
import org.seamcat.model.plugin.propagation.PropagationModelPlugin;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.propagation.PluginCheckUtilsToBeRemoved;
import org.seamcat.model.propagation.p528.impl.P528_Interpol;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.types.Description;
import org.seamcat.model.types.result.DescriptionImpl;

public class P528PropagationModel
implements PropagationModelPlugin<P528Input> {
    @Override
    public void consistencyCheck(ConsistencyCheckContext context, P528Input input, Validator validator) {
        double TimePercentage;
        double distance;
        double h;
        if (context.getOrigin() == Origin.EPP) {
            return;
        }
        Bounds bounds = null;
        Bounds rB = null;
        Bounds tB = null;
        bounds = context.getFrequency().getBounds();
        rB = context.getRxSettings().getHeight();
        tB = context.getTxSettings().getHeight();
        if (bounds.getMin() < 125.0) {
            validator.error("ITU-R P.528 model not applicable below 125 MHz" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if (bounds.getMax() > 15500.0) {
            validator.error("ITU-R P.528 model not applicable above 15.5 GHz" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if ((h = Math.min(rB.getMin(), tB.getMin())) < 1.5) {
            validator.error("ITU-R P.528 model not applicable for antenna height below 1.5 m" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if (h > 1000.0) {
            validator.error("ITU-R P.528 model not applicable for ground antenna height above 1 000 m" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if ((h = Math.max(rB.getMax(), tB.getMax())) > 20000.0) {
            validator.error("ITU-R P.528 model not applicable for aero antenna height above 20 000 m - Please make use of Free Space Model" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if (h < 1000.0) {
            validator.error("ITU-R P.528 model not applicable for aero antenna height below 1 000 m - Please make use of Longley Rice Model" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if ((distance = context.getCoverage().getMax()) > 1800.0) {
            validator.error("Distance out of range : should be less than 1 800 km" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
        if ((TimePercentage = input.TimePercentage()) < 1.0 || TimePercentage > 95.0) {
            validator.error("Time percentage outside the range 1 ... 95 %" + PluginCheckUtilsToBeRemoved.getExceptionHint());
        }
    }

    @Override
    public double evaluate(LinkResult linkResult, boolean variations, P528Input input) {
        double loss = 0.0;
        double frequency = linkResult.getFrequency();
        double distance = linkResult.getTxRxDistance();
        double HTx = linkResult.txAntenna().getHeight();
        double HRx = linkResult.rxAntenna().getHeight();
        if (frequency < 125.0) {
            throw new RuntimeException("ITU-R P.528 model not applicable below 125 MHz");
        }
        if (frequency > 15500.0) {
            throw new RuntimeException("ITU-R P.528 model not applicable above 15.5 GHz");
        }
        double h = Math.min(HTx, HRx);
        if (h < 1.5) {
            throw new RuntimeException("ITU-R P.528 model not applicable for antenna height below 1.5 m");
        }
        if (h > 1000.0) {
            throw new RuntimeException("ITU-R P.528 model not applicable for ground antenna height above 1 000 m");
        }
        h = Math.max(HTx, HRx);
        if (h > 20000.0) {
            throw new RuntimeException("ITU-R P.528 model not applicable for aero antenna height above 20 000 m - Please make use of Free Space Model");
        }
        if (h < 1000.0) {
            throw new RuntimeException("ITU-R P.528 model not applicable for aero antenna height below 1 000 m - Please make use of Longley Rice Model");
        }
        double TimePercentage = input.TimePercentage();
        if (TimePercentage < 1.0 || TimePercentage > 95.0) {
            throw new IllegalArgumentException("Time percentage outside the range 1 ... 95 %");
        }
        if (distance > 1800.0) {
            throw new IllegalArgumentException("Distance out of range : should be less than 1 800 km");
        }
        loss = P528_Interpol.PerteP528(HTx, HRx, distance, frequency, TimePercentage);
        if (variations) {
            loss += Factory.distributionFactory().getGaussianDistribution(0.0, input.stdDev()).trial();
        }
        return loss;
    }

    @Override
    public Description description() {
        return new DescriptionImpl("ITU-R P.528", "ITU-R P.528 - Qt in the range [1-95]%");
    }
}

