/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.simulation.consistency;

import java.lang.reflect.Method;
import java.util.List;
import org.seamcat.model.plugin.Config;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.simulation.consistency.ConsistencyError;
import org.seamcat.model.simulation.consistency.ValidationResult;
import org.seamcat.model.types.Configuration;

public class PluginValidator {
    public static void plugin(ConsistencyCheckContext context, List<ConsistencyError> results, Configuration conf, String path) {
        PluginValidator.appendErrors(conf.consistencyCheck(context), path, results);
        Class modelClass = conf.getModelClass();
        for (Method method : modelClass.getDeclaredMethods()) {
            Class<?> returnType = method.getReturnType();
            if (!Configuration.class.isAssignableFrom(returnType)) continue;
            String name = path + "->" + method.getName();
            Config annotation = method.getAnnotation(Config.class);
            if (annotation != null) {
                name = path + "->" + annotation.name();
            }
            try {
                Configuration nestedConf = (Configuration)method.invoke(conf.getModel(), new Object[0]);
                PluginValidator.plugin(context, results, nestedConf, name);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void appendErrors(ValidationResult result, String path, List<ConsistencyError> results) {
        for (String message : result.getModelErrors()) {
            results.add(new ConsistencyError(path, message));
        }
    }
}

