/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.aggregate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.systems.aggregate.AggregateSectorShapes;
import org.seamcat.model.systems.aggregate.AggregateSimulationInstance;
import org.seamcat.model.systems.aggregate.SystemModelAggregate;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;

public class AggregateSystemPlugin
implements SystemPlugin<SystemModelAggregate> {
    private SystemModelAggregate ui;
    private int victimSystemIndex;
    private Map<InterferenceLink, Integer> iLinkMap = new HashMap<InterferenceLink, Integer>();

    public void addComponent(SystemPlugin component) {
        this.ui.tab().components().components().add(component);
    }

    public List<SystemPlugin> getComponents() {
        return this.ui.tab().components().components();
    }

    public void selectVictim(SystemPlugin system) {
        this.victimSystemIndex = this.getComponents().indexOf(system);
    }

    public void setInterferenceLinkIndex(InterferenceLink link) {
        this.iLinkMap.put(link, this.getComponents().indexOf(link.getInterferer().getSystemPlugin()));
    }

    int getVictimSystemIndex() {
        return this.victimSystemIndex;
    }

    int getInterferenceLinkSystemIndex(InterferenceLink link) {
        return this.iLinkMap.get(link);
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        throw new RuntimeException("Aggregate system cannot be part of a simulation");
    }

    @Override
    public Bounds getSystemCoverage() {
        throw new RuntimeException("Aggregate system cannot be part of a simulation");
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        throw new RuntimeException("Aggregate system cannot be part of a simulation");
    }

    @Override
    public void setUI(SystemModelAggregate ui) {
        this.ui = ui;
    }

    @Override
    public SystemModelAggregate getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        throw new RuntimeException("Aggregate system cannot be part of a simulation");
    }

    @Override
    public RadioSystem getSystem(Context context) {
        throw new RuntimeException("Aggregate system cannot be part of a simulation");
    }

    @Override
    public void preSimulation(Context context, Results results) {
        throw new RuntimeException("Aggregate system cannot be part of a simulation");
    }

    @Override
    public void postSimulation(Context context, Results results) {
        throw new RuntimeException("Aggregate system cannot be part of a simulation");
    }

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces sectorShapes) {
        return new AggregateSimulationInstance(context, this, sectorShapes);
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        ArrayList<SystemSpaces> systemSpaces = new ArrayList<SystemSpaces>();
        SystemSpaces previous = null;
        for (SystemPlugin plugin : this.getComponents()) {
            SystemSpaces spaces = plugin.generateSystemSpaces(previous);
            systemSpaces.add(spaces);
            previous = spaces;
        }
        return new AggregateSectorShapes((List<SystemSpaces>)systemSpaces);
    }
}

