/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.InnerPlacementBoundaryCalculator;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.Polygon2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.NoFeasibleShapesException;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.SectorPropertyDescription;
import org.seamcat.model.plugin.system.optional.SectorPropertyType;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkConsistencyCheck;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkMicroSimulation;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020DownLinkGeneralSettings;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020DownLinkMicroGeneralTab;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020DownLinkTransmitterUI;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MicroBaseStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Mobile;
import org.seamcat.model.systems.imt2020downlink.ui.SystemModelIMT2020DownLinkMicro;
import org.seamcat.model.systems.ofdma.ReceiverSettings;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.cellular.PathLossCorrelation;

public class IMT2020DownLinkMicroSystemPlugin
implements SystemPlugin<SystemModelIMT2020DownLinkMicro> {
    private SystemModelIMT2020DownLinkMicro ui;
    private RadioSystem system;
    private IMT2020Settings settings;
    public static final SectorPropertyDescription MICRO = new SectorPropertyDescription("Micro BS Cluster");
    public static final SectorPropertyDescription MACRO_CELL = new SectorPropertyDescription("Macro Cell Sector");

    public IMT2020Settings getSettings() {
        return this.settings;
    }

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        IMT2020DownLinkConsistencyCheck.checkMicroSystem(scenario, context, validator);
        if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            IMT2020DownLinkConsistencyCheck.checkPathLossCorrelationInterferer(context, validator);
        }
    }

    @Override
    public Bounds getSystemCoverage() {
        return new Bounds(0.0, 2.5 * this.ui.positioning().microBS().clusterRadius(), true);
    }

    @Override
    public void setUI(SystemModelIMT2020DownLinkMicro ui) {
        this.ui = ui;
    }

    @Override
    public SystemModelIMT2020DownLinkMicro getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        IMT2020Mobile ms;
        IMT2020Mobile mobile = ms = this.ui.positioning().mobile();
        IMT2020DownLinkMicroGeneralTab general = this.ui.generalSettings();
        IMT2020DownLinkGeneralSettings gen = general.generalSettings();
        ReceiverSettings rx = general.receiverSettings();
        Receiver receiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersMs() / 1000.0, Factory.results().convert(general.localEnvironments().receiverEnvironments()), mobile.antennaGain(), mobile.antennaHeight());
        IMT2020MicroBaseStation bs = this.ui.positioning().microBS();
        IMT2020DownLinkTransmitterUI tx = general.transmitterSettings();
        Transmitter transmitter = new Transmitter(tx.emissionMask(), tx.emissionFloor().getValue(), tx.emissionFloor().isRelevant(), gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersBs() / 1000.0, null, Factory.results().convert(general.localEnvironments().transmitterEnvironments()), bs.antennaGain(), bs.antennaHeight(), 0.0, false);
        this.system = new RadioSystem(receiver, transmitter, this.ui.positioning().propagationModel());
        PathLossCorrelationUI plUI = general.pathLossCorrelation();
        PathLossCorrelation pl = new PathLossCorrelation(plUI.usePathLossCorrelation(), plUI.pathLossVariance(), plUI.correlationFactor());
        this.settings = new IMT2020Settings(this.system, gen, pl, general.transmitterSettings().bsTransmitPower(), this.system.getTransmitter().getHeight(), ms.azimuth(), ms.azimuthOffset(), ms.elevation(), ms.elevationOffset(), bs.azimuth(), bs.azimuthOffset(), bs.elevation(), bs.elevationOffset());
        this.settings.setBsGain(this.system.getTransmitter().getAntennaGain());
    }

    @Override
    public RadioSystem getSystem(Context context) {
        return this.system;
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        VectorSpace range = VectorSpace.ZERO;
        range.addCircle(this.getSystemCoverage());
        return range;
    }

    @Override
    public void preSimulation(Context context, Results results) {
        double frequency = context.getFrequency().trial();
        results.getSingleValueTypes().add(new DoubleResultType(IMT2020DownLinkSystemPlugin.SIMULATION_FREQUENCY, frequency));
        double bw = this.system.getTransmitter().getBandwidth();
        UniformDistribution freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        context.getSystemPlugin().setFrequency(freq);
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            double avgBitRateLossRefCell = Mathematics.calculateAvgPercentage(results.findVector(IMT2020DownLinkSystemPlugin.AchievedBitRateRefCell), results.findVector(IMT2020DownLinkSystemPlugin.InterferedBitRateRefCell));
            results.getSingleValueTypes().add(new DoubleResultType(IMT2020DownLinkSystemPlugin.AVGBitrateLossRefCell, avgBitRateLossRefCell));
            double avgBitRateLossSystem = Mathematics.calculateAvgPercentage(results.findVector(IMT2020DownLinkSystemPlugin.AVGAchievedBitRateSystem), results.findVector(IMT2020DownLinkSystemPlugin.AVGInterferedBitRateSystem));
            results.getSingleValueTypes().add(new DoubleResultType(IMT2020DownLinkSystemPlugin.AVGBitrateLossSystem, avgBitRateLossSystem));
        }
    }

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces shapes) {
        return new IMT2020DownLinkMicroSimulation(this, shapes);
    }

    public int numberOfMicroClusters() {
        return this.ui.positioning().microBS().cellClusters();
    }

    public int numberOfBSInMicroClusters() {
        return this.ui.positioning().microBS().microBSPerCluster();
    }

    public double getClusterRadius() {
        return this.ui.positioning().microBS().clusterRadius();
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        ArrayList<Space> spaces = new ArrayList<Space>();
        if (enclosing == null) {
            double ueCircle = 3.5 * this.getClusterRadius();
            Polygon2D rxSector = PolygonUtil.convertCircle(ueCircle, 0.0, 6, new Bounds(0.0, 360.0, true));
            spaces.add(new Space(rxSector, true, MACRO_CELL));
            Polygon2D inner = PolygonUtil.convertCircle(this.getClusterRadius(), 0.0, 16, new Bounds(0.0, 360.0, true));
            Polygon2D feasibleInnerCircle = InnerPlacementBoundaryCalculator.innerPlacementBoundary(rxSector, inner);
            IMT2020DownLinkMicroSystemPlugin.addClustersForCell(feasibleInnerCircle, spaces, MICRO, SectorPropertyType.REFERENCE_CELL, inner, this.getClusterRadius(), this.numberOfMicroClusters(), false);
        } else {
            Polygon2D sampleMicroCluster = PolygonUtil.convertCircle(this.getClusterRadius(), 0.0, 16, new Bounds(0.0, 360.0, true));
            for (Space rxSpace : enclosing.getRxSpaces()) {
                spaces.add(rxSpace);
                boolean refCell = rxSpace.hasProperty(SectorPropertyType.REFERENCE_CELL);
                SectorPropertyType type = refCell ? SectorPropertyType.REFERENCE_CELL : SectorPropertyType.CELL;
                try {
                    Polygon2D feasibleInner = InnerPlacementBoundaryCalculator.innerPlacementBoundary(rxSpace.getSpace(), sampleMicroCluster);
                    IMT2020DownLinkMicroSystemPlugin.addClustersForCell(feasibleInner, spaces, MICRO, type, sampleMicroCluster, this.getClusterRadius(), this.numberOfMicroClusters(), false);
                }
                catch (Exception e) {
                    throw new NoFeasibleShapesException("Unable to position a micro grid cluster with radius " + this.getClusterRadius() + " km inside surrounding shapes");
                }
            }
        }
        return new SystemSpaces(spaces);
    }

    public static void addClustersForCell(Polygon2D cell, List<Space> microClusters, SectorPropertyDescription desc, SectorPropertyType type, Polygon2D microCluster, double radius, int numberOfMicroClusters, boolean isRx) {
        double lowestOverlap = Double.MAX_VALUE;
        LinkedHashSet lowestOverlapPoints = new LinkedHashSet();
        for (int j = 0; j < 10; ++j) {
            LinkedHashSet<Point2D> microClusterCenters = new LinkedHashSet<Point2D>();
            double overlapScore = 0.0;
            for (int i = 0; i < numberOfMicroClusters; ++i) {
                Point2D inside = PolygonUtil.getRandomPointInside(cell);
                for (Point2D center : microClusterCenters) {
                    double distance = Mathematics.distance(inside, center);
                    if (!(distance < 2.0 * radius)) continue;
                    overlapScore += 2.0 * radius - distance;
                }
                microClusterCenters.add(inside);
            }
            if (overlapScore == 0.0) {
                lowestOverlapPoints = microClusterCenters;
                break;
            }
            if (!(overlapScore < lowestOverlap)) continue;
            lowestOverlapPoints = microClusterCenters;
            lowestOverlap = overlapScore;
        }
        for (Point2D microClusterCenter : lowestOverlapPoints) {
            ArrayList<Point2D> vertices = new ArrayList<Point2D>();
            for (Point2D vertex : microCluster.getVertices()) {
                vertices.add(vertex.add(microClusterCenter));
            }
            microClusters.add(new Space(new Polygon2D(vertices), isRx, desc, type));
        }
    }
}

