/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.UniformDistribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.VectorSpace;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.plugin.system.Context;
import org.seamcat.model.plugin.system.CorrelationMode;
import org.seamcat.model.plugin.system.Origin;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.SystemPlugin;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.CorrelationDefinitions;
import org.seamcat.model.plugin.system.optional.InterferenceNames;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.simulation.result.UniqueValueDef;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.UIToModelConverter;
import org.seamcat.model.systems.cellulargrid.HexagonCells;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkConsistencyCheck;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkSimulation;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkVictim;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020DownLinkGeneralSettings;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020DownLinkGeneralTab;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020DownLinkTransmitterUI;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Layout;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MacroBaseStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Mobile;
import org.seamcat.model.systems.imt2020downlink.ui.SystemModelIMT2020DownLink;
import org.seamcat.model.systems.ofdma.ReceiverSettings;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.Transmitter;
import org.seamcat.model.types.Unit;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.plugin.AntennaGainConfiguration;
import org.seamcat.simulation.cellular.CellularCalculations;
import org.seamcat.simulation.cellular.PathLossCorrelation;
import org.seamcat.simulation.hybrid.HybridSystemPlugin;

public class IMT2020DownLinkSystemPlugin
implements SystemPlugin<SystemModelIMT2020DownLink>,
CorrelationDefinitions,
InterferenceNames {
    public static final UniqueValueDef SIMULATION_FREQUENCY = Factory.results().single("Frequency", "MHz");
    public static final UniqueValueDef THERMAL_NOISE = Factory.results().single("Thermal noise", "dBm");
    public static final UniqueValueDef SUB_CARRIER_RATIO = Factory.results().single("Sub carrier ratio", "Ratio");
    public static final UniqueValueDef THERMAL_NOISE_UE = Factory.results().single("Thermal noise UE", "dBm");
    public static final UniqueValueDef AVGBitrateLossRefCell = Factory.results().single("Average bitrate loss (ref. cell)", "%");
    public static final UniqueValueDef AVGBitrateLossSystem = Factory.results().single("Average bitrate loss (system)", "%");
    public static final VectorDef AVGAchievedBitRateSystem = Factory.results().value("Avg Non Interfered Bitrate, system", "kbps");
    public static final VectorDef AchievedBitRateRefCell = Factory.results().value("Non Interfered Bitrate, ref cell", Unit.kbps.name());
    public static final VectorDef AVGInterferedBitRateSystem = Factory.results().value("Avg Interfered Bitrate, system", "kbps");
    public static final VectorDef InterferedBitRateRefCell = Factory.results().value("Interfered Bitrate, ref. cell", "kbps");
    public static final VectorDef SINR_SYSTEM = Factory.results().value("SINR, Victim system", "dB");
    public static final VectorDef SINR_REFCELL = Factory.results().value("SINR, Reference cell", "dB");
    private SystemModelIMT2020DownLink ui;
    private RadioSystem system;
    private HybridSystemPlugin.SectorSetup sector;
    private double cellRadius;
    private HybridSystemPlugin.SystemLayout layout;
    private int refSector;
    private int refCellId;
    private double interCellDistance;
    private HybridSystemPlugin.TierSetup tierSetup;
    private IMT2020Settings settings;

    @Override
    public void consistencyCheck(ConsistencyCheckContext context, Scenario scenario, Validator validator) {
        IMT2020DownLinkConsistencyCheck.checkMacroSystem(scenario, context, validator);
        if (context.getOrigin() == Origin.INTERFERENCE_LINK) {
            IMT2020DownLinkConsistencyCheck.checkPathLossCorrelationInterferer(context, validator);
        }
    }

    @Override
    public Bounds getSystemCoverage() {
        double min = 0.0;
        boolean isNot3GPP = this.getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        if (this.isUsingWrapAround()) {
            networkRadius *= 2.0;
        }
        VectorSpace network = VectorSpace.ZERO.addCircle(new Bounds(0.0, networkRadius, true));
        double max = network.getCoverage().getMax();
        return new Bounds(min, max, true);
    }

    @Override
    public VectorSpace getInterferenceLinkSystemCoverage(boolean victim, ConsistencyCheckContext context) {
        boolean isNot3GPP = this.getSectorSetup() == HybridSystemPlugin.SectorSetup.TriSector3GPP2 || this.getSectorSetup().getSectors() == 1;
        double cellRadius = this.getCellRadius();
        if (isNot3GPP) {
            cellRadius /= Math.sqrt(3.0);
        }
        int numberOfTiers = this.getTierSetup().ordinal();
        double networkRadius = 3.0 * cellRadius * (double)numberOfTiers + 2.0 * cellRadius;
        VectorSpace range = VectorSpace.ZERO;
        return range.addCircle(new Bounds(0.0, networkRadius, true));
    }

    @Override
    public void setUI(SystemModelIMT2020DownLink ui) {
        this.ui = ui;
        this.setLayout(ui.positioning().position());
    }

    public void setLayout(IMT2020Layout layout) {
        this.sector = layout.sectorType();
        int tiers = layout.tiers();
        this.tierSetup = tiers == 0 ? HybridSystemPlugin.TierSetup.SingleCell : (tiers == 1 ? HybridSystemPlugin.TierSetup.OneTier : HybridSystemPlugin.TierSetup.TwoTiers);
        this.cellRadius = layout.cellRadius();
        this.refCellId = layout.referenceCellId();
        this.refSector = layout.referenceSector();
        this.layout = layout.layout();
    }

    @Override
    public SystemModelIMT2020DownLink getUI() {
        return this.ui;
    }

    @Override
    public void prepareSimulation(Scenario scenario) {
        this.sector = this.ui.positioning().position().sectorType();
        IMT2020MacroBaseStation bs = this.ui.positioning().macroBS();
        AntennaGain[] antennas = CellularCalculations.createSectorAntennas(this.sector, (AntennaGainConfiguration)bs.antennaGain());
        this.cellRadius = this.ui.positioning().position().cellRadius();
        this.interCellDistance = 0.0;
        this.interCellDistance = this.sector != HybridSystemPlugin.SectorSetup.TriSector3GPP ? this.cellRadius * Mathematics.SQRT3 : this.cellRadius * 3.0;
        IMT2020DownLinkGeneralTab generalTab = this.ui.generalSettings();
        IMT2020DownLinkTransmitterUI tx = generalTab.transmitterSettings();
        IMT2020DownLinkGeneralSettings gen = generalTab.generalSettings();
        ReceiverSettings rx = generalTab.receiverSettings();
        IMT2020Mobile ms = this.ui.positioning().mobile();
        Receiver receiver = UIToModelConverter.getDmaReceiver(rx.standardDesensitisation(), rx.targetINR(), gen.receiverNoiseFigure(), rx.blockingMask(), gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersMs() / 1000.0, Factory.results().convert(generalTab.localEnvironments().receiverEnvironments()), ms.antennaGain(), ms.antennaHeight());
        Transmitter transmitter = new Transmitter(tx.emissionMask(), tx.emissionFloor().getValue(), tx.emissionFloor().isRelevant(), gen.bandwidthResourceBlock() * (double)gen.maxSubcarriersBs() / 1000.0, null, Factory.results().convert(generalTab.localEnvironments().transmitterEnvironments()), bs.antennaGain(), bs.antennaHeight(), 0.0, false);
        this.system = new RadioSystem(receiver, transmitter, generalTab.propagationModel());
        PathLossCorrelationUI plUI = generalTab.pathLossCorrelation();
        PathLossCorrelation pl = new PathLossCorrelation(plUI.usePathLossCorrelation(), plUI.pathLossVariance(), plUI.correlationFactor());
        this.settings = new IMT2020Settings(this.system, gen, pl, generalTab.transmitterSettings().bsTransmitPower(), bs.antennaHeight(), ms.azimuth(), ms.azimuthOffset(), ms.elevation(), ms.elevationOffset(), bs.azimuth(), bs.azimuthOffset(), bs.elevation(), bs.elevationOffset());
        if (antennas.length == 1) {
            this.settings.setBsGain(antennas[0]);
        } else {
            this.settings.setBsGains(antennas);
        }
        this.layout = this.ui.positioning().position().layout();
        this.refSector = this.ui.positioning().position().referenceSector();
        this.refCellId = this.ui.positioning().position().referenceCellId();
    }

    public IMT2020Settings getSettings() {
        return this.settings;
    }

    @Override
    public RadioSystem getSystem(Context context) {
        return this.system;
    }

    @Override
    public void preSimulation(Context context, Results results) {
        double frequency = context.getFrequency().trial();
        results.getSingleValueTypes().add(new DoubleResultType(SIMULATION_FREQUENCY, frequency));
        this.settings.preSimulate(results);
        double bw = this.system.getTransmitter().getBandwidth();
        UniformDistribution freq = Factory.distributionFactory().getUniformDistribution(frequency - bw / 2.0, frequency + bw / 2.0);
        context.getSystemPlugin().setFrequency(freq);
    }

    @Override
    public void postSimulation(Context context, Results results) {
        if (context.isVictim()) {
            double avgBitRateLossRefCell = Mathematics.calculateAvgPercentage(results.findVector(AchievedBitRateRefCell), results.findVector(InterferedBitRateRefCell));
            results.getSingleValueTypes().add(new DoubleResultType(AVGBitrateLossRefCell, avgBitRateLossRefCell));
            double avgBitRateLossSystem = Mathematics.calculateAvgPercentage(results.findVector(AVGAchievedBitRateSystem), results.findVector(AVGInterferedBitRateSystem));
            results.getSingleValueTypes().add(new DoubleResultType(AVGBitrateLossSystem, avgBitRateLossSystem));
        }
    }

    @Override
    public SimulationInstance simulationInstance(Context context, SystemSpaces systemSpaces) {
        return new IMT2020DownLinkSimulation(this, systemSpaces);
    }

    @Override
    public List<String> getVictimCorrelationPoints() {
        return Collections.singletonList("Victim BS ref.cell");
    }

    @Override
    public Point2D getVictimPosition(VictimResultCollector collector, String correlationPoint) {
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof IMT2020DownLinkVictim) || !((IMT2020DownLinkVictim)victim).isConnectedToReferenceCell()) continue;
            return victim.getLinkResult().txAntenna().getPosition();
        }
        return Point2D.ORIGIN;
    }

    @Override
    public List<String> getInterfererTargetPointNames() {
        return Collections.singletonList("Interfering BS ref.cell");
    }

    @Override
    public List<CorrelationMode> getCorrelationModes() {
        ArrayList<CorrelationMode> modes = new ArrayList<CorrelationMode>();
        modes.add(Factory.correlationModes().getNone());
        modes.add(Factory.correlationModes().getCorrelated());
        return modes;
    }

    @Override
    public boolean allowCoLocation() {
        return false;
    }

    @Override
    public String title() {
        return "Average over the UEs in reference cell";
    }

    @Override
    public String information() {
        return "<html>Sum of contributions of all external interferer(s) perceived by each UE in the reference cell, <br>averaged over the number of UEs in the reference cell.</html>";
    }

    @Override
    public String unwantedName() {
        return "iRSS Unwanted (external Interference)";
    }

    @Override
    public String blockingName() {
        return "iRSS Blocking (external Interference)";
    }

    public HybridSystemPlugin.SectorSetup getSectorSetup() {
        return this.sector;
    }

    public boolean triSector() {
        return this.sector != HybridSystemPlugin.SectorSetup.SingleSector;
    }

    public double getInterCellDistance() {
        return this.interCellDistance;
    }

    public boolean isUsingWrapAround() {
        return this.ui.positioning().position().generateWrapAround();
    }

    public HybridSystemPlugin.TierSetup getTierSetup() {
        return this.tierSetup;
    }

    public double getCellRadius() {
        return this.cellRadius;
    }

    public HybridSystemPlugin.SystemLayout getSystemLayout() {
        return this.layout;
    }

    public int getIndexOfReferenceCell() {
        return this.refCellId;
    }

    public int getReferenceSector() {
        return this.refSector;
    }

    @Override
    public SystemSpaces generateSystemSpaces(SystemSpaces enclosing) {
        return HexagonCells.generate(false, this.getCellRadius(), this.getTierSetup(), this.getSectorSetup(), this.getIndexOfReferenceCell());
    }
}

