/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.factory.SeamcatRandom;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.AntennaResult;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020downlink.simulation.Link;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;

class BaseStation {
    protected static final Logger LOG = Logger.getLogger(BaseStation.class);
    private boolean isAWrapAroundBS = false;
    private BaseStation corresponding;
    private Point2D offset;
    private List<Link> candidateConnections;
    private List<Link> activeConnections;
    private Point2D position;
    private IMT2020Settings settings;
    private AntennaGain ag;
    private double antennaHeight;
    private double antennaTilt;
    private String name;
    private double frequency;
    private int baseStationId;
    private int subCarriersInUse = 0;
    private SeamcatRandom random;
    private boolean referenceCell;
    private double power;

    public double getAntennaTilt() {
        return this.antennaTilt;
    }

    public double getFrequency() {
        return this.frequency;
    }

    public BaseStation(BaseStation corresponding, Point2D offset) {
        this.corresponding = corresponding;
        this.offset = offset;
        this.isAWrapAroundBS = true;
    }

    public BaseStation(String name, int baseStationId, boolean referenceCell, Point2D position, double frequency, IMT2020Settings settings, double antHeight, double antennaTilt, AntennaGain ag) {
        this.name = name;
        this.frequency = frequency;
        this.position = position;
        this.settings = settings;
        this.ag = ag;
        this.antennaHeight = antHeight;
        this.antennaTilt = antennaTilt;
        this.baseStationId = baseStationId;
        this.candidateConnections = new ArrayList<Link>();
        this.activeConnections = new ArrayList<Link>();
        this.random = RandomAccessor.getRandom();
        this.referenceCell = referenceCell;
        this.power = settings.getBSTransmitPower().trial();
    }

    public boolean isAWrapAroundBS() {
        return this.isAWrapAroundBS;
    }

    public int getBaseStationId() {
        return this.baseStationId;
    }

    public Point2D getPosition() {
        return this.position;
    }

    void setAntennaProperties(AntennaResult ant) {
        ant.setHeight(this.antennaHeight);
        ant.setTilt(this.antennaTilt);
        ant.setPosition(this.position);
    }

    public AntennaGain getAntennaGain() {
        return this.ag;
    }

    public void addCandidate(Link candidate) {
        this.candidateConnections.add(candidate);
    }

    public void removeCandidate(Link link) {
        this.candidateConnections.remove(link);
    }

    public boolean initialConnect(List<Link> activeLinks) {
        boolean candidatesAvailable;
        int sum = this.getSubCarriersInUse();
        double loadFactor = Math.rint(sum) / Math.rint(this.settings.getMaxRBsPrBS());
        boolean underLoaded = loadFactor < 1.0;
        boolean bl = candidatesAvailable = this.candidateConnections.size() > 0;
        while (underLoaded && candidatesAvailable) {
            Link candidate = this.fetchRandomCandidate();
            int temp = this.settings.getMaxRBsPrMS();
            if (sum + temp <= this.settings.getMaxRBsPrBS()) {
                sum += temp;
                double ueFrequency = this.calculateFrequency(this.activeConnections.size(), this.frequency);
                this.activeConnections.add(candidate);
                candidate.getUserTerminal().setServingLink(candidate, ueFrequency);
                activeLinks.add(candidate);
            }
            candidatesAvailable = this.candidateConnections.size() > 0;
            loadFactor = Math.rint(sum) / Math.rint(this.settings.getMaxRBsPrBS());
            underLoaded = loadFactor < 1.0 && this.settings.getMaxRBsPrMS() <= this.settings.getMaxRBsPrBS() - sum;
        }
        this.setSubCarriersInUse(sum);
        return !underLoaded;
    }

    private Link fetchRandomCandidate() {
        int i = this.random.nextInt(this.candidateConnections.size());
        return this.candidateConnections.remove(i);
    }

    public int getSubCarriersInUse() {
        return this.subCarriersInUse;
    }

    public void setSubCarriersInUse(int subCarriersInUse) {
        this.subCarriersInUse = subCarriersInUse;
    }

    public double calculateCurrentTransmitPower_Watt() {
        return this.getBSPower_Watt() * (double)this.getSubCarriersInUse() / (double)this.settings.getMaxRBsPrBS();
    }

    public double getBSPower_Watt() {
        return Mathematics.fromdBm2Watt(this.power);
    }

    public boolean isReferenceCell() {
        return this.referenceCell;
    }

    private double calculateFrequency(int linkIndex, double systemFrequency) {
        double systemBandwidth = this.settings.getSystemBandwidth();
        double numberOfSubCarrierPerMobile = this.settings.getMaxRBsPrMS();
        double numberOfSubCarriersPerBaseStation = this.settings.getMaxRBsPrBS();
        double resourceBlockBandwidth = this.settings.getBandwidthOfAnRB() * 0.001;
        double diff = systemBandwidth - numberOfSubCarriersPerBaseStation * resourceBlockBandwidth;
        return systemFrequency - systemBandwidth / 2.0 + diff / 2.0 + numberOfSubCarrierPerMobile * resourceBlockBandwidth / 2.0 * (double)(linkIndex * 2 + 1);
    }

    public BaseStation getCorresponding() {
        return this.corresponding;
    }

    public Point2D getOffset() {
        return this.offset;
    }

    public List<LocalEnvironment> getEnvironments() {
        return this.settings.getTxEnvironments();
    }

    public String getName() {
        return this.name;
    }
}

