/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import org.seamcat.function.DiscreteFunction;
import org.seamcat.model.Scenario;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.functions.BlockingMask;
import org.seamcat.model.functions.Bounds;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.MaskFunction;
import org.seamcat.model.generic.PathLossCorrelationUI;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.ConsistencyCheckContext;
import org.seamcat.model.scenariocheck.InterferingLinkCheck;
import org.seamcat.model.simulation.consistency.Validator;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020uplink.simulation.IMT2020UplinkConsistencyCheck;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.Transmitter;
import org.seamcat.presentation.WarningColors;

public class IMT2020DownLinkConsistencyCheck {
    public static void checkMacroSystem(Scenario scenario, ConsistencyCheckContext context, Validator validator) {
        IMT2020DownLinkSystemPlugin systemPlugin = (IMT2020DownLinkSystemPlugin)context.getSystemPlugin();
        IMT2020Settings settings = systemPlugin.getSettings();
        IMT2020DownLinkConsistencyCheck.checkSystemLoad(settings, validator);
        if (!context.getSystem().getReceiver().getBlockingMask().getFunction().isConstant()) {
            IMT2020DownLinkConsistencyCheck.checkBlockingMask(context.getSystem().getReceiver().getBlockingMask(), settings, validator);
        }
        Transmitter transmitter = context.getSystem().getTransmitter();
        IMT2020DownLinkConsistencyCheck.checkEmissionMask(transmitter, settings, validator);
        if (scenario.getVictim().getSystemPlugin() == systemPlugin) {
            Bounds frequencies = scenario.getVictim().getFrequency().getBounds();
            Function blockingMask = scenario.getVictim().getSystem().getReceiver().getBlockingMask().getFunction();
            if (!blockingMask.isConstant()) {
                IMT2020DownLinkConsistencyCheck.checkFrequencies(scenario, frequencies, blockingMask, settings, validator);
            }
        }
        if (settings.getPathLossCorrelation().isUsingPathLossCorrelation()) {
            IMT2020UplinkConsistencyCheck.checkPathLossCorrelation(scenario, context, validator);
        }
    }

    public static void checkMicroSystem(Scenario scenario, ConsistencyCheckContext context, Validator validator) {
        IMT2020DownLinkMicroSystemPlugin systemPlugin = (IMT2020DownLinkMicroSystemPlugin)context.getSystemPlugin();
        IMT2020Settings settings = systemPlugin.getSettings();
        IMT2020DownLinkConsistencyCheck.checkSystemLoad(settings, validator);
        if (!context.getSystem().getReceiver().getBlockingMask().getFunction().isConstant()) {
            IMT2020DownLinkConsistencyCheck.checkBlockingMask(context.getSystem().getReceiver().getBlockingMask(), settings, validator);
        }
        Transmitter transmitter = context.getSystem().getTransmitter();
        IMT2020DownLinkConsistencyCheck.checkEmissionMask(transmitter, settings, validator);
        if (scenario.getVictim().getSystemPlugin() == systemPlugin) {
            Bounds frequencies = scenario.getVictim().getFrequency().getBounds();
            Function blockingMask = scenario.getVictim().getSystem().getReceiver().getBlockingMask().getFunction();
            if (!blockingMask.isConstant()) {
                IMT2020DownLinkConsistencyCheck.checkFrequencies(scenario, frequencies, blockingMask, settings, validator);
            }
        }
        if (!context.getSystem().getReceiver().getBlockingMask().getFunction().isConstant()) {
            IMT2020DownLinkConsistencyCheck.checkBlockingMask(context.getSystem().getReceiver().getBlockingMask(), settings, validator);
        }
        if (settings.getPathLossCorrelation().isUsingPathLossCorrelation()) {
            IMT2020UplinkConsistencyCheck.checkPathLossCorrelation(scenario, context, validator);
        }
    }

    private static void checkBlockingMask(BlockingMask blockingMask, IMT2020Settings settings, Validator validator) {
        double referenceAtZero = blockingMask.getFunction().evaluate(0.0);
        double bw = 0.0;
        int usRB = settings.getMaxRBsPrMS();
        for (double f = 0.0; f < blockingMask.getFunction().getBounds().getMax(); f += 0.001) {
            if (!(Math.abs(referenceAtZero - blockingMask.getFunction().evaluate(f)) > 3.0)) continue;
            bw = f;
            break;
        }
        int rBandwidthToRB = (int)(2.0 * bw * 1000.0 / settings.getBandwidthOfAnRB());
        int tRBtolerance = (int)(0.2 * (double)usRB);
        if (Math.abs(usRB - rBandwidthToRB) > tRBtolerance) {
            validator.error("<HtMl><br/>The bandwidth of the Blocking mask (" + Math.rint(2.0 * bw * 1000.0) / 1000.0 + " MHz) conflicts with the number of RBs (" + usRB + ") allocated to the UEs.<br/><em style='color: maroon; font-weight: bold';>It is highly recommended to use a mask which complies with the number of RBs of the UEs </em>");
        }
    }

    private static void checkFrequencies(Scenario scenario, Bounds frequencies, Function blockingMask, IMT2020Settings settings, Validator validator) {
        double rFreqVrMin = frequencies.getMin();
        double rFreqVrMax = frequencies.getMax();
        DiscreteFunction func = (DiscreteFunction)blockingMask;
        double min = func.getBounds().getMin();
        double max = func.getBounds().getMax();
        for (InterferenceLink link : scenario.getInterferenceLinks()) {
            Distribution freq = link.getFrequency();
            Bounds itbounds = freq.getBounds();
            if (!itbounds.isBounded()) continue;
            String name = link.getInterferer().getName();
            if (rFreqVrMin == rFreqVrMax && itbounds.getMax() == itbounds.getMin()) {
                if (rFreqVrMax - itbounds.getMax() == 0.0) {
                    if (max < itbounds.getMax() - rFreqVrMax) {
                        validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                    if (min > rFreqVrMax - itbounds.getMin()) {
                        validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                    }
                }
                if (rFreqVrMax - itbounds.getMax() < 0.0 && max < itbounds.getMax() - rFreqVrMax) {
                    validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
                if (!(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
                validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                continue;
            }
            if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() < 0.0 && max < itbounds.getMax() - rFreqVrMin) {
                validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
            }
            if (rFreqVrMin - itbounds.getMin() < 0.0 && rFreqVrMax - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() < 0.0) {
                if (max < itbounds.getMax() - rFreqVrMin) {
                    validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
                if (min > itbounds.getMin() - rFreqVrMax) {
                    validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
            }
            if (rFreqVrMin - itbounds.getMin() >= 0.0 && rFreqVrMax - itbounds.getMax() <= 0.0) {
                if (max < itbounds.getMax() - rFreqVrMin) {
                    validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
                if (min > itbounds.getMin() - rFreqVrMax) {
                    validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
            }
            if (rFreqVrMin - itbounds.getMin() > 0.0 && rFreqVrMin - itbounds.getMax() <= 0.0 && rFreqVrMax - itbounds.getMax() > 0.0) {
                if (max < itbounds.getMax() - rFreqVrMin) {
                    validator.error("Blocking response upper limit (" + InterferingLinkCheck.fAndU(max) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMax()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMin) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
                if (min > itbounds.getMin() - rFreqVrMax) {
                    validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
                }
            }
            if (!(rFreqVrMin - itbounds.getMax() > 0.0) || !(rFreqVrMax - itbounds.getMax() > 0.0) || !(min > itbounds.getMin() - rFreqVrMax)) continue;
            validator.error("Blocking response lower limit (" + InterferingLinkCheck.fAndU(min) + ") does not match the interfering transmitter frequency (" + InterferingLinkCheck.fAndU(itbounds.getMin()) + ")<br> of Interfering Link [" + name + "] and the victim receiver frequency (" + InterferingLinkCheck.fAndU(rFreqVrMax) + ")<p " + (Object)((Object)WarningColors.MASK_WARNING) + ">This might cause unexpected results due to 'out of range' errors.");
        }
    }

    private static void checkEmissionMask(Transmitter transmitter, IMT2020Settings settings, Validator validator) {
        MaskFunction emissionMask = transmitter.getEmissionsMask().getEmissionMask();
        double referencePower = emissionMask.evaluate(0.0);
        double bw = emissionMask.getBounds().getMax() - emissionMask.getBounds().getMin();
        for (double f = 0.0; f < emissionMask.getBounds().getMax(); f += 0.1) {
            if (!(Math.abs(referencePower - emissionMask.evaluate(f)) > 23.0)) continue;
            bw = 2.0 * f;
            break;
        }
        int bsRB = settings.getMaxRBsPrBS();
        int rBandwidthToRB = (int)(bw * 1000.0 / settings.getBandwidthOfAnRB());
        int tRBtolerance = (int)(0.2 * (double)bsRB);
        if (Math.abs(rBandwidthToRB - bsRB) > tRBtolerance) {
            validator.error("<HtMl>The bandwidth of the BS emission mask (" + Math.rint(bw * 1000.0) / 1000.0 + " MHz) conflicts with the number of RBs (" + bsRB + ") allocated to the BS.<br/><em style='color: maroon; font-weight: bold';>It is highly recommended to use a mask which complies with the number of RBs of the BS </em>");
        }
    }

    private static void checkSystemLoad(IMT2020Settings settings, Validator validator) {
        int usRB;
        int bsRB = settings.getMaxRBsPrBS();
        if (bsRB % (usRB = settings.getMaxRBsPrMS()) != 0) {
            validator.error("<br/>You have selected a maximum of " + bsRB + " resource blocks per bases tation and " + usRB + " resource blocks per user. This will result in a not fully loaded system.<br />With your current settings the system can not be loaded more than " + Mathematics.round(100.0 - (double)(bsRB / usRB) / ((double)bsRB * 1.0) * 100.0) + "%");
        }
    }

    public static void checkPathLossCorrelationInterferer(ConsistencyCheckContext context, Validator validator) {
        if (context.getInterferenceLink().getCorrelationSettings().getCorrelationConfiguration(PathLossCorrelationUI.class).usePathLossCorrelation() && context.getInterferenceLink().getPropagationModel().isVariationSelected()) {
            validator.error("On the interfering link both the path loss correlation and the variations of the propagation model are selected. <br>This conflicts with the path loss correlation concept.<p " + (Object)((Object)WarningColors.ACCURARY_WARNING) + ">In order to reflect the effect of the 'pathloss correlation', it is recommended to de-select 'variations' on the propagation model " + context.getInterferenceLink().getPropagationModel().toString() + "</p>");
        }
    }
}

