/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import java.util.ArrayList;
import java.util.List;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.SimulationInstance;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.plugin.system.SystemSpaces;
import org.seamcat.model.plugin.system.optional.SectorPropertyType;
import org.seamcat.model.simulation.result.EventResult;
import org.seamcat.model.simulation.result.InterfererResultCollector;
import org.seamcat.model.simulation.result.LinkResult;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkMicroSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkCalculations;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkVictim;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020downlink.simulation.Interferer;
import org.seamcat.model.systems.imt2020downlink.simulation.Link;
import org.seamcat.model.types.InterferenceLink;
import org.seamcat.model.types.result.Results;

public class IMT2020DownLinkMicroSimulation
implements SimulationInstance {
    private IMT2020DownLinkMicroSystemPlugin plugin;
    private SystemSpaces sectorShapes;

    public IMT2020DownLinkMicroSimulation(IMT2020DownLinkMicroSystemPlugin plugin, SystemSpaces sectorShapes) {
        this.plugin = plugin;
        this.sectorShapes = sectorShapes;
    }

    @Override
    public void victimSimulation(VictimResultCollector collector) {
        Results pre = collector.getPreSimulationResults();
        List<Link> activeConnections = this.initializeSystem(pre, Point2D.ORIGIN);
        for (Link active : activeConnections) {
            collector.add(new IMT2020DownLinkVictim(collector.getPreSimulationResults(), active));
        }
        IMT2020DownLinkCalculations.calculateVictimResults(this.plugin.getSettings(), collector);
    }

    private List<Link> initializeSystem(Results pre, Point2D position) {
        double frequency = pre.findDoubleValue(IMT2020DownLinkSystemPlugin.SIMULATION_FREQUENCY);
        RadioSystem radioSystem = this.plugin.getSystem(null);
        int bsId = 0;
        ArrayList<BaseStation> baseStations = new ArrayList<BaseStation>();
        IMT2020Settings settings = this.plugin.getSettings();
        List<Space> txSpaces = this.sectorShapes.getTxSpaces();
        for (int i = 0; i < txSpaces.size(); ++i) {
            Space txSpace = txSpaces.get(i);
            for (int j = 0; j < this.plugin.numberOfBSInMicroClusters(); ++j) {
                Point2D bsPoint = position.add(PolygonUtil.getRandomPointInside(txSpace.getSpace()));
                boolean refCell = txSpace.hasProperty(SectorPropertyType.REFERENCE_CELL);
                String name = "Cluster #" + i + " BS " + (j + 1);
                baseStations.add(settings.create(name, bsId, refCell, bsPoint, frequency));
                ++bsId;
            }
        }
        return settings.positionMSsAndInitialConnectBS(radioSystem, baseStations, this.sectorShapes.getRxSpaces(), false, position, frequency);
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position) {
        Results pre = eventResult.getInterferingSystemResult(link).getPreSimulationResults();
        List<Link> activeLinks = this.initializeSystem(pre, position);
        InterfererResultCollector collector = eventResult.getInterferingSystemResult(link);
        for (Link activeLink : activeLinks) {
            BaseStation bs = activeLink.getBaseStation();
            LinkResult linkResult = Factory.results().linkResult();
            double txPower = Mathematics.fromWatt2dBm(bs.calculateCurrentTransmitPower_Watt());
            linkResult.setTxPower(txPower);
            Interferer interferer = new Interferer(link.linkIndex(), activeLink, link.getCorrelationSettings().getMinimumCouplingLoss().trial());
            collector.add(interferer);
        }
    }

    @Override
    public void interferingSystemSimulation(EventResult eventResult, InterferenceLink link, Point2D position, LinkResult positionFromCoLocation) {
    }

    @Override
    public void interferedVictimSimulation(EventResult eventResult) {
        IMT2020DownLinkCalculations.calculateInterferedVictim(eventResult, this.plugin.getSettings());
    }

    @Override
    public List<Victim> getResultingVictims(VictimResultCollector vCollector) {
        ArrayList<Victim> victims = new ArrayList<Victim>();
        for (Victim victim : vCollector.getVictims()) {
            if (!(victim instanceof IMT2020DownLinkVictim) || !((IMT2020DownLinkVictim)victim).isConnectedToReferenceCell()) continue;
            victims.add(victim);
        }
        return victims;
    }

    @Override
    public void postEvent(EventResult eventResult) {
        VictimResultCollector vCollector = eventResult.getVictimResult();
        IMT2020DownLinkCalculations.averageResults(vCollector, this.getResultingVictims(vCollector));
    }
}

