/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import org.seamcat.model.engines.InterferenceSimulationEngine;
import org.seamcat.model.functions.Function;
import org.seamcat.model.functions.FunctionException;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.simulation.result.DefaultVictimImpl;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020Settings;
import org.seamcat.model.systems.imt2020downlink.simulation.Link;
import org.seamcat.model.types.result.Results;

public class IMT2020DownLinkVictim
extends DefaultVictimImpl<IMT2020DownLinkVictim> {
    private Results pre;
    private Link connection;
    private double totalU;
    private double totalB;
    private boolean withExternalInterference = false;
    private double cache = 0.0;
    private double achievedBitrate;
    private double sinr;
    private double receivePower;
    private double interferencePower;
    private double interSystemInterference;

    public IMT2020DownLinkVictim(Results pre, Link connection) {
        super(connection.getUserTerminal().getAntennaGain(), connection.getLinkResult());
        this.pre = pre;
        this.connection = connection;
        if (connection.isWrapAroundLink()) {
            connection.getLinkResult().setValue(InterferenceSimulationEngine.SYSTEM_LINK_TYPE, "Secondary Link");
        }
    }

    @Override
    public void adjustTotalInterference(double totalU, double totalB) {
        super.adjustTotalInterference(totalU, totalB);
        this.totalU = totalU;
        this.totalB = totalB;
        this.withExternalInterference = true;
    }

    public void calculateAchievedBitrate() {
        this.calculateSINR();
        double maxAch = this.getMaxAchievableBitRate(this.sinr);
        int requestedSubCarriers = this.connection.getSettings().getMaxRBsPrMS();
        this.achievedBitrate = (double)requestedSubCarriers * (maxAch / (double)this.connection.getSettings().getMaxRBsPrBS());
    }

    private void calculateSINR() {
        this.receivePower = this.connection.getUserTerminal().getServingLink().calculateCurrentReceivePower_dBm();
        double receivePowerWatt = Mathematics.fromdBm2Watt(this.receivePower);
        double interferencePowerWatt = this.calculateTotalInterference_Watt(receivePowerWatt);
        this.interferencePower = Mathematics.fromWatt2dBm(interferencePowerWatt);
        this.sinr = Mathematics.linear2dB(receivePowerWatt / interferencePowerWatt);
    }

    private double calculateTotalInterference_Watt(double receivePowerServingLinkWatt) {
        double I_thermal_dBm = this.pre.findDoubleValue(IMT2020DownLinkSystemPlugin.THERMAL_NOISE_UE);
        double sum_Watt = this.cache;
        if (this.cache == 0.0) {
            for (Link link : this.connection.getUserTerminal().getAllLinks()) {
                double inter_dBm = link.calculateCurrentReceivePower_dBm();
                sum_Watt += Mathematics.fromdBm2Watt(inter_dBm);
            }
            this.cache = sum_Watt;
        }
        this.interSystemInterference = Mathematics.fromWatt2dBm(sum_Watt -= receivePowerServingLinkWatt);
        double I_external = 0.0;
        if (this.withExternalInterference) {
            I_external = Mathematics.linear2dB(Math.pow(10.0, this.totalU / 10.0) + Math.pow(10.0, this.totalB / 10.0));
            sum_Watt += Mathematics.fromdBm2Watt(I_external);
        }
        return Mathematics.fromdBm2Watt(I_thermal_dBm) + sum_Watt;
    }

    private double getMaxAchievableBitRate(double sinrAchieved) {
        IMT2020Settings settings = this.connection.getSettings();
        Function function = settings.getBitRateMapping();
        double value = 0.0;
        if (sinrAchieved < function.getBounds().getMin()) {
            value = function.evaluateMin();
        } else if (sinrAchieved > function.getBounds().getMax()) {
            value = function.evaluateMax();
        } else {
            try {
                value = function.evaluate(sinrAchieved);
            }
            catch (FunctionException ex) {
                throw new RuntimeException(ex);
            }
        }
        return settings.getBandwidthOfAnRB() * (double)settings.getMaxRBsPrMS() * value;
    }

    public boolean isConnectedToReferenceCell() {
        return this.connection.getBaseStation().isReferenceCell();
    }

    public double getSinr() {
        return this.sinr;
    }

    public double getAchievedBitrate() {
        return this.achievedBitrate;
    }

    public double getReceivePower() {
        return this.receivePower;
    }

    public double getInterferencePower() {
        return this.interferencePower;
    }

    public double getCurrentTransmitPower() {
        return Mathematics.fromWatt2dBm(this.connection.getBaseStation().calculateCurrentTransmitPower_Watt());
    }

    public double getInterSystemInterference() {
        return this.interSystemInterference;
    }

    public double getUEFrequency() {
        return this.connection.getUserTerminal().getFrequency();
    }

    @Override
    public boolean isSameTx(IMT2020DownLinkVictim other) {
        return other.connection.getBaseStation().getBaseStationId() == this.connection.getBaseStation().getBaseStationId();
    }

    public int getBaseStationId() {
        return this.connection.getBaseStation().getBaseStationId();
    }

    @Override
    public String getRxName() {
        return this.connection.getUserTerminal().getName();
    }

    @Override
    public String getTxName() {
        return this.connection.getBaseStation().getName();
    }
}

