/*
 * Decompiled with CFR 0.152.
 */
package org.seamcat.model.systems.imt2020downlink.simulation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;
import org.seamcat.model.RadioSystem;
import org.seamcat.model.distributions.Distribution;
import org.seamcat.model.factory.Factory;
import org.seamcat.model.factory.RandomAccessor;
import org.seamcat.model.factory.SeamcatRandom;
import org.seamcat.model.functions.Function;
import org.seamcat.model.geometry.Point2D;
import org.seamcat.model.geometry.PolygonUtil;
import org.seamcat.model.mathematics.Mathematics;
import org.seamcat.model.plugin.system.Space;
import org.seamcat.model.simulation.result.VectorDef;
import org.seamcat.model.simulation.result.Victim;
import org.seamcat.model.simulation.result.VictimResultCollector;
import org.seamcat.model.systems.imt2020downlink.IMT2020DownLinkSystemPlugin;
import org.seamcat.model.systems.imt2020downlink.simulation.BaseStation;
import org.seamcat.model.systems.imt2020downlink.simulation.IMT2020DownLinkVictim;
import org.seamcat.model.systems.imt2020downlink.simulation.Link;
import org.seamcat.model.systems.imt2020downlink.simulation.MobileStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020DownLinkGeneralSettings;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020MacroBaseStation;
import org.seamcat.model.systems.imt2020downlink.ui.IMT2020Mobile;
import org.seamcat.model.types.AntennaGain;
import org.seamcat.model.types.LocalEnvironment;
import org.seamcat.model.types.Receiver;
import org.seamcat.model.types.result.DoubleResultType;
import org.seamcat.model.types.result.Results;
import org.seamcat.simulation.cellular.CellularCalculations;
import org.seamcat.simulation.cellular.PathLossCorrelation;

public class IMT2020Settings {
    private static final Logger LOG = Logger.getLogger(IMT2020Settings.class);
    private RadioSystem system;
    private PathLossCorrelation pl;
    private double mcl;
    private Function bitRateMapping;
    private Distribution txPower;
    private double rbBandwidth;
    private double bandwidth;
    private double rnFigure;
    private double hoMargin;
    private int maxMs;
    private int maxBs;
    private final Distribution bsHeight;
    private AntennaGain bsGain;
    private AntennaGain[] bsGains;
    private IMT2020Mobile.AzimuthPointing msAzimuthPointing;
    private Distribution msAzimuthOffset;
    private IMT2020Mobile.ElevationPointing msElevationPointing;
    private Distribution msElevationOffset;
    private IMT2020MacroBaseStation.AzimuthPointing bsAzimuthPointing;
    private Distribution bsAzimuthOffset;
    private IMT2020MacroBaseStation.ElevationPointing bsElevationPointing;
    private Distribution bsElevationOffset;

    public IMT2020Settings(RadioSystem system, IMT2020DownLinkGeneralSettings gen, PathLossCorrelation pl, Distribution txPower, Distribution bsHeight, IMT2020Mobile.AzimuthPointing msAzimuthPointing, Distribution msAzimuthOffset, IMT2020Mobile.ElevationPointing msElevationPointing, Distribution msElevationOffset, IMT2020MacroBaseStation.AzimuthPointing bsAzimuthPointing, Distribution bsAzimuthOffset, IMT2020MacroBaseStation.ElevationPointing bsElevationPointing, Distribution bsElevationOffset) {
        this.system = system;
        this.pl = pl;
        this.mcl = gen.minimumCouplingLoss();
        this.bitRateMapping = gen.bitRateMapping().getFunction();
        this.txPower = txPower;
        this.rbBandwidth = gen.bandwidthResourceBlock();
        this.bandwidth = gen.bandwidth();
        this.rnFigure = gen.receiverNoiseFigure();
        this.hoMargin = gen.handoverMargin();
        this.maxMs = gen.maxSubcarriersMs();
        this.maxBs = gen.maxSubcarriersBs();
        this.bsHeight = bsHeight;
        this.msAzimuthPointing = msAzimuthPointing;
        this.msAzimuthOffset = msAzimuthOffset;
        this.msElevationPointing = msElevationPointing;
        this.msElevationOffset = msElevationOffset;
        this.bsAzimuthPointing = bsAzimuthPointing;
        this.bsAzimuthOffset = bsAzimuthOffset;
        this.bsElevationPointing = bsElevationPointing;
        this.bsElevationOffset = bsElevationOffset;
    }

    public void preSimulate(Results results) {
        double noise = CellularCalculations.calculateThermalNoise(this.getSystemBandwidth(), this.getReceiverNoiseFigure());
        results.getSingleValueTypes().add(new DoubleResultType(IMT2020DownLinkSystemPlugin.THERMAL_NOISE, noise));
        noise = CellularCalculations.calculateThermalNoise((double)this.getMaxRBsPrMS() * this.getBandwidthOfAnRB() * 0.001, this.getReceiverNoiseFigure());
        results.getSingleValueTypes().add(new DoubleResultType(IMT2020DownLinkSystemPlugin.THERMAL_NOISE_UE, noise));
        double ratio = (double)this.getMaxRBsPrMS() / (double)this.getMaxRBsPrBS();
        results.getSingleValueTypes().add(new DoubleResultType(IMT2020DownLinkSystemPlugin.SUB_CARRIER_RATIO, ratio));
    }

    public double getMinimumCouplingLoss() {
        return this.mcl;
    }

    public int getMaxRBsPrBS() {
        return this.maxBs;
    }

    public int getMaxRBsPrMS() {
        return this.maxMs;
    }

    public PathLossCorrelation getPathLossCorrelation() {
        return this.pl;
    }

    public double getHandoverMargin() {
        return this.hoMargin;
    }

    public double getReceiverNoiseFigure() {
        return this.rnFigure;
    }

    public double getSystemBandwidth() {
        return this.bandwidth;
    }

    public double getBandwidthOfAnRB() {
        return this.rbBandwidth;
    }

    public Distribution getBSTransmitPower() {
        return this.txPower;
    }

    public Function getBitRateMapping() {
        return this.bitRateMapping;
    }

    List<Link> positionMSsAndInitialConnectBS(RadioSystem system, List<BaseStation> baseStations, List<Space> rxShapes, boolean triSector, Point2D systemPosition, double frequency) {
        ArrayList<Link> activeLinks = new ArrayList<Link>();
        ArrayList<BaseStation> coreBaseStations = new ArrayList<BaseStation>();
        for (BaseStation baseStation : baseStations) {
            if (baseStation.isAWrapAroundBS()) continue;
            coreBaseStations.add(baseStation);
        }
        int K = this.getMaxRBsPrBS() / this.getMaxRBsPrMS();
        int msCount = 0;
        for (int iterations = 0; iterations < 10; ++iterations) {
            for (Space rxShape : rxShapes) {
                Receiver receiver = system.getReceiver();
                for (int i = 0; i < K; ++i) {
                    Point2D position = PolygonUtil.getRandomPointInside(rxShape.getSpace()).add(systemPosition);
                    MobileStation ue = new MobileStation(position, frequency, this, system, msCount, receiver.getAntennaGain(), receiver.getHeight().trial());
                    ++msCount;
                    ue.linkToBSAndAddToCandidateList(baseStations, triSector);
                }
            }
            boolean systemIsLoaded = true;
            for (BaseStation bs : coreBaseStations) {
                boolean bsLoaded = bs.initialConnect(activeLinks);
                systemIsLoaded = systemIsLoaded && bsLoaded;
            }
            if (!systemIsLoaded) continue;
            return activeLinks;
        }
        LOG.warn("Counld not fill system");
        return activeLinks;
    }

    private double getRandomAzimuthOffsetUE() {
        SeamcatRandom random = RandomAccessor.getRandom();
        return random.nextBoolean() ? Mathematics.convertAngleToConfineToHorizontalDefinedRange(Factory.distributionFactory().getUniformDistribution(-60.0, 60.0).trial()) : Factory.distributionFactory().getUniformDistribution(120.0, 240.0).trial();
    }

    public void collectBitRates(VectorDef system, VectorDef refCell, VictimResultCollector collector) {
        double sumRefCell = 0.0;
        double sum = 0.0;
        HashSet<Integer> uniqueBs = new HashSet<Integer>();
        for (Victim victim : collector.getVictims()) {
            if (!(victim instanceof IMT2020DownLinkVictim)) continue;
            IMT2020DownLinkVictim v = (IMT2020DownLinkVictim)victim;
            uniqueBs.add(v.getBaseStationId());
            v.calculateAchievedBitrate();
            sum += v.getAchievedBitrate();
            if (!v.isConnectedToReferenceCell()) continue;
            sumRefCell += v.getAchievedBitrate();
        }
        collector.add(system, sum / (double)uniqueBs.size());
        collector.add(refCell, sumRefCell);
    }

    public void setBsGain(AntennaGain bsGain) {
        this.bsGain = bsGain;
    }

    public void setBsGains(AntennaGain[] bsGains) {
        this.bsGains = bsGains;
    }

    public BaseStation createWrapAround(BaseStation corresponding, Point2D offset) {
        return new BaseStation(corresponding, offset);
    }

    public BaseStation create(String name, int bsIndex, boolean referenceCell, Point2D position, double frequency) {
        AntennaGain ag = this.bsGains == null ? this.bsGain : this.bsGains[bsIndex % 3];
        return new BaseStation(name, bsIndex, referenceCell, position, frequency, this, this.bsHeight.trial(), this.bsElevationOffset.trial(), ag);
    }

    public IMT2020Mobile.AzimuthPointing getMsAzimuthPointing() {
        return this.msAzimuthPointing;
    }

    public IMT2020Mobile.ElevationPointing getMsElevationPointing() {
        return this.msElevationPointing;
    }

    public IMT2020MacroBaseStation.AzimuthPointing getBsAzimuthPointing() {
        return this.bsAzimuthPointing;
    }

    public IMT2020MacroBaseStation.ElevationPointing getBsElevationPointing() {
        return this.bsElevationPointing;
    }

    public Distribution getMsAzimuthOffset() {
        return this.msAzimuthOffset;
    }

    public Distribution getMsElevationOffset() {
        return this.msElevationOffset;
    }

    public Distribution getBsAzimuthOffset() {
        return this.bsAzimuthOffset;
    }

    public Distribution getBsElevationOffset() {
        return this.bsElevationOffset;
    }

    public List<LocalEnvironment> getRxEnvironments() {
        return this.system.getReceiver().getLocalEnvironments();
    }

    public List<LocalEnvironment> getTxEnvironments() {
        return this.system.getTransmitter().getLocalEnvironments();
    }
}

